/*
 * Decompiled with CFR 0.152.
 */
package mca.core.forge;

import java.util.ArrayList;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.core.minecraft.ModItems;
import mca.data.PlayerData;
import mca.entity.EntityHuman;
import mca.enums.EnumProfession;
import mca.enums.EnumProfessionGroup;
import mca.items.ItemGemCutter;
import mca.packets.PacketSyncConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.data.AbstractPlayerData;
import radixcore.math.Point3D;
import radixcore.packets.PacketDataContainer;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;
import radixcore.util.SchematicHandler;

public class EventHooksFML {
    public static boolean playPortalAnimation;
    private int clientTickCounter;
    private int serverTickCounter;

    @SubscribeEvent
    public void onConfigChanges(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("MCA")) {
            MCA.getConfig().getInstance().save();
            MCA.getConfig().syncConfiguration();
        }
    }

    @SubscribeEvent
    public void playerLoggedInEventHandler(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        PlayerData data = null;
        if (!MCA.playerDataMap.containsKey(player.func_110124_au().toString())) {
            data = new PlayerData(player);
            if (data.dataExists()) {
                data = (PlayerData)data.readDataFromFile(event.player, PlayerData.class, null);
            } else {
                data.initializeNewData(event.player);
            }
            MCA.playerDataMap.put(event.player.func_110124_au().toString(), data);
        } else {
            data = MCA.getPlayerData(player);
            if (data != null) {
                data = (PlayerData)data.readDataFromFile(event.player, PlayerData.class, null);
                MCA.playerDataMap.put(event.player.func_110124_au().toString(), data);
            }
        }
        MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketDataContainer("MCA", (AbstractPlayerData)data), (EntityPlayerMP)event.player);
        MCA.getPacketHandler().sendPacketToPlayer(new PacketSyncConfig(MCA.getConfig()), (EntityPlayerMP)event.player);
        if (!data.getHasChosenDestiny() && !player.field_71071_by.func_146028_b((Item)ModItems.crystalBall) && MCA.getConfig().giveCrystalBall) {
            player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.crystalBall));
        }
    }

    @SubscribeEvent
    public void playerLoggedOutEventHandler(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerData data = MCA.getPlayerData(event.player);
        if (data != null) {
            data.saveDataToFile();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTickEventHandler(TickEvent.ClientTickEvent event) {
        MCA.getPacketHandler().processPackets(Side.CLIENT);
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen currentScreen = mc.field_71462_r;
        if (currentScreen instanceof GuiMainMenu && MCA.playerDataContainer != null) {
            playPortalAnimation = false;
            MCA.destinyCenterPoint = null;
            MCA.destinySpawnFlag = false;
            MCA.playerDataContainer = null;
            MCA.resetConfig();
        }
        if (currentScreen instanceof GuiLanguage) {
            MCA.reloadLanguage = true;
        } else if (MCA.reloadLanguage) {
            MCA.reloadLanguage = false;
            MCA.getLanguageManager().loadLanguage(MCA.getLanguageManager().getGameLanguageID());
        }
        if (playPortalAnimation) {
            EntityPlayerSP player = mc.field_71439_g;
            player.field_71080_cy = player.field_71086_bY;
            player.field_71086_bY -= 0.0125f;
            if (player.field_71086_bY <= 0.0f) {
                playPortalAnimation = false;
            }
        }
        if (this.clientTickCounter <= 0) {
            this.clientTickCounter = 10;
            if (MCA.destinySpawnFlag) {
                SchematicHandler.spawnStructureRelativeToPoint((String)"/assets/mca/schematic/destiny-test.schematic", (Point3D)MCA.destinyCenterPoint, (World)mc.field_71441_e);
            }
        } else {
            --this.clientTickCounter;
        }
    }

    @SubscribeEvent
    public void serverTickEventHandler(TickEvent.ServerTickEvent event) {
        MCA.getPacketHandler().processPackets(Side.SERVER);
        if (this.serverTickCounter % 40 == 0) {
            for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                for (int i = 0; i < world.field_72996_f.size(); ++i) {
                    Object obj = world.field_72996_f.get(i);
                    if (!(obj instanceof EntityVillager)) continue;
                    EntityVillager villager = (EntityVillager)obj;
                    try {
                        if (villager.func_70096_w().func_75679_c(28) != 3577) continue;
                        this.doOverwriteVillager(villager);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.serverTickCounter <= 0 && MCA.getConfig().guardSpawnRate > 0) {
            ArrayList<EntityHuman> humans = new ArrayList<EntityHuman>();
            for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                for (Object obj : world.field_72996_f) {
                    if (!(obj instanceof EntityHuman)) continue;
                    humans.add((EntityHuman)((Object)obj));
                }
            }
            if (!humans.isEmpty()) {
                for (int i = 0; i < 3; ++i) {
                    EntityHuman human = (EntityHuman)((Object)humans.get(RadixMath.getNumberInRange((int)0, (int)(humans.size() - 1))));
                    int neededNumberOfGuards = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)human, (int)50).size() / MCA.getConfig().guardSpawnRate;
                    int numberOfGuards = 0;
                    for (Entity entity : RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)human, (int)50)) {
                        EntityHuman otherHuman;
                        if (!(entity instanceof EntityHuman) || (otherHuman = (EntityHuman)entity).getProfessionGroup() != EnumProfessionGroup.Guard) continue;
                        ++numberOfGuards;
                    }
                    if (numberOfGuards >= neededNumberOfGuards) continue;
                    EntityHuman guard = new EntityHuman(human.field_70170_p, RadixLogic.getBooleanWithProbability((int)50), EnumProfession.Guard.getId(), false);
                    Vec3 pos = RandomPositionGenerator.func_75463_a((EntityCreature)human, (int)10, (int)1);
                    if (pos == null) continue;
                    Point3D posAsPoint = new Point3D(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                    if (!BlockHelper.canBlockSeeTheSky((World)human.field_70170_p, (int)posAsPoint.iPosX, (int)((int)human.field_70163_u), (int)posAsPoint.iPosZ)) continue;
                    guard.func_70107_b(pos.field_72450_a, (int)human.field_70163_u, pos.field_72449_c);
                    human.field_70170_p.func_72838_d((Entity)guard);
                }
            }
            this.serverTickCounter = 1200;
        }
        --this.serverTickCounter;
    }

    @SubscribeEvent
    public void itemCraftedEventHandler(PlayerEvent.ItemCraftedEvent event) {
        block4: {
            ItemStack stack;
            Item craftedItem = event.crafting.func_77973_b();
            EntityPlayer player = event.player;
            if (craftedItem == ModItems.diamondHeart || craftedItem == ModItems.diamondOval || craftedItem == ModItems.diamondSquare || craftedItem == ModItems.diamondStar || craftedItem == ModItems.diamondTiny || craftedItem == ModItems.diamondTriangle) {
                player.func_71029_a((StatBase)ModAchievements.craftShapedDiamond);
            } else if (craftedItem == ModItems.engagementRingHeart || craftedItem == ModItems.engagementRingOval || craftedItem == ModItems.engagementRingSquare || craftedItem == ModItems.engagementRingStar || craftedItem == ModItems.engagementRingTiny || craftedItem == ModItems.engagementRingTriangle || craftedItem == ModItems.engagementRingHeartRG || craftedItem == ModItems.engagementRingOvalRG || craftedItem == ModItems.engagementRingSquareRG || craftedItem == ModItems.engagementRingStarRG || craftedItem == ModItems.engagementRingTinyRG || craftedItem == ModItems.engagementRingTriangleRG) {
                player.func_71029_a((StatBase)ModAchievements.craftShapedRing);
            }
            int i = 0;
            if (i >= event.craftMatrix.func_70302_i_() || (stack = event.craftMatrix.func_70301_a(i)) == null || !(stack.func_77973_b() instanceof ItemGemCutter) && stack.func_77973_b() != ModItems.needleAndString) break block4;
            stack.func_96631_a(1, event.player.func_70681_au());
            if (stack.func_77952_i() < stack.func_77958_k()) {
                event.player.field_71071_by.func_70441_a(stack);
            }
            player.func_71029_a((StatBase)ModAchievements.craftShapedDiamond);
        }
    }

    @SubscribeEvent
    public void itemSmeltedEventHandler(PlayerEvent.ItemSmeltedEvent event) {
        Item smeltedItem = event.smelting.func_77973_b();
        EntityPlayer player = event.player;
    }

    private void doOverwriteVillager(EntityVillager entity) {
        entity.func_70106_y();
        MCA.naturallySpawnVillagers(new Point3D(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), entity.field_70170_p, entity.func_70946_n());
    }
}

