/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render;

import java.util.ArrayList;
import mca.ai.AIConverse;
import mca.ai.AISleep;
import mca.client.gui.GuiInteraction;
import mca.client.gui.GuiVillagerEditor;
import mca.client.model.ModelHuman;
import mca.core.MCA;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.util.UVPoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import radixcore.client.render.RenderHelper;
import radixcore.util.RadixMath;

public class RenderHuman
extends RenderBiped {
    private static final ResourceLocation gui = new ResourceLocation("mca:textures/gui.png");
    private static final UVPoint exMark = new UVPoint(55, 18, 3, 13);
    private static final UVPoint minus = new UVPoint(69, 23, 7, 3);
    private static final UVPoint plus = new UVPoint(85, 21, 7, 7);
    private static final float LABEL_SCALE = 0.027f;
    private final ModelBiped modelArmorPlate;
    private final ModelBiped modelArmor;

    public RenderHuman() {
        super(Minecraft.func_71410_x().func_175598_ae(), (ModelBiped)new ModelHuman(0.0f), 0.5f);
        this.field_77071_a = (ModelBiped)this.field_77045_g;
        this.modelArmorPlate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
        LayerBipedArmor layerbipedarmor = new LayerBipedArmor((RendererLivingEntity)this){

            protected void func_177177_a() {
                this.field_177189_c = new ModelBiped(0.5f);
                this.field_177186_d = new ModelBiped(1.0f);
            }
        };
        this.func_177094_a((LayerRenderer)layerbipedarmor);
    }

    protected void func_77041_b(EntityLivingBase entityLivingBase, float partialTickTime) {
        float scale;
        EntityHuman entity = (EntityHuman)entityLivingBase;
        AISleep sleepAI = entity.getAI(AISleep.class);
        float f = scale = entity.getIsMale() ? 0.9375f : 0.915f;
        if (entity.getIsChild()) {
            boolean doGradualGrowth = MCA.getConfig().isAgingEnabled;
            float growthFactor = (entity.getIsMale() ? 0.39f : 0.37f) / (float)MCA.getConfig().childGrowUpTime * (float)entity.func_70654_ax();
            scale = 0.55f + growthFactor;
            if (entityLivingBase.field_70154_o != null) {
                if (entityLivingBase.field_70154_o instanceof EntityHorse) {
                    GL11.glTranslated((double)0.0, (double)((double)growthFactor - 0.3), (double)0.2);
                } else {
                    GL11.glTranslated((double)0.0, (double)(1.0 + (double)growthFactor + (double)growthFactor), (double)0.2);
                }
            }
        }
        GL11.glScalef((float)scale, (float)(scale + entity.getHeight()), (float)scale);
        GL11.glScalef((float)(scale + entity.getGirth()), (float)scale, (float)(scale + entity.getGirth()));
        if (sleepAI.getIsInBed()) {
            this.renderHumanSleeping(entity, partialTickTime);
        } else if (entityLivingBase.field_70154_o != null) {
            GL11.glTranslated((double)0.0, (double)0.55, (double)0.1);
        }
    }

    public void func_77033_b(EntityLivingBase entityLivingBase, double posX, double posY, double posZ) {
        super.func_77033_b(entityLivingBase, posX, posY, posZ);
        EntityHuman human = (EntityHuman)entityLivingBase;
        AIConverse converseAI = human.getAI(AIConverse.class);
        int currentHealth = (int)human.func_110143_aJ();
        int maxHealth = (int)human.func_110138_aP();
        double distanceFromPlayer = RadixMath.getDistanceToEntity((Entity)human, (Entity)Minecraft.func_71410_x().field_71439_g);
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiVillagerEditor) {
            return;
        }
        if (currentHealth < maxHealth) {
            this.renderLabel(human, posX, posY, posZ, MCA.getLanguageManager().getString("label.health") + currentHealth + "/" + maxHealth);
        } else if (this.canRenderNameTag(entityLivingBase) && MCA.getConfig().showNameTagOnHover) {
            this.renderLabel(human, posX, posY, posZ, human.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        } else if (human.displayNameForPlayer) {
            this.renderLabel(human, posX, posY + distanceFromPlayer / 15.0 + (double)human.getHeight() * 1.15, posZ, human.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            this.renderHearts(human, posX, posY + distanceFromPlayer / 15.0 + (double)human.getHeight() * 1.15, posZ, human.getPlayerMemory((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getHearts());
        } else if (human.getAIManager().isToggleAIActive()) {
            this.renderLabel(human, posX, posY + distanceFromPlayer / 15.0 + (double)human.getHeight() * 1.15, posZ, human.getAIManager().getNameOfActiveAI());
        } else if (converseAI.getConversationActive() && distanceFromPlayer <= 6.0 && MCA.getConfig().showVillagerConversations) {
            String conversationString = "conversation" + converseAI.getConversationID() + ".progress" + converseAI.getConversationProgress();
            boolean elevateLabel = converseAI.getConversationProgress() % 2 == 0;
            double d = posY = elevateLabel ? posY + 0.25 : posY;
            if (converseAI.getConversationProgress() != 0) {
                this.renderLabel(human, posX, posY, posZ, MCA.getLanguageManager().getString(conversationString));
            }
        }
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        EntityHuman human = (EntityHuman)entity;
        String skinName = human.getHeadTexture();
        if (skinName.isEmpty()) {
            return new ResourceLocation("minecraft:textures/entity/steve.png");
        }
        if (human.getPlayerSkinResourceLocation() != null) {
            return human.getPlayerSkinResourceLocation();
        }
        return new ResourceLocation(((EntityHuman)entity).getHeadTexture());
    }

    private void renderHuman(EntityHuman entity, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        EnumAction useAction;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        PlayerMemory memory = entity.getPlayerMemoryWithoutCreating((EntityPlayer)player);
        if (!entity.getDoDisplay()) {
            return;
        }
        if (RadixMath.getDistanceToEntity((Entity)entity, (Entity)player) <= 5.0 && !entity.getAI(AISleep.class).getIsSleeping() && !entity.displayNameForPlayer && memory != null) {
            UVPoint uvp;
            UVPoint uVPoint = memory.doDisplayFeedback() ? (memory.getLastInteractionSuccess() ? plus : minus) : (uvp = memory.getHasQuest() ? exMark : null);
            if (uvp != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)posX), (float)((float)posY + entity.field_70131_O + 0.25f + 0.5f), (float)((float)posZ));
                GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)0.0f, (float)9.259259f, (float)0.0f);
                RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX), (int)((int)posY + 12), (int)uvp.getU(), (int)uvp.getV(), (int)uvp.getWidth(), (int)uvp.getHeight());
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
            }
        }
        double posYCorrection = posY - entity.func_70033_W();
        this.field_76987_f = 1.0f;
        ItemStack heldItem = entity.func_70694_bm();
        this.field_77071_a.field_78120_m = heldItem == null ? 0 : 1;
        this.modelArmor.field_78120_m = this.field_77071_a.field_78120_m;
        this.modelArmorPlate.field_78120_m = this.field_77071_a.field_78120_m;
        this.modelArmor.field_78117_n = this.field_77071_a.field_78117_n = entity.func_70093_af();
        this.modelArmorPlate.field_78117_n = this.field_77071_a.field_78117_n;
        if (heldItem != null && (useAction = heldItem.func_77975_n()) == EnumAction.BOW) {
            this.field_77071_a.field_78118_o = true;
            this.modelArmor.field_78118_o = true;
            this.modelArmorPlate.field_78118_o = true;
        }
        if (entity.func_70093_af()) {
            posYCorrection -= 0.125;
        }
        super.func_76986_a((EntityLiving)entity, posX, posYCorrection, posZ, rotationYaw, rotationPitch);
        this.field_77071_a.field_78118_o = false;
        this.modelArmor.field_78118_o = false;
        this.modelArmorPlate.field_78118_o = false;
        this.field_77071_a.field_78117_n = false;
        this.modelArmor.field_78117_n = false;
        this.modelArmorPlate.field_78117_n = false;
        this.field_77071_a.field_78120_m = 0;
        this.modelArmor.field_78120_m = 0;
        this.modelArmorPlate.field_78120_m = 0;
    }

    protected void renderHumanSleeping(EntityHuman entity, double partialTickTime) {
        AISleep sleepAI = entity.getAI(AISleep.class);
        int meta = sleepAI.getBedMeta();
        if (meta == 0) {
            entity.field_70759_as = 180.0f;
            GL11.glTranslated((double)-0.5, (double)0.0, (double)0.0);
            GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.75);
        } else if (meta == 3) {
            entity.field_70759_as = 90.0f;
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
            GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.75);
        } else if (meta == 2) {
            entity.field_70759_as = 0.0f;
            GL11.glTranslated((double)0.5, (double)0.0, (double)-1.0);
            GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.75);
        } else if (meta == 1) {
            entity.field_70759_as = -90.0f;
            GL11.glTranslated((double)-0.5, (double)0.0, (double)-1.0);
            GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.75);
        }
    }

    public void func_76986_a(Entity entity, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        this.renderHuman((EntityHuman)entity, posX, posY, posZ, rotationYaw, rotationPitch);
    }

    public void func_76986_a(EntityLiving entityLiving, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        this.renderHuman((EntityHuman)entityLiving, posX, posY, posZ, rotationYaw, rotationPitch);
    }

    private void renderHearts(EntityHuman human, double posX, double posY, double posZ, int heartsLevel) {
        try {
            int clampedHearts = RadixMath.clamp((int)((Math.abs(heartsLevel) + 5) / 10), (int)0, (int)10);
            boolean isNegative = heartsLevel < 0;
            int goldHearts = isNegative ? 0 : clampedHearts - 5;
            int heartU = 5;
            int goldHeartU = 37;
            int negHeartU = 21;
            clampedHearts = RadixMath.clamp((int)clampedHearts, (int)0, (int)5);
            ArrayList<Integer> heartsToDraw = new ArrayList<Integer>();
            while (goldHearts > 0) {
                heartsToDraw.add(37);
                --goldHearts;
            }
            while (heartsToDraw.size() < clampedHearts) {
                if (isNegative) {
                    heartsToDraw.add(21);
                    continue;
                }
                heartsToDraw.add(5);
            }
            if (!heartsToDraw.isEmpty()) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)posX + 0.0f), (float)((float)posY + human.field_70131_O + 0.25f), (float)((float)posZ));
                GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)0.0f, (float)9.259259f, (float)0.0f);
                switch (heartsToDraw.size()) {
                    case 1: {
                        RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 20 - 22), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(0)), (int)20, (int)9, (int)9);
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < 2; ++i) {
                            RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 9), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 3; ++i) {
                            RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 14), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < 4; ++i) {
                            RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 19), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < 5; ++i) {
                            RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 23), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                }
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void renderLabel(EntityHuman human, double posX, double posY, double posZ, String labelText) {
        this.func_147906_a((Entity)human, labelText, posX, posY, posZ, 64);
    }

    protected boolean canRenderNameTag(EntityLivingBase entityRendering) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        Vec3 entityLookVector = new Vec3(entityRendering.field_70165_t - entityPlayer.field_70165_t, entityRendering.func_174813_aQ().field_72338_b - 3.0 + (double)entityRendering.field_70131_O / 2.0 - entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e(), entityRendering.field_70161_v - entityPlayer.field_70161_v).func_72432_b();
        double dotProduct = entityPlayer.func_70676_i(1.0f).func_72432_b().func_72430_b(entityLookVector);
        boolean isPlayerLookingAt = dotProduct > 1.0 - 0.025 / entityLookVector.func_72433_c() ? entityPlayer.func_70685_l((Entity)entityRendering) : false;
        double distance = entityRendering.func_70032_d(this.field_76990_c.field_78734_h);
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiInteraction) && distance < 5.0 && isPlayerLookingAt && Minecraft.func_71382_s() && entityRendering != this.field_76990_c.field_78734_h && !entityRendering.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && entityRendering.field_70153_n == null;
    }
}

