/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.ArrayList;
import java.util.List;
import mca.ai.AbstractAI;
import mca.blocks.BlockVillagerBed;
import mca.entity.EntityHuman;
import mca.enums.EnumMovementState;
import mca.enums.EnumProfessionGroup;
import mca.enums.EnumSleepingState;
import mca.tile.TileVillagerBed;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import radixcore.data.WatchedBoolean;
import radixcore.data.WatchedInt;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixExcept;
import radixcore.util.RadixLogic;

public class AISleep
extends AbstractAI {
    private WatchedInt sleepingState;
    private WatchedBoolean isInBed;
    private WatchedBoolean hasBed;
    private WatchedInt bedMeta;
    private double homePosX;
    private double homePosY;
    private double homePosZ;
    private WatchedInt bedPosX;
    private WatchedInt bedPosY;
    private WatchedInt bedPosZ;

    public AISleep(EntityHuman owner) {
        super(owner);
        this.sleepingState = new WatchedInt(EnumSleepingState.AWAKE.getId(), 46, owner.getDataWatcherEx());
        this.isInBed = new WatchedBoolean(false, 16, owner.getDataWatcherEx());
        this.bedMeta = new WatchedInt(0, 17, owner.getDataWatcherEx());
        this.hasBed = new WatchedBoolean(false, 18, owner.getDataWatcherEx());
        this.bedPosX = new WatchedInt(0, 19, owner.getDataWatcherEx());
        this.bedPosY = new WatchedInt(0, 20, owner.getDataWatcherEx());
        this.bedPosZ = new WatchedInt(0, 21, owner.getDataWatcherEx());
        this.homePosY = -1.0;
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        boolean isDaytime = this.owner.field_70170_p.func_72935_r();
        if (this.owner.getAIManager().isToggleAIActive() || this.owner.getMovementState() == EnumMovementState.FOLLOW || this.owner.field_70154_o != null || this.owner.getProfessionGroup() == EnumProfessionGroup.Guard && !this.owner.getIsMarried()) {
            if (!isDaytime && this.getSleepingState() != EnumSleepingState.INTERRUPTED) {
                this.setSleepingState(EnumSleepingState.INTERRUPTED);
            }
            return;
        }
        switch (this.getSleepingState()) {
            case AWAKE: {
                if (!isDaytime && this.hasHomePoint() && this.isHomePointValid()) {
                    if (!this.hasHomePoint() || !this.isHomePointValid()) break;
                    this.owner.func_70107_b(this.homePosX, this.homePosY, this.homePosZ);
                    this.trySleepInBed();
                    this.setSleepingState(EnumSleepingState.SLEEPING);
                    break;
                }
                if (this.hasHomePoint() && this.isHomePointValid()) break;
                String phrase = !this.hasHomePoint() ? "sleep.nohome" : "sleep.invalid";
                boolean isInfluencedByPlayer = this.owner.isMarriedToAPlayer() || this.owner.getMotherId() < 0 || this.owner.getFatherId() < 0;
                EntityPlayer influentialPlayer = this.getInfluentialPlayer();
                if (isInfluencedByPlayer && influentialPlayer != null) {
                    this.owner.say(phrase, influentialPlayer);
                    this.setSleepingState(EnumSleepingState.NO_HOME);
                    break;
                }
                this.setHomePoint(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
                break;
            }
            case SLEEPING: {
                if (!isDaytime) break;
                this.setSleepingState(EnumSleepingState.AWAKE);
                break;
            }
            case INTERRUPTED: {
                if (!isDaytime) break;
                this.setSleepingState(EnumSleepingState.AWAKE);
                break;
            }
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("sleepingState", this.sleepingState.getInt());
        nbt.func_74757_a("isInBed", this.isInBed.getInt() != 0);
        nbt.func_74768_a("bedMeta", this.bedMeta.getInt());
        nbt.func_74757_a("hasBed", this.hasBed.getBoolean().booleanValue());
        nbt.func_74780_a("homePosX", this.homePosX);
        nbt.func_74780_a("homePosY", this.homePosY);
        nbt.func_74780_a("homePosZ", this.homePosZ);
        nbt.func_74768_a("bedPosX", this.bedPosX.getInt());
        nbt.func_74768_a("bedPosY", this.bedPosY.getInt());
        nbt.func_74768_a("bedPosZ", this.bedPosZ.getInt());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.sleepingState.setValue((Object)nbt.func_74762_e("sleepingState"));
        this.isInBed.setValue((Object)nbt.func_74767_n("isInBed"));
        this.bedMeta.setValue((Object)nbt.func_74762_e("bedMeta"));
        this.hasBed.setValue((Object)nbt.func_74767_n("hasBed"));
        this.bedPosX.setValue((Object)nbt.func_74762_e("bedPosX"));
        this.bedPosY.setValue((Object)nbt.func_74762_e("bedPosY"));
        this.bedPosZ.setValue((Object)nbt.func_74762_e("bedPosZ"));
        this.homePosX = nbt.func_74769_h("homePosX");
        this.homePosY = nbt.func_74769_h("homePosY");
        this.homePosZ = nbt.func_74769_h("homePosZ");
    }

    private EntityPlayer getInfluentialPlayer() {
        if (this.owner.isMarriedToAPlayer()) {
            return this.owner.getPlayerSpouse();
        }
        if (this.owner.getMotherId() < 0 || this.owner.getFatherId() < 0) {
            for (Object obj : this.owner.field_70170_p.field_73010_i) {
                EntityPlayer player = (EntityPlayer)obj;
                if (!this.owner.isPlayerAParent(player)) continue;
                return player;
            }
        }
        return null;
    }

    public boolean getIsSleeping() {
        return this.getSleepingState() == EnumSleepingState.SLEEPING;
    }

    public void setSleepingState(EnumSleepingState state) {
        this.sleepingState.setValue((Object)state.getId());
        if (state == EnumSleepingState.SLEEPING) {
            this.transitionSkinState(true);
        } else {
            this.transitionSkinState(false);
            this.isInBed.setValue((Object)false);
            try {
                TileVillagerBed villagerBed = (TileVillagerBed)BlockHelper.getTileEntity((World)this.owner.field_70170_p, (int)this.bedPosX.getInt(), (int)this.bedPosY.getInt(), (int)this.bedPosZ.getInt());
                villagerBed.setSleepingVillagerId(-1);
                villagerBed.setIsVillagerSleepingIn(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public EnumSleepingState getSleepingState() {
        return EnumSleepingState.fromId(this.sleepingState.getInt());
    }

    public boolean isHomePointValid() {
        if (this.homePosY == -1.0) {
            return false;
        }
        Point3D point = new Point3D(this.homePosX, this.homePosY, this.homePosZ);
        return Utilities.isPointClear(this.owner.field_70170_p, point.iPosX, point.iPosY, point.iPosZ) && Utilities.isPointClear(this.owner.field_70170_p, point.iPosX, point.iPosY + 1, point.iPosZ);
    }

    public boolean hasHomePoint() {
        return this.homePosY != -1.0;
    }

    public void invalidateHomePoint() {
        this.homePosY = -1.0;
    }

    public boolean setHomePoint(double posX, double posY, double posZ) {
        Point3D point = new Point3D(posX, posY, posZ);
        if (Utilities.isPointClear(this.owner.field_70170_p, point.iPosX, point.iPosY, point.iPosZ) && Utilities.isPointClear(this.owner.field_70170_p, point.iPosX, point.iPosY + 1, point.iPosZ)) {
            this.homePosX = posX;
            this.homePosY = posY;
            this.homePosZ = posZ;
            return true;
        }
        return false;
    }

    public void transitionSkinState(boolean toSleeping) {
        String skinValue = this.owner.getHeadTexture();
        if (toSleeping && !skinValue.contains("sleeping")) {
            this.owner.setHeadTexture(skinValue.replace("/skins/", "/skins/sleeping/"));
        } else if (!toSleeping && skinValue.contains("sleeping")) {
            this.owner.setHeadTexture(skinValue.replace("/skins/sleeping/", "/skins/"));
        }
    }

    public int getBedMeta() {
        return this.bedMeta.getInt();
    }

    public boolean getIsInBed() {
        return this.isInBed.getBoolean();
    }

    private void trySleepInBed() {
        if (this.hasBed.getBoolean().booleanValue()) {
            Block blockAtBed = BlockHelper.getBlock((World)this.owner.field_70170_p, (int)this.bedPosX.getInt(), (int)this.bedPosY.getInt(), (int)this.bedPosZ.getInt());
            if (blockAtBed instanceof BlockVillagerBed) {
                try {
                    TileVillagerBed villagerBed = (TileVillagerBed)BlockHelper.getTileEntity((World)this.owner.field_70170_p, (int)this.bedPosX.getInt(), (int)this.bedPosY.getInt(), (int)this.bedPosZ.getInt());
                    if (!villagerBed.getIsVillagerSleepingIn()) {
                        villagerBed.setSleepingVillagerId(this.owner.getPermanentId());
                        villagerBed.setIsVillagerSleepingIn(true);
                        this.isInBed.setValue((Object)true);
                        this.owner.halt();
                        this.owner.func_70107_b(this.bedPosX.getInt(), this.bedPosY.getInt(), this.bedPosZ.getInt());
                    }
                }
                catch (ClassCastException e) {
                    RadixExcept.logErrorCatch((Throwable)e, (String)"Catching non-fatal ClassCastException when villager bed was expected. Investigate mod compatibility issues.");
                    this.hasBed.setValue((Object)false);
                }
                catch (NullPointerException e) {
                    this.hasBed.setValue((Object)false);
                }
            } else {
                this.hasBed.setValue((Object)false);
            }
        } else {
            List bedsNearby = RadixLogic.getNearbyBlocks((Entity)this.owner, BlockVillagerBed.class, (int)8);
            ArrayList<Point3D> bedFeetNearby = new ArrayList<Point3D>();
            for (Point3D point : bedsNearby) {
                BlockBed.EnumPartType part;
                IBlockState state = this.owner.field_70170_p.func_180495_p(new BlockPos(point.iPosX, point.iPosY, point.iPosZ));
                if (!(state.func_177230_c() instanceof BlockVillagerBed) || (part = (BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a)) != BlockBed.EnumPartType.FOOT) continue;
                bedFeetNearby.add(point);
            }
            if (bedFeetNearby.size() > 0) {
                Point3D nearestBed = Point3D.getNearestPointInList((Point3D)new Point3D(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v), bedFeetNearby);
                TileVillagerBed villagerBed = (TileVillagerBed)BlockHelper.getTileEntity((World)this.owner.field_70170_p, (int)nearestBed.iPosX, (int)nearestBed.iPosY, (int)nearestBed.iPosZ);
                if (villagerBed != null && !villagerBed.getIsVillagerSleepingIn()) {
                    villagerBed.setSleepingVillagerId(this.owner.getPermanentId());
                    villagerBed.setIsVillagerSleepingIn(true);
                    this.bedPosX.setValue((Object)nearestBed.iPosX);
                    this.bedPosY.setValue((Object)nearestBed.iPosY);
                    this.bedPosZ.setValue((Object)nearestBed.iPosZ);
                    this.bedMeta.setValue((Object)BlockHelper.getBlockMetadata((World)this.owner.field_70170_p, (int)this.bedPosX.getInt(), (int)this.bedPosY.getInt(), (int)this.bedPosZ.getInt()));
                    this.hasBed.setValue((Object)true);
                    this.isInBed.setValue((Object)true);
                    this.owner.halt();
                    this.owner.func_70107_b(this.bedPosX.getInt(), this.bedPosY.getInt(), this.bedPosZ.getInt());
                }
            }
        }
    }
}

