/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import mca.ai.AbstractAI;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.entity.EntityHuman;
import mca.enums.EnumBabyState;
import mca.enums.EnumProgressionStep;
import mca.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumParticleTypes;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AIProgressStory
extends AbstractAI {
    private int ticksUntilNextProgress;
    private int babyAge;
    private int numChildren;
    private boolean isDominant = true;
    private EnumProgressionStep progressionStep;
    private boolean forceNextProgress;

    public AIProgressStory(EntityHuman entityHuman) {
        super(entityHuman);
        this.ticksUntilNextProgress = MCA.getConfig() != null ? MCA.getConfig().storyProgressionRate : 20;
        this.setProgressionStep(EnumProgressionStep.SEARCH_FOR_PARTNER);
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (MCA.getConfig().storyProgression && this.owner.getTicksAlive() >= MCA.getConfig().storyProgressionThreshold * 1200 && this.isDominant && !this.owner.getIsChild() && !this.owner.getIsEngaged()) {
            if (this.ticksUntilNextProgress <= 0 || this.forceNextProgress) {
                this.ticksUntilNextProgress = MCA.getConfig().storyProgressionRate * 1200;
                if (RadixLogic.getBooleanWithProbability((int)75)) {
                    switch (this.progressionStep) {
                        case FINISHED: {
                            break;
                        }
                        case HAD_BABY: {
                            this.doAgeBaby();
                            break;
                        }
                        case TRY_FOR_BABY: {
                            this.doTryForBaby();
                            break;
                        }
                        case SEARCH_FOR_PARTNER: {
                            this.doPartnerSearch();
                            break;
                        }
                        case UNKNOWN: {
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                --this.ticksUntilNextProgress;
            }
        }
    }

    @Override
    public void reset() {
        this.owner.setTicksAlive(0);
        this.ticksUntilNextProgress = MCA.isTesting ? 20 : MCA.getConfig().storyProgressionRate;
        this.setProgressionStep(EnumProgressionStep.SEARCH_FOR_PARTNER);
        this.isDominant = true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("ticksUntilNextProgress", this.ticksUntilNextProgress);
        nbt.func_74768_a("babyAge", this.babyAge);
        nbt.func_74757_a("isDominant", this.isDominant);
        nbt.func_74768_a("numChildren", this.numChildren);
        nbt.func_74768_a("progressionStep", this.progressionStep.getId());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.ticksUntilNextProgress = nbt.func_74762_e("ticksUntilNextProgress");
        this.babyAge = nbt.func_74762_e("babyAge");
        this.isDominant = nbt.func_74767_n("isDominant");
        this.numChildren = nbt.func_74762_e("numChildren");
        this.setProgressionStep(EnumProgressionStep.getFromId(nbt.func_74762_e("progressionStep")));
    }

    private void doPartnerSearch() {
        boolean partnerIsValid;
        EntityHuman partner = (EntityHuman)RadixLogic.getNearestEntityOfTypeWithinDistance(EntityHuman.class, (Entity)this.owner, (int)15);
        boolean bl = partnerIsValid = !(partner == null || partner.getIsMale() == this.owner.getIsMale() || partner.getIsMarried() || partner.getIsEngaged() || partner.getIsChild() || partner.getFatherId() != -1 && partner.getFatherId() == this.owner.getFatherId() || partner.getMotherId() != -1 && partner.getMotherId() == this.owner.getMotherId());
        if (partnerIsValid) {
            AIProgressStory mateAI = this.getMateAI(partner);
            this.setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
            mateAI.setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
            if (this.owner.getIsMale()) {
                this.isDominant = true;
                mateAI.isDominant = false;
            } else {
                this.isDominant = false;
                mateAI.isDominant = true;
            }
            this.owner.setMarriedTo((Entity)partner);
            partner.setMarriedTo((Entity)this.owner);
        }
    }

    private void doTryForBaby() {
        EntityHuman mate = this.owner.getVillagerSpouse();
        int villagersInArea = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)this.owner, (int)32).size();
        if (villagersInArea >= MCA.getConfig().storyProgressionCap && MCA.getConfig().storyProgressionCap != -1 && !this.forceNextProgress) {
            return;
        }
        if (RadixLogic.getBooleanWithProbability((int)50) && mate != null && RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)mate) <= 8.5) {
            AIProgressStory mateAI = this.getMateAI(this.owner.getVillagerSpouse());
            this.setProgressionStep(EnumProgressionStep.HAD_BABY);
            mateAI.setProgressionStep(EnumProgressionStep.HAD_BABY);
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)this.owner, 16);
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)mate, 16);
            this.isDominant = false;
            mateAI.isDominant = true;
            mate.setBabyState(EnumBabyState.getRandomGender());
            ++this.numChildren;
            ++mateAI.numChildren;
            for (Object obj : this.owner.field_70170_p.field_73010_i) {
                EntityPlayer onlinePlayer = (EntityPlayer)obj;
                if (!this.owner.isPlayerAParent(onlinePlayer) && !mate.isPlayerAParent(onlinePlayer)) continue;
                onlinePlayer.func_71029_a((StatBase)ModAchievements.childHasChildren);
            }
        }
    }

    private void doAgeBaby() {
        EntityHuman mate = this.owner.getVillagerSpouse();
        ++this.babyAge;
        if (this.babyAge <= MCA.getConfig().babyGrowUpTime) {
            AIProgressStory mateAI;
            EntityHuman child = new EntityHuman(this.owner.field_70170_p, this.owner.getBabyState().isMale(), true, this.owner.func_70005_c_(), this.owner.getSpouseName(), this.owner.getPermanentId(), this.owner.getSpouseId(), false);
            child.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
            this.owner.field_70170_p.func_72838_d((Entity)child);
            this.owner.setBabyState(EnumBabyState.NONE);
            this.babyAge = 0;
            this.setProgressionStep(EnumProgressionStep.FINISHED);
            if (mate != null) {
                mateAI = this.getMateAI(mate);
                mateAI.setProgressionStep(EnumProgressionStep.FINISHED);
            }
            if (this.numChildren < 4 && RadixLogic.getBooleanWithProbability((int)50) && mate != null) {
                mateAI = this.getMateAI(mate);
                mateAI.setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
                mateAI.isDominant = true;
                this.isDominant = false;
                this.setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
            }
        }
    }

    private AIProgressStory getMateAI(EntityHuman human) {
        return human.getAI(AIProgressStory.class);
    }

    public void setTicksUntilNextProgress(int value) {
        this.ticksUntilNextProgress = value;
    }

    public void setProgressionStep(EnumProgressionStep step) {
        this.progressionStep = step;
        this.forceNextProgress = false;
    }

    public EnumProgressionStep getProgressionStep() {
        return this.progressionStep;
    }

    public void setDominant(boolean value) {
        this.isDominant = value;
    }

    public void setForceNextProgress(boolean value) {
        this.forceNextProgress = value;
    }
}

