/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.Random;
import mca.ai.AbstractAI;
import mca.core.MCA;
import mca.entity.EntityHuman;
import mca.enums.EnumMood;
import mca.enums.EnumPersonality;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.data.WatchedFloat;
import radixcore.util.RadixMath;

public class AIMood
extends AbstractAI {
    private WatchedFloat moodValue;
    @SideOnly(value=Side.CLIENT)
    private int particleSpawnInterval;
    @SideOnly(value=Side.CLIENT)
    private int particleSpawnCounter;
    private int counter;

    public AIMood(EntityHuman entityHuman) {
        super(entityHuman);
        this.moodValue = new WatchedFloat(5.0f, 22, entityHuman.getDataWatcherEx());
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
        if (MCA.getConfig().showMoodParticles && this.getMoodLevel() != 0) {
            int moodLevel = this.getMoodLevel();
            EnumParticleTypes particles = null;
            switch (this.owner.getPersonality().getMoodGroup()) {
                case GENERAL: {
                    particles = moodLevel > 0 ? EnumParticleTypes.VILLAGER_HAPPY : EnumParticleTypes.WATER_SPLASH;
                    break;
                }
                case PLAYFUL: {
                    particles = moodLevel > 0 ? EnumParticleTypes.VILLAGER_HAPPY : EnumParticleTypes.SPELL_MOB;
                    break;
                }
                case SERIOUS: {
                    particles = moodLevel > 0 ? EnumParticleTypes.VILLAGER_HAPPY : EnumParticleTypes.VILLAGER_ANGRY;
                }
            }
            switch (Math.abs(moodLevel)) {
                case 1: {
                    this.particleSpawnInterval = 25;
                    break;
                }
                case 2: {
                    this.particleSpawnInterval = 15;
                    break;
                }
                case 3: {
                    this.particleSpawnInterval = 10;
                }
            }
            if (this.particleSpawnCounter <= 0) {
                Random rand = this.owner.field_70170_p.field_73012_v;
                double velX = rand.nextGaussian() * 0.02;
                double velY = rand.nextGaussian() * 0.02;
                double velZ = rand.nextGaussian() * 0.02;
                this.owner.field_70170_p.func_175688_a(particles, this.owner.field_70165_t + (double)(rand.nextFloat() * this.owner.field_70130_N * 2.0f) - (double)this.owner.field_70130_N, this.owner.field_70163_u + 0.5 + (double)(rand.nextFloat() * this.owner.field_70131_O), this.owner.field_70161_v + (double)(rand.nextFloat() * this.owner.field_70130_N * 2.0f) - (double)this.owner.field_70130_N, velX, velY, velZ, new int[0]);
                this.particleSpawnCounter = this.particleSpawnInterval;
            } else {
                --this.particleSpawnCounter;
            }
        }
    }

    @Override
    public void onUpdateServer() {
        if (this.counter <= 0) {
            if (this.getMoodLevel() > 0) {
                this.modifyMoodLevel(-1.0f);
            } else if (this.getMoodLevel() < 0) {
                this.modifyMoodLevel(1.0f);
            }
            this.counter = 900;
        }
        --this.counter;
    }

    @Override
    public void reset() {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("moodValue", this.moodValue.getFloat().floatValue());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.moodValue.setValue((Object)Float.valueOf(nbt.func_74760_g("moodValue")));
    }

    public void modifyMoodLevel(float amount) {
        this.moodValue.setValue((Object)Float.valueOf(RadixMath.clamp((float)(this.moodValue.getFloat().floatValue() + amount), (float)0.0f, (float)10.0f)));
    }

    public EnumMood getMood(EnumPersonality personality) {
        return personality.getMoodGroup().getMood(this.getMoodLevel());
    }

    private int getMoodLevel() {
        int level = 0;
        switch (Math.round(this.moodValue.getFloat().floatValue())) {
            case 0: {
                level = -3;
                break;
            }
            case 1: {
                level = -2;
                break;
            }
            case 2: {
                level = -2;
                break;
            }
            case 3: {
                level = -1;
                break;
            }
            case 4: {
                level = -1;
                break;
            }
            case 5: {
                level = 0;
                break;
            }
            case 6: {
                level = 1;
                break;
            }
            case 7: {
                level = 1;
                break;
            }
            case 8: {
                level = 2;
                break;
            }
            case 9: {
                level = 2;
                break;
            }
            case 10: {
                level = 3;
            }
        }
        return level;
    }
}

