/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import mca.ai.AbstractAI;
import mca.entity.EntityHuman;
import mca.enums.EnumMovementState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import radixcore.data.WatchedString;
import radixcore.util.BlockHelper;
import radixcore.util.RadixMath;

public class AIFollow
extends AbstractAI {
    private final WatchedString playerFollowingName;

    public AIFollow(EntityHuman entityHuman) {
        super(entityHuman);
        this.playerFollowingName = new WatchedString("EMPTY", 32, this.owner.getDataWatcherEx());
    }

    @Override
    public void reset() {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("playerFollowingName", this.playerFollowingName.getString());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.playerFollowingName.setValue((Object)nbt.func_74779_i("playerFollowingName"));
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (this.owner.getMovementState() == EnumMovementState.FOLLOW) {
            EntityHorse horse;
            EntityLiving entityPathController = (EntityLiving)(this.owner.field_70154_o instanceof EntityHorse ? this.owner.field_70154_o : this.owner);
            EntityPlayer entityPlayer = this.owner.field_70170_p.func_72924_a(this.playerFollowingName.getString());
            if (entityPathController instanceof EntityHorse && (horse = (EntityHorse)entityPathController).func_110257_ck()) {
                horse.func_110251_o(false);
            }
            if (entityPlayer != null) {
                entityPathController.func_70671_ap().func_75651_a((Entity)entityPlayer, 10.0f, (float)this.owner.func_70646_bf());
                double distanceToPlayer = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)entityPlayer);
                if (distanceToPlayer >= 10.0 && entityPlayer.func_174813_aQ() != null) {
                    int playerX = MathHelper.func_76128_c((double)entityPlayer.field_70165_t) - 2;
                    int playerY = MathHelper.func_76128_c((double)entityPlayer.func_174813_aQ().field_72338_b);
                    int playerZ = MathHelper.func_76128_c((double)entityPlayer.field_70161_v) - 2;
                    for (int i = 0; i <= 4; ++i) {
                        for (int i2 = 0; i2 <= 4; ++i2) {
                            if (i >= 1 && i2 >= 1 && i <= 3 && i2 <= 3 || !BlockHelper.doesBlockHaveSolidTopSurface((World)this.owner.field_70170_p, (int)(playerX + i), (int)(playerY - 1), (int)(playerZ + i2)) || BlockHelper.getBlock((World)this.owner.field_70170_p, (int)(playerX + i), (int)playerY, (int)(playerZ + i2)).func_149721_r() || BlockHelper.getBlock((World)this.owner.field_70170_p, (int)(playerX + i), (int)(playerY + 1), (int)(playerZ + i2)).func_149721_r()) continue;
                            entityPathController.func_70012_b((double)((float)(playerX + i) + 0.5f), (double)playerY, (double)((float)(playerZ + i2) + 0.5f), entityPlayer.field_70177_z, entityPlayer.field_70125_A);
                            entityPathController.func_70661_as().func_75499_g();
                        }
                    }
                } else if (distanceToPlayer >= 4.5 && this.owner.func_70661_as().func_75500_f()) {
                    float speed = entityPathController instanceof EntityHorse ? 1.8f : (entityPlayer.func_70051_ag() ? 0.8f : this.owner.getSpeed());
                    entityPathController.func_70661_as().func_75497_a((Entity)entityPlayer, (double)speed);
                } else if (distanceToPlayer <= 2.0) {
                    entityPathController.func_70661_as().func_75499_g();
                }
            } else {
                this.owner.setMovementState(EnumMovementState.MOVE);
            }
        }
    }

    public String getPlayerFollowingName() {
        return this.playerFollowingName.getString();
    }

    public void setPlayerFollowingName(String value) {
        this.playerFollowingName.setValue((Object)value);
    }
}

