/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.List;
import mca.ai.AISleep;
import mca.ai.AbstractAI;
import mca.core.MCA;
import mca.entity.EntityHuman;
import mca.enums.EnumProfession;
import mca.enums.EnumProfessionGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AIDefend
extends AbstractAI {
    private static final int TARGET_SEARCH_INTERVAL = 20;
    private EntityLiving target;
    private int timeUntilTargetSearch;
    private int rangedAttackTime;

    public AIDefend(EntityHuman owner) {
        super(owner);
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (this.owner.getAI(AISleep.class).getIsSleeping()) {
            return;
        }
        if (this.owner.getProfessionGroup() == EnumProfessionGroup.Guard && !this.owner.getIsMarried() && !this.owner.getIsInfected()) {
            if (this.target == null) {
                if (this.timeUntilTargetSearch <= 0) {
                    this.tryAssignTarget();
                    this.timeUntilTargetSearch = 20;
                } else {
                    --this.timeUntilTargetSearch;
                }
            } else if (this.target != null) {
                double distanceToTarget = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)this.target);
                if (this.target.field_70128_L || distanceToTarget >= 15.0) {
                    this.reset();
                    return;
                }
                if (this.owner.getProfessionEnum() == EnumProfession.Archer) {
                    this.owner.func_70671_ap().func_75650_a(this.target.field_70165_t, this.target.field_70163_u + (double)this.target.func_70047_e(), this.target.field_70161_v, 10.0f, (float)this.owner.func_70646_bf());
                    if (this.rangedAttackTime <= 0) {
                        this.owner.field_70170_p.func_72838_d((Entity)new EntityArrow(this.owner.field_70170_p, (EntityLivingBase)this.owner, (EntityLivingBase)this.target, 1.6f, 12.0f));
                        this.owner.field_70170_p.func_72956_a((Entity)this.owner, "random.bow", 1.0f, 1.0f / (this.owner.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        this.rangedAttackTime = 60;
                    } else {
                        --this.rangedAttackTime;
                    }
                } else if (distanceToTarget <= 2.0) {
                    this.owner.func_71038_i();
                    if (this.owner.field_70122_E) {
                        this.owner.field_70181_x += (double)0.45f;
                    }
                    try {
                        this.target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.owner), (float)MCA.getConfig().guardAttackDamage);
                    }
                    catch (NullPointerException e) {
                        this.reset();
                    }
                } else if (distanceToTarget > 2.0 && this.owner.func_70661_as().func_75500_f()) {
                    this.owner.func_70661_as().func_75497_a((Entity)this.target, (double)0.7f);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.target = null;
        this.rangedAttackTime = 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    private void tryAssignTarget() {
        List possibleTargets = RadixLogic.getAllEntitiesWithinDistanceOfCoordinates((World)this.owner.field_70170_p, (double)this.owner.field_70165_t, (double)this.owner.field_70163_u, (double)this.owner.field_70161_v, (int)15);
        double closestDistance = 100.0;
        for (Entity entity : possibleTargets) {
            double distance;
            if (!(entity instanceof EntityMob) || entity instanceof EntityCreeper || !this.owner.func_70685_l(entity) || !((distance = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            this.target = (EntityLiving)entity;
        }
    }
}

