/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import mca.ai.AbstractToggleAI;
import mca.api.CookableFood;
import mca.api.RegistryMCA;
import mca.entity.EntityHuman;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import radixcore.data.WatchedBoolean;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AICooking
extends AbstractToggleAI {
    private WatchedBoolean isAIActive;
    private Point3D furnacePos;
    private int fuelUsesRemaining;
    private boolean hasFurnace;
    private boolean hasFuel;
    private boolean hasCookableFood;
    private boolean isCooking;
    private int indexOfCookingFood;
    private int cookingTicks;
    private int cookingInterval;

    public AICooking(EntityHuman owner) {
        super(owner);
        this.isAIActive = new WatchedBoolean(false, 25, owner.getDataWatcherEx());
        this.furnacePos = Point3D.ZERO;
    }

    @Override
    public void setIsActive(boolean value) {
        this.isAIActive.setValue((Object)value);
        if (!value && this.hasFurnace) {
            BlockHelper.updateFurnaceState((boolean)false, (World)this.owner.field_70170_p, (int)this.furnacePos.iPosX, (int)this.furnacePos.iPosY, (int)this.furnacePos.iPosZ);
        }
    }

    @Override
    public boolean getIsActive() {
        return this.isAIActive.getBoolean();
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (this.hasFurnace) {
            if (this.hasFuel) {
                if (this.isReadyToCook()) {
                    this.setPathToFurnace();
                    this.doCookFood();
                } else if (!this.hasCookableFood) {
                    EntityPlayer player = this.getAssigningPlayer();
                    if (player != null) {
                        this.owner.sayRaw("I don't have any food to cook.", player);
                    }
                    this.reset();
                }
            } else if (!this.getFuelFromInventory()) {
                this.reset();
                EntityPlayer player = this.getAssigningPlayer();
                if (player != null) {
                    this.owner.sayRaw("I don't have any fuel.", player);
                }
            }
        } else if (!this.isFurnaceNearby()) {
            this.reset();
            EntityPlayer player = this.getAssigningPlayer();
            if (player != null) {
                this.owner.sayRaw("There's no furnace nearby.", player);
            }
        }
    }

    @Override
    public void reset() {
        this.hasFurnace = false;
        this.setIsActive(false);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    public void startCooking(EntityPlayer player) {
        this.assigningPlayer = player.func_110124_au().toString();
        this.setIsActive(true);
        this.furnacePos = Point3D.ZERO;
        this.cookingInterval = 160;
    }

    private boolean getFuelFromInventory() {
        for (int i = 0; i < this.owner.getVillagerInventory().func_70302_i_(); ++i) {
            ItemStack stack = this.owner.getVillagerInventory().func_70301_a(i);
            if (stack == null) continue;
            try {
                boolean isFuel = TileEntityFurnace.func_145954_b((ItemStack)stack);
                int fuelValue = TileEntityFurnace.func_145952_a((ItemStack)stack) == 0 ? GameRegistry.getFuelValue((ItemStack)stack) : TileEntityFurnace.func_145952_a((ItemStack)stack);
                fuelValue = fuelValue / 20 / 10;
                if (fuelValue == 0 && isFuel) {
                    fuelValue = 1;
                }
                if (fuelValue <= 0) continue;
                this.hasFuel = true;
                this.fuelUsesRemaining = fuelValue;
                this.owner.getVillagerInventory().func_70298_a(this.owner.getVillagerInventory().getFirstSlotContainingItem(stack.func_77973_b()), 1);
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return this.hasFuel;
    }

    private boolean isFurnaceNearby() {
        Point3D nearbyFurnace = RadixLogic.getFirstNearestBlock((Entity)this.owner, (Block)Blocks.field_150460_al, (int)10);
        this.hasFurnace = nearbyFurnace != null;
        this.furnacePos = this.hasFurnace ? nearbyFurnace : this.furnacePos;
        return this.hasFurnace;
    }

    private boolean isReadyToCook() {
        if (this.hasCookableFood) {
            if (this.isFurnaceStillPresent()) {
                return true;
            }
            this.reset();
            EntityPlayer player = this.getAssigningPlayer();
            if (player != null) {
                this.owner.sayRaw("There's no furnace nearby.", player);
            }
        } else {
            this.getCookableFoodFromInventory();
        }
        return false;
    }

    private void getCookableFoodFromInventory() {
        for (int i = 0; i < this.owner.getVillagerInventory().func_70302_i_(); ++i) {
            ItemStack stack = this.owner.getVillagerInventory().func_70301_a(i);
            for (CookableFood entry : RegistryMCA.getCookableFoodList()) {
                if (stack == null || stack.func_77973_b() != entry.getFoodRaw()) continue;
                this.indexOfCookingFood = RegistryMCA.getCookableFoodList().indexOf(entry);
                this.hasCookableFood = true;
            }
        }
    }

    private void setPathToFurnace() {
        double distanceToFurnace = RadixMath.getDistanceToXYZ((Entity)this.owner, (Point3D)this.furnacePos);
        if (this.owner.func_70661_as().func_75500_f() && distanceToFurnace >= 2.5) {
            this.owner.func_70661_as().func_75484_a(this.owner.func_70661_as().func_75488_a((double)this.furnacePos.iPosX, (double)this.furnacePos.iPosY, (double)this.furnacePos.iPosZ), (double)this.owner.getSpeed());
        }
    }

    private boolean isFurnaceStillPresent() {
        return BlockHelper.getBlock((World)this.owner.field_70170_p, (int)this.furnacePos.iPosX, (int)this.furnacePos.iPosY, (int)this.furnacePos.iPosZ) == Blocks.field_150460_al || BlockHelper.getBlock((World)this.owner.field_70170_p, (int)this.furnacePos.iPosX, (int)this.furnacePos.iPosY, (int)this.furnacePos.iPosZ) == Blocks.field_150470_am;
    }

    private void doCookFood() {
        double distanceToFurnace = RadixMath.getDistanceToXYZ((Entity)this.owner, (Point3D)this.furnacePos);
        if (distanceToFurnace <= 2.5) {
            if (this.isCooking) {
                if (this.cookingTicks <= this.cookingInterval) {
                    if (BlockHelper.getBlock((World)this.owner.field_70170_p, (int)this.furnacePos.iPosX, (int)this.furnacePos.iPosY, (int)this.furnacePos.iPosZ) != Blocks.field_150470_am) {
                        BlockHelper.updateFurnaceState((boolean)true, (World)this.owner.field_70170_p, (int)this.furnacePos.iPosX, (int)this.furnacePos.iPosY, (int)this.furnacePos.iPosZ);
                    }
                    ++this.cookingTicks;
                } else {
                    CookableFood foodObj = RegistryMCA.getCookableFoodList().get(this.indexOfCookingFood);
                    int rawFoodSlot = this.owner.getVillagerInventory().getFirstSlotContainingItem(foodObj.getFoodRaw());
                    if (rawFoodSlot > -1) {
                        this.owner.getVillagerInventory().func_70298_a(rawFoodSlot, 1);
                        this.addItemStackToInventory(new ItemStack(foodObj.getFoodCooked(), 1, 0));
                        this.owner.func_71038_i();
                    } else {
                        EntityPlayer player = this.getAssigningPlayer();
                        if (player != null) {
                            this.owner.sayRaw("I don't have any food to cook.", player);
                        }
                        this.reset();
                    }
                    this.isCooking = false;
                    this.hasCookableFood = false;
                    this.cookingTicks = 0;
                    --this.fuelUsesRemaining;
                    BlockHelper.updateFurnaceState((boolean)false, (World)this.owner.field_70170_p, (int)this.furnacePos.iPosX, (int)this.furnacePos.iPosY, (int)this.furnacePos.iPosZ);
                    if (this.fuelUsesRemaining <= 0) {
                        this.hasFuel = false;
                    }
                }
            } else {
                this.owner.func_71038_i();
                this.isCooking = true;
            }
        }
    }

    private boolean hasCookableFood() {
        CookableFood foodObj = RegistryMCA.getCookableFoodList().get(this.indexOfCookingFood);
        int rawFoodSlot = this.owner.getVillagerInventory().getFirstSlotContainingItem(foodObj.getFoodRaw());
        return rawFoodSlot > -1;
    }

    @Override
    protected String getName() {
        return "Cooking";
    }
}

