/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mca.ai.AbstractToggleAI;
import mca.api.CropEntry;
import mca.api.enums.EnumCropCategory;
import mca.entity.EntityHuman;
import mca.enums.EnumMovementState;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import radixcore.data.BlockObj;
import radixcore.data.WatchedBoolean;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.SchematicHandler;

public class AIBuild
extends AbstractToggleAI {
    private Map<Point3D, BlockObj> schematicMap;
    private CropEntry cropEntry;
    private List<Point3D> blockPoints;
    private List<Point3D> torchPoints;
    private Point3D origin = Point3D.ZERO;
    private WatchedBoolean isAIActive;
    private String schematicName = "none";
    private int interval = 20;
    private int index = -1;
    private Block groundBlock;

    public AIBuild(EntityHuman owner) {
        super(owner);
        this.isAIActive = new WatchedBoolean(false, 41, owner.getDataWatcherEx());
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (this.index != -1) {
            --this.interval;
            if (this.interval <= 0) {
                this.interval = 20;
                this.owner.func_71038_i();
                for (int i = 0; i < 10; ++i) {
                    if (this.index >= this.blockPoints.size()) {
                        for (Point3D point : this.torchPoints) {
                            BlockObj blockObj = this.schematicMap.get(point);
                            BlockHelper.setBlock((World)this.owner.field_70170_p, (int)(this.origin.iPosX + point.iPosX), (int)(this.origin.iPosY + point.iPosY), (int)(this.origin.iPosZ + point.iPosZ), (Block)blockObj.getBlock());
                        }
                        this.owner.setMovementState(EnumMovementState.MOVE);
                        this.reset();
                        break;
                    }
                    Point3D point = this.blockPoints.get(this.index);
                    BlockObj blockObj = this.schematicMap.get(point);
                    ++this.index;
                    if (blockObj.getBlock() == Blocks.field_150349_c && this.groundBlock != null) {
                        BlockHelper.setBlock((World)this.owner.field_70170_p, (int)(this.origin.iPosX + point.iPosX), (int)(this.origin.iPosY + point.iPosY), (int)(this.origin.iPosZ + point.iPosZ), (Block)this.groundBlock);
                        continue;
                    }
                    BlockHelper.setBlock((World)this.owner.field_70170_p, (int)(this.origin.iPosX + point.iPosX), (int)(this.origin.iPosY + point.iPosY), (int)(this.origin.iPosZ + point.iPosZ), (Block)blockObj.getBlock());
                }
            }
        }
    }

    @Override
    public void reset() {
        this.setIsActive(false);
        this.schematicMap = null;
        this.origin = Point3D.ZERO;
        this.blockPoints.clear();
        this.torchPoints.clear();
        this.groundBlock = null;
        this.cropEntry = null;
        this.schematicName = "none";
        this.index = -1;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("schematicName", this.schematicName);
        nbt.func_74768_a("interval", this.interval);
        nbt.func_74768_a("index", this.index);
        nbt.func_74768_a("originX", this.origin.iPosX);
        nbt.func_74768_a("originY", this.origin.iPosY);
        nbt.func_74768_a("originZ", this.origin.iPosZ);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.schematicName = nbt.func_74779_i("schematicName");
        this.interval = nbt.func_74762_e("interval");
        this.index = nbt.func_74762_e("index");
        int originX = nbt.func_74762_e("originX");
        int originY = nbt.func_74762_e("originY");
        int originZ = nbt.func_74762_e("originZ");
        if (this.index != -1) {
            this.primeSchematic(this.schematicName);
            this.origin = new Point3D(originX, originY, originZ);
        }
    }

    public boolean startBuilding(String schematicLocation, boolean doTopDown) {
        if (RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_150344_f, (int)10).size() != 0) {
            return false;
        }
        this.origin = new Point3D(this.owner.field_70165_t, this.owner.field_70163_u + 1.0, this.owner.field_70161_v);
        this.owner.setMovementState(EnumMovementState.STAY);
        this.primeSchematic(schematicLocation);
        this.setIsActive(true);
        return true;
    }

    public boolean startBuilding(String schematicLocation, boolean doTopDown, Block groundBlock) {
        this.groundBlock = groundBlock;
        return this.startBuilding(schematicLocation, doTopDown);
    }

    public boolean startBuilding(String schematicLocation, boolean doTopDown, Block groundBlock, CropEntry cropEntry) {
        this.cropEntry = cropEntry;
        return this.startBuilding(schematicLocation, doTopDown, groundBlock);
    }

    private void primeSchematic(String schematicLocation) {
        this.schematicName = schematicLocation;
        this.blockPoints = new ArrayList<Point3D>();
        this.torchPoints = new ArrayList<Point3D>();
        this.schematicMap = SchematicHandler.readSchematic((String)schematicLocation);
        this.index = 0;
        int compareY = -25;
        for (Map.Entry<Point3D, BlockObj> entry : this.schematicMap.entrySet()) {
            Point3D point = entry.getKey();
            Block blockAtPoint = BlockHelper.getBlock((World)this.owner.field_70170_p, (int)(this.origin.iPosX + point.iPosX), (int)(this.origin.iPosY + point.iPosY), (int)(this.origin.iPosZ + point.iPosZ));
            if (blockAtPoint == Blocks.field_150329_H || blockAtPoint == Blocks.field_150328_O || blockAtPoint == Blocks.field_150398_cm || blockAtPoint == Blocks.field_150327_N) {
                BlockHelper.setBlock((World)this.owner.field_70170_p, (int)(this.origin.iPosX + point.iPosX), (int)(this.origin.iPosY + point.iPosY), (int)(this.origin.iPosZ + point.iPosZ), (Block)Blocks.field_150350_a);
            }
            for (compareY = -25; compareY < 25; ++compareY) {
                if (this.schematicMap.get(point).getBlock() == Blocks.field_150478_aa) {
                    this.torchPoints.add(point);
                    continue;
                }
                if (point.iPosY != compareY) continue;
                this.blockPoints.add(point);
            }
        }
        if (this.cropEntry != null) {
            BlockObj searchRefBlock = new BlockObj(Blocks.field_150325_L, this.cropEntry.getCategory().getReferenceMeta());
            BlockObj waterRefBlock = new BlockObj(Blocks.field_150325_L, 11);
            BlockObj farmland = new BlockObj(Blocks.field_150458_ak, 0);
            BlockObj cropBlock = new BlockObj(this.cropEntry.getCropBlock(), 0);
            BlockObj waterBlock = new BlockObj((Block)Blocks.field_150355_j, 0);
            HashMap<Point3D, BlockObj> changes = new HashMap<Point3D, BlockObj>();
            for (Map.Entry<Point3D, BlockObj> entry : this.schematicMap.entrySet()) {
                if (entry.getValue().equals((Object)searchRefBlock)) {
                    Point3D key = entry.getKey();
                    Point3D belowKey = SchematicHandler.getPoint3DWithValue(this.schematicMap, (Point3D)new Point3D(key.iPosX, key.iPosY - 1, key.iPosZ));
                    if (belowKey != null && this.cropEntry.getCategory() != EnumCropCategory.SUGARCANE) {
                        changes.put(belowKey, farmland);
                    }
                    changes.put(entry.getKey(), cropBlock);
                    continue;
                }
                if (!entry.getValue().equals((Object)waterRefBlock)) continue;
                changes.put(entry.getKey(), waterBlock);
            }
            for (Map.Entry<Object, Object> entry : changes.entrySet()) {
                this.schematicMap.put((Point3D)entry.getKey(), (BlockObj)entry.getValue());
            }
        }
    }

    @Override
    public void setIsActive(boolean value) {
        this.isAIActive.setValue((Object)value);
    }

    @Override
    public boolean getIsActive() {
        return this.isAIActive.getBoolean();
    }

    @Override
    protected String getName() {
        return "Building";
    }
}

