/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.shadowmobs.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.model.ModelCustomObj;
import lycanite.lycanitesmobs.shadowmobs.ShadowMobs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.model.obj.WavefrontObject;

@SideOnly(value=Side.CLIENT)
public class ModelShade
extends ModelCustomObj {
    float maxLeg = 0.0f;

    public ModelShade() {
        this(1.0f);
    }

    public ModelShade(float shadowSize) {
        this.model = (WavefrontObject)AssetManager.getObjModel("shade", ShadowMobs.group, "entity/shade");
        this.parts = this.model.groupObjects;
        this.setPartCenter("head", 0.0f, 2.15f, 0.5f);
        this.setPartCenter("mouth", 0.0f, 2.0f, 0.75f);
        this.setPartCenter("body", 0.0f, 1.8f, 0.1f);
        this.setPartCenter("armleft", 0.31f, 2.19f, -0.15f);
        this.setPartCenter("armright", -0.31f, 2.19f, -0.15f);
        this.setPartCenter("legleft", 0.3f, 1.1f, 0.0f);
        this.setPartCenter("legright", -0.3f, 1.1f, 0.0f);
        this.setPartCenter("tail", 0.0f, 1.05f, -0.05f);
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("mouth")) {
            this.centerPartToPart("mouth", "head");
            if (!this.lockHeadX) {
                this.rotate((float)Math.toDegrees(lookX / 57.295776f), 0.0f, 0.0f);
            }
            if (!this.lockHeadY) {
                this.rotate(0.0f, (float)Math.toDegrees(lookY / 57.295776f), 0.0f);
            }
            this.uncenterPartToPart("mouth", "head");
        }
        if (partName.equals("mouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.2f - 0.1f)), 0.0f, 0.0f);
        }
        if (partName.equals("armleft")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("armright")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("tail")) {
            rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f));
            rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
        }
        float walkSwing = 0.6f;
        if (partName.equals("legleft")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.equals("legright")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        walkSwing = 0.05f;
        if (partName.equals("armright")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.equals("armleft")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked()) {
            if (partName.equals("mouth")) {
                this.rotate(-25.0f, 0.0f, 0.0f);
            }
            if (partName.equals("armleft")) {
                this.rotate(25.0f, 0.0f, 0.0f);
            }
            if (partName.equals("armright")) {
                this.rotate(25.0f, 0.0f, 0.0f);
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

