/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.mountainmobs.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.model.ModelCustomObj;
import lycanite.lycanitesmobs.mountainmobs.MountainMobs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.model.obj.WavefrontObject;

@SideOnly(value=Side.CLIENT)
public class ModelJabberwock
extends ModelCustomObj {
    float maxLeg = 0.0f;

    public ModelJabberwock() {
        this(1.0f);
    }

    public ModelJabberwock(float shadowSize) {
        this.model = (WavefrontObject)AssetManager.getObjModel("jabberwock", MountainMobs.group, "entity/jabberwock");
        this.parts = this.model.groupObjects;
        this.setPartCenter("head", 0.0f, 2.2f, 0.1f);
        this.setPartCenter("mouth", 0.0f, 2.25f, 0.8f);
        this.setPartCenter("body", 0.0f, 2.2f, 0.2f);
        this.setPartCenter("leftarm", 0.35f, 1.95f, 0.0f);
        this.setPartCenter("rightarm", -0.35f, 1.95f, 0.0f);
        this.setPartCenter("leftleg", 0.3f, 1.0f, -0.15f);
        this.setPartCenter("rightleg", -0.3f, 1.0f, -0.15f);
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("mouth")) {
            this.centerPartToPart("mouth", "head");
            if (!this.lockHeadX) {
                this.rotate((float)Math.toDegrees(lookX / 57.295776f), 0.0f, 0.0f);
            }
            if (!this.lockHeadY) {
                this.rotate(0.0f, (float)Math.toDegrees(lookY / 57.295776f), 0.0f);
            }
            this.uncenterPartToPart("mouth", "head");
        }
        if (partName.equals("mouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f)), 0.0f, 0.0f);
        }
        if (partName.equals("leftarm")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("rightarm")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.equals("tail")) {
            rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f));
            rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
        }
        if (entity == null || entity.field_70122_E || entity.func_70090_H()) {
            float walkSwing = 0.6f;
            if (partName.equals("leftarm")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 1.0f * distance * 0.5f));
                rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 0.5f * distance * 0.5f));
            }
            if (partName.equals("rightarm")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 1.0f * distance * 0.5f));
                rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 0.5f * distance * 0.5f));
            }
            if (partName.equals("leftleg")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 1.4f * distance));
            }
            if (partName.equals("rightleg")) {
                rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 1.4f * distance));
            }
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked()) {
            if (partName.equals("leftarm") || partName.equals("rightarm")) {
                rotX += 20.0f;
            }
            if (partName.equals("mouth")) {
                rotX += 20.0f;
            }
        }
        if (entity != null && !entity.field_70122_E && !entity.func_70090_H()) {
            if (partName.equals("leftarm")) {
                rotZ -= 10.0f;
                rotX -= 50.0f;
            }
            if (partName.equals("rightarm")) {
                rotZ += 10.0f;
                rotX -= 50.0f;
            }
            if (partName.equals("leftleg")) {
                rotX += 50.0f;
            }
            if (partName.equals("rightleg")) {
                rotX += 50.0f;
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

