/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.mountainmobs.entity;

import java.util.HashMap;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityProjectileBase;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackRanged;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIBreakDoor;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import lycanite.lycanitesmobs.junglemobs.entity.EntityPoop;
import lycanite.lycanitesmobs.mountainmobs.entity.EntityBoulderBlast;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityTroll
extends EntityCreatureBase
implements IMob {
    public boolean trollGreifing = true;
    public boolean stoneForm = false;

    public EntityTroll(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 2;
        this.experience = 5;
        this.hasAttackSound = false;
        this.trollGreifing = ConfigBase.getConfig(this.group, "general").getBool("Features", "Troll Griefing", this.trollGreifing, "Set to false to disable Troll block destruction.");
        this.setWidth = 1.5f;
        this.setHeight = 3.2f;
        this.setupMob();
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackRanged(this).setSpeed(0.5).setRate(60).setRange(14.0f).setMinChaseDistance(5.0f).setChaseTime(-1));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 30.0);
        baseAttributes.put("movementSpeed", 0.26);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 6.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150364_r), 1.0f).setMinAmount(2).setMaxAmount(6));
        this.drops.add(new DropRate(new ItemStack(Items.field_151103_aS), 1.0f).setMinAmount(2).setMaxAmount(6));
        this.drops.add(new DropRate(new ItemStack(Items.field_151116_aA), 1.0f).setMinAmount(2).setMaxAmount(6));
        this.drops.add(new DropRate(new ItemStack(Items.field_151044_h), 1.0f).setMinAmount(2).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("BoulderBlastCharge")), 0.5f).setMinAmount(1).setMaxAmount(1));
    }

    @Override
    public String getTextureName() {
        if (this.stoneForm) {
            return super.getTextureName() + "_stone";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        float distance;
        super.func_70636_d();
        if (!this.stoneForm) {
            if (this.isDaytime() && this.field_70170_p.func_72937_j((int)this.field_70165_t, (int)this.field_70121_D.field_72337_e, (int)this.field_70161_v)) {
                this.stoneForm = true;
            }
        } else if (!this.isDaytime() || !this.field_70170_p.func_72937_j((int)this.field_70165_t, (int)this.field_70121_D.field_72337_e, (int)this.field_70161_v)) {
            this.stoneForm = false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && this.trollGreifing && (distance = this.func_70638_az().func_70032_d((Entity)this)) <= this.field_70130_N + 4.0f) {
            this.destroyArea((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 10.0f, true);
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.stoneForm) {
            return 0.125f;
        }
        return 1.0f;
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntityProjectileBase projectile = new EntityBoulderBlast(this.field_70170_p, (EntityLivingBase)this);
        if ("Jarno".equals(this.func_94057_bL())) {
            try {
                projectile = new EntityPoop(this.field_70170_p, (EntityLivingBase)this);
                projectile.setBaseDamage(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        projectile.setProjectileScale(6.0f);
        projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
        float accuracy = 3.0f * (this.func_70681_au().nextFloat() - 0.5f);
        double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
        double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
        double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
        this.func_85030_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)projectile);
        super.rangedAttack(target, range);
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if ("Jarno".equals(this.func_94057_bL())) {
            return 0.0f;
        }
        if (this.stoneForm) {
            if (damageSrc.func_76346_g() != null) {
                EntityLiving entityLiving;
                Item heldItem = null;
                if (damageSrc.func_76346_g() instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)damageSrc.func_76346_g();
                    if (entityPlayer.func_70694_bm() != null) {
                        heldItem = entityPlayer.func_70694_bm().func_77973_b();
                    }
                } else if (damageSrc.func_76346_g() instanceof EntityLiving && (entityLiving = (EntityLiving)damageSrc.func_76346_g()).func_70694_bm() != null) {
                    heldItem = entityLiving.func_70694_bm().func_77973_b();
                }
                if (ObjectLists.isPickaxe(heldItem)) {
                    return 2.0f;
                }
            }
            return 0.25f;
        }
        if (damageSrc.func_76347_k()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        if (par1PotionEffect.func_76456_a() == Potion.field_76419_f.field_76415_H) {
            return false;
        }
        if (ObjectManager.getPotionEffect("Weight") != null && par1PotionEffect.func_76456_a() == ObjectManager.getPotionEffect((String)"Weight").field_76415_H) {
            return false;
        }
        super.func_70687_e(par1PotionEffect);
        return true;
    }

    @Override
    public float getFallResistance() {
        return 50.0f;
    }

    @Override
    public boolean canBurn() {
        return !this.stoneForm;
    }

    public boolean petControlsEnabled() {
        return false;
    }
}

