/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.junglemobs.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupAnimal;
import lycanite.lycanitesmobs.api.IGroupPredator;
import lycanite.lycanitesmobs.api.IGroupPrey;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIStayByHome;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetMasterAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.junglemobs.entity.EntityConba;
import lycanite.lycanitesmobs.junglemobs.entity.EntityVespid;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityVespidQueen
extends EntityCreatureAgeable
implements IMob,
IGroupPredator {
    public boolean inHiveCache = false;
    private int hiveCheckCacheTime = 0;
    public List<HiveExposedCoordinates> hiveExposedBlocks = new ArrayList<HiveExposedCoordinates>();
    private int hiveExposedBlockCacheTime = 0;
    private int vespidQueenSwarmLimit = 10;
    private boolean vespidHiveBuilding = true;

    public EntityVespidQueen(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.defense = 1;
        this.experience = 5;
        this.hasAttackSound = true;
        this.setWidth = 1.6f;
        this.setHeight = 1.9f;
        this.setupMob();
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.field_70138_W = 1.0f;
        this.justAttackedTime = (short)10;
        this.vespidQueenSwarmLimit = ConfigBase.getConfig(this.group, "general").getInt("Features", "Vespid Queen Swarm Limit", this.vespidQueenSwarmLimit, "Limits how many Vespid drones a Queen can have before she will no longer spawn babies in hives.");
        this.vespidHiveBuilding = ConfigBase.getConfig(this.group, "general").getBool("Features", "Vespid Hive Building", this.vespidHiveBuilding, "Set to false to stop Vespids from building hives all together.");
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this).setRate(10).setLongMemory(true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIStayByHome(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this).setPauseRate(320));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetMasterAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityConba.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVespidQueen.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVespid.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IAnimals.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.28);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 24.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151119_aD), 0.5f).setMaxAmount(16));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("propolis")), 0.5f).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("veswax")), 0.5f).setMaxAmount(8));
    }

    @Override
    public boolean isPersistant() {
        if (this.hasHome() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            return true;
        }
        return super.isPersistant();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.vespidHiveBuilding) {
            --this.hiveCheckCacheTime;
            if (this.hiveCheckCacheTime < 0) {
                this.hiveCheckCacheTime = 0;
            }
            --this.hiveExposedBlockCacheTime;
            if (this.hiveExposedBlockCacheTime < 0) {
                this.hiveExposedBlockCacheTime = 0;
            }
            if (!this.field_70170_p.field_72995_K && !this.hasHome() && this.hiveFoundationsSet()) {
                this.setHome((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 16.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.hiveFoundationsSet() && this.field_70173_aa % 60 == 0) {
                this.allyUpdate();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() instanceof EntityConba && ((EntityConba)this.func_70638_az()).vespidInfection) {
            this.func_70624_b(null);
        }
    }

    public void allyUpdate() {
        EntityLivingBase minion;
        float random;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.vespidQueenSwarmLimit > 0 && this.nearbyCreatureCount(EntityVespid.class, 32.0) < this.vespidQueenSwarmLimit && (random = this.field_70146_Z.nextFloat()) <= 0.05f && (minion = this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f))) instanceof EntityCreatureAgeable) {
            ((EntityCreatureAgeable)minion).setGrowingAge(((EntityCreatureAgeable)minion).growthTime);
        }
    }

    public EntityLivingBase spawnAlly(double x, double y, double z) {
        EntityVespid minion = new EntityVespid(this.field_70170_p);
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        if (minion instanceof EntityCreatureBase) {
            ((EntityCreatureBase)minion).setSubspecies(this.getSubspeciesIndex(), true);
        }
        this.field_70170_p.func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
        return minion;
    }

    public boolean hiveFoundationsSet() {
        return this.hiveFoundationsSet(false);
    }

    public boolean hiveFoundationsSet(boolean clearCache) {
        if (clearCache || this.hiveCheckCacheTime <= 0) {
            this.hiveCheckCacheTime = 100;
            if (!this.doesHiveHaveXPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveXNegative()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveYPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveYNegative()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveZPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveZNegative()) {
                this.inHiveCache = false;
                return false;
            }
            this.inHiveCache = true;
            return true;
        }
        return this.inHiveCache;
    }

    public boolean doesHiveHaveXPositive() {
        ChunkCoordinates hivePos = this.getHivePosition();
        for (int x = hivePos.field_71574_a; x <= hivePos.field_71574_a + 28; ++x) {
            Block searchBlock = this.field_70170_p.func_147439_a(x, hivePos.field_71572_b, hivePos.field_71573_c);
            if (searchBlock == null || searchBlock != ObjectManager.getBlock("veswax") || this.field_70170_p.func_72805_g(x, hivePos.field_71572_b, hivePos.field_71573_c) >= 8) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveXNegative() {
        ChunkCoordinates hivePos = this.getHivePosition();
        for (int x = hivePos.field_71574_a; x >= hivePos.field_71574_a - 28; --x) {
            Block searchBlock = this.field_70170_p.func_147439_a(x, hivePos.field_71572_b, hivePos.field_71573_c);
            if (searchBlock == null || searchBlock != ObjectManager.getBlock("veswax") || this.field_70170_p.func_72805_g(x, hivePos.field_71572_b, hivePos.field_71573_c) >= 8) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveYPositive() {
        ChunkCoordinates hivePos = this.getHivePosition();
        for (int y = hivePos.field_71572_b; y <= hivePos.field_71572_b + 28; ++y) {
            Block searchBlock = this.field_70170_p.func_147439_a(hivePos.field_71574_a, y, hivePos.field_71573_c);
            if (searchBlock == null || searchBlock != ObjectManager.getBlock("propolis") || this.field_70170_p.func_72805_g(hivePos.field_71574_a, y, hivePos.field_71573_c) >= 8) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveYNegative() {
        ChunkCoordinates hivePos = this.getHivePosition();
        for (int y = hivePos.field_71572_b; y >= hivePos.field_71572_b - 28; --y) {
            Block searchBlock = this.field_70170_p.func_147439_a(hivePos.field_71574_a, y, hivePos.field_71573_c);
            if (searchBlock == null || searchBlock != ObjectManager.getBlock("propolis") || this.field_70170_p.func_72805_g(hivePos.field_71574_a, y, hivePos.field_71573_c) >= 8) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveZPositive() {
        ChunkCoordinates hivePos = this.getHivePosition();
        for (int z = hivePos.field_71573_c; z <= hivePos.field_71573_c + 28; ++z) {
            Block searchBlock = this.field_70170_p.func_147439_a(hivePos.field_71574_a, hivePos.field_71572_b, z);
            if (searchBlock == null || searchBlock != ObjectManager.getBlock("veswax") || this.field_70170_p.func_72805_g(hivePos.field_71574_a, hivePos.field_71572_b, z) >= 8) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveZNegative() {
        ChunkCoordinates hivePos = this.getHivePosition();
        for (int z = hivePos.field_71573_c; z >= hivePos.field_71573_c - 28; --z) {
            Block searchBlock = this.field_70170_p.func_147439_a(hivePos.field_71574_a, hivePos.field_71572_b, z);
            if (searchBlock == null || searchBlock != ObjectManager.getBlock("veswax") || this.field_70170_p.func_72805_g(hivePos.field_71574_a, hivePos.field_71572_b, z) >= 8) continue;
            return true;
        }
        return false;
    }

    public ChunkCoordinates getHivePosition() {
        if (this.hasHome()) {
            return this.getHomePosition();
        }
        ChunkCoordinates hivePos = new ChunkCoordinates();
        hivePos.field_71574_a = (int)this.field_70165_t;
        hivePos.field_71572_b = (int)this.field_70163_u;
        hivePos.field_71573_c = (int)this.field_70161_v;
        return hivePos;
    }

    public List<HiveExposedCoordinates> getHiveExposureBlocks() {
        if (this.hiveExposedBlockCacheTime <= 0) {
            this.hiveExposedBlockCacheTime = 200;
            this.hiveExposedBlocks = new ArrayList<HiveExposedCoordinates>();
            ChunkCoordinates hivePosition = this.getHivePosition();
            int hiveMax = 28;
            for (int x = hivePosition.field_71574_a - hiveMax; x <= hivePosition.field_71574_a + hiveMax; ++x) {
                for (int y = hivePosition.field_71572_b - hiveMax; y <= hivePosition.field_71572_b + hiveMax; ++y) {
                    for (int z = hivePosition.field_71573_c - hiveMax; z <= hivePosition.field_71573_c + hiveMax; ++z) {
                        if (!this.isHiveBlock(x, y, z)) continue;
                        Block block = this.field_70170_p.func_147439_a(x, y, z);
                        int oriMeta = this.field_70170_p.func_72805_g(x, y, z);
                        EnumFacing facing = EnumFacing.func_82600_a((int)oriMeta);
                        if (facing.func_82601_c() == 0) {
                            if (!this.isHiveBlock(x - 1, y, z) && this.canPlaceBlockAt(x - 1, y, z)) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, new ChunkCoordinates(x - 1, y, z), oriMeta));
                            }
                            if (!this.isHiveBlock(x + 1, y, z)) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, new ChunkCoordinates(x + 1, y, z), oriMeta));
                            }
                        }
                        if (facing.func_96559_d() == 0) {
                            if (!this.isHiveBlock(x, y - 1, z)) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, new ChunkCoordinates(x, y - 1, z), oriMeta));
                            }
                            if (!this.isHiveBlock(x, y + 1, z)) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, new ChunkCoordinates(x, y + 1, z), oriMeta));
                            }
                        }
                        if (facing.func_82599_e() != 0) continue;
                        if (!this.isHiveBlock(x, y, z - 1)) {
                            this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, new ChunkCoordinates(x, y, z - 1), oriMeta));
                        }
                        if (this.isHiveBlock(x, y, z + 1)) continue;
                        this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, new ChunkCoordinates(x, y, z + 1), oriMeta));
                    }
                }
            }
        }
        return this.hiveExposedBlocks;
    }

    public boolean isHiveBlock(int x, int y, int z) {
        Block possibleHiveBlock = this.field_70170_p.func_147439_a(x, y, z);
        if (possibleHiveBlock != null && this.field_70170_p.func_72805_g(x, y, z) < 8) {
            return possibleHiveBlock == ObjectManager.getBlock("veswax") || possibleHiveBlock == ObjectManager.getBlock("propolis");
        }
        return false;
    }

    public boolean canPlaceBlockAt(int x, int y, int z) {
        Block targetBlock = this.field_70170_p.func_147439_a(x, y, z);
        if (targetBlock == null) {
            return false;
        }
        if (targetBlock == Blocks.field_150350_a) {
            return true;
        }
        return targetBlock.func_149688_o() == Material.field_151586_h || targetBlock.func_149688_o() == Material.field_151587_i;
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (target instanceof EntityConba) {
            ((EntityConba)target).vespidInfection = true;
            return true;
        }
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            int effectSeconds = 16;
            if (target instanceof EntityPlayer) {
                effectSeconds = (byte)(effectSeconds / 2);
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, this.getEffectDuration(effectSeconds), 0));
        }
        return true;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity instanceof EntityConba && ((EntityConba)targetEntity).vespidInfection) {
            return false;
        }
        if (targetEntity instanceof EntityVespid && (!((EntityVespid)targetEntity).hasMaster() || ((EntityVespid)targetEntity).getMasterTarget() == this)) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        if (par1PotionEffect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return false;
        }
        if (par1PotionEffect.func_76456_a() == Potion.field_76421_d.field_76415_H) {
            return false;
        }
        super.func_70687_e(par1PotionEffect);
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    public class HiveExposedCoordinates {
        public Block block;
        public ChunkCoordinates chunkCoordinates;
        public int orientationMetadata;

        public HiveExposedCoordinates(Block block, ChunkCoordinates chunkCoordinates, int orientationMetadata) {
            this.block = block;
            this.chunkCoordinates = chunkCoordinates;
            this.orientationMetadata = orientationMetadata;
        }
    }
}

