/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.junglemobs.entity;

import java.util.HashMap;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupAlpha;
import lycanite.lycanitesmobs.api.IGroupHunter;
import lycanite.lycanitesmobs.api.IGroupPredator;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackRanged;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAvoid;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowOwner;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAvoid;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerThreats;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.junglemobs.entity.EntityPoop;
import lycanite.lycanitesmobs.junglemobs.entity.EntityVespid;
import lycanite.lycanitesmobs.junglemobs.entity.EntityVespidQueen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityConba
extends EntityCreatureTameable
implements IMob {
    EntityAIAttackRanged aiAttackRanged;
    EntityAIAttackMelee aiAttackMelee;
    EntityAIAvoid aiAvoid;
    public boolean vespidInfection = false;
    public int vespidInfectionTime = 0;

    public EntityConba(World par1World) {
        super(par1World);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 5;
        this.hasAttackSound = true;
        this.setWidth = 0.6f;
        this.setHeight = 0.9f;
        this.setupMob();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.aiAttackMelee = new EntityAIAttackMelee(this).setRate(10).setLongMemory(true).setEnabled(false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackMelee);
        this.aiAttackRanged = new EntityAIAttackRanged(this).setSpeed(1.0).setRate(30).setRange(16.0f).setMinChaseDistance(10.0f).setChaseTime(-1);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackRanged);
        this.aiAvoid = new EntityAIAvoid(this).setNearSpeed(1.3).setFarSpeed(1.0).setNearDistance(5.0).setFarDistance(9.0);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAvoid);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupHunter.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(IGroupAlpha.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAvoid(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 10.0);
        baseAttributes.put("movementSpeed", 0.26);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151100_aR, 1, 3), 1.0f).setMinAmount(1).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("PoopCharge")), 0.75f));
    }

    @Override
    public String getSpeciesName() {
        String entityName;
        String infection = "";
        if (this.vespidInfection && (entityName = EntityList.func_75621_b((Entity)this)) != null) {
            infection = StatCollector.func_74838_a((String)("entity." + entityName + ".infected")) + " ";
        }
        return infection + super.getSpeciesName();
    }

    @Override
    public String getTextureName() {
        if (this.vespidInfection) {
            return super.getTextureName() + "_infected";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
            if (this.hasAvoidTarget()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.leap(1.0f, 0.6, (Entity)this.func_70638_az());
                }
            } else if (this.field_70146_Z.nextInt(50) == 0 && this.isMoving()) {
                this.leap(1.0, 0.6);
            }
        }
        if (this.vespidInfection && !this.field_70170_p.field_72995_K) {
            this.aiAttackMelee.setEnabled(true);
            this.aiAttackRanged.setEnabled(false);
            if (this.vespidInfectionTime++ >= 1200) {
                this.spawnVespidSwarm();
                this.func_70106_y();
            }
        } else {
            this.aiAttackMelee.setEnabled(false);
            this.aiAttackRanged.setEnabled(true);
        }
        if (this.field_70170_p.field_72995_K) {
            this.vespidInfection = this.extraAnimation01();
            if (this.vespidInfection) {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_72869_a("witchMagic", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void func_70619_bc() {
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az() != this.getAvoidTarget()) {
            this.setAvoidTarget(this.func_70638_az());
        }
        super.func_70619_bc();
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (this.vespidInfection && (targetClass.isAssignableFrom(EntityVespid.class) || targetClass.isAssignableFrom(EntityVespidQueen.class))) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntityPoop projectile = new EntityPoop(this.field_70170_p, (EntityLivingBase)this);
        projectile.setProjectileScale(2.0f);
        projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
        float accuracy = 2.0f * (this.func_70681_au().nextFloat() - 0.5f);
        double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
        double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
        double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
        this.func_85030_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)projectile);
        super.rangedAttack(target, range);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.field_70170_p.field_72995_K && this.vespidInfection) {
            this.spawnVespidSwarm();
        }
        super.func_70645_a(damageSource);
    }

    public void spawnVespidSwarm() {
        int j = 2 + this.field_70146_Z.nextInt(5) + this.field_70170_p.field_73013_u.func_151525_a() - 1;
        for (int k = 0; k < j; ++k) {
            float f = ((float)(k % 2) - 0.5f) * this.field_70130_N / 4.0f;
            float f1 = ((float)(k / 2) - 0.5f) * this.field_70130_N / 4.0f;
            EntityVespid vespid = new EntityVespid(this.field_70170_p);
            vespid.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            vespid.setSubspecies(this.getSubspeciesIndex(), true);
            vespid.setGrowingAge(vespid.growthTime);
            this.field_70170_p.func_72838_d((Entity)vespid);
            if (this.func_70638_az() == null) continue;
            vespid.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean extraAnimation01() {
        if (!this.field_70170_p.field_72995_K) {
            return this.vespidInfection;
        }
        return this.extraAnimation01;
    }

    @Override
    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        if (par1PotionEffect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return false;
        }
        if (par1PotionEffect.func_76456_a() == Potion.field_76421_d.field_76415_H) {
            return false;
        }
        if (par1PotionEffect.func_76456_a() == Potion.field_76431_k.field_76415_H) {
            return false;
        }
        super.func_70687_e(par1PotionEffect);
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("VespidInfection")) {
            this.vespidInfection = nbtTagCompound.func_74767_n("VespidInfection");
        }
        if (nbtTagCompound.func_74764_b("VespidInfectionTime")) {
            this.vespidInfectionTime = nbtTagCompound.func_74762_e("VespidInfectionTime");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("VespidInfection", this.vespidInfection);
        if (this.vespidInfection) {
            nbtTagCompound.func_74768_a("VespidInfectionTime", this.vespidInfectionTime);
        }
    }
}

