/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.demonmobs.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ClientProxy;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.block.BlockBase;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.info.ItemInfo;
import lycanite.lycanitesmobs.demonmobs.DemonMobs;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHellfire
extends BlockBase {
    public BlockHellfire() {
        super(Material.field_151581_o);
        this.group = DemonMobs.group;
        this.blockName = "hellfire";
        this.setup();
        this.tickRate = ConfigBase.getConfig(this.group, "general").getBool("Features", "Enable Hellfire", true) ? 200 : 1;
        this.removeOnTick = false;
        this.loopTicks = true;
        this.canBeCrushed = true;
        this.noEntityCollision = true;
        this.noBreakCollision = false;
        this.isOpaque = false;
        this.func_149713_g(1);
        this.func_149715_a(0.8f);
    }

    @Override
    public int func_149738_a(World par1World) {
        return 30;
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random random) {
        boolean onFireFuel;
        if (!ConfigBase.getConfig(this.group, "general").getBool("Features", "Enable Hellfire")) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
        }
        if (!world.func_82736_K().func_82766_b("doFireTick") && ItemInfo.removeOnNoFireTick) {
            world.func_147468_f(x, y, z);
            return;
        }
        if (!world.func_82736_K().func_82766_b("doFireTick") && !ItemInfo.removeOnNoFireTick) {
            return;
        }
        Block base = world.func_147439_a(x, y - 1, z);
        if (base == Blocks.field_150431_aC || base == Blocks.field_150329_H) {
            world.func_147449_b(x, y - 1, z, (Block)this);
            world.func_147468_f(x, y, z);
            return;
        }
        boolean bl = onFireFuel = base != null && base.isFireSource(world, x, y - 1, z, ForgeDirection.UP);
        if (!this.func_149742_c(world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
        if (!onFireFuel && world.func_72896_J() && (world.func_72951_B(x, y, z) || world.func_72951_B(x - 1, y, z) || world.func_72951_B(x + 1, y, z) || world.func_72951_B(x, y, z - 1) || world.func_72951_B(x, y, z + 1))) {
            world.func_147468_f(x, y, z);
            return;
        }
        super.func_149674_a(world, x, y, z, random);
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 15) {
            world.func_72921_c(x, y, z, metadata + random.nextInt(3) / 2, 4);
        }
        if (!onFireFuel && !this.canNeighborBurn(world, x, y, z)) {
            if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || metadata > 3) {
                world.func_147468_f(x, y, z);
                return;
            }
        }
        if (!onFireFuel && !this.canBlockBurn((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP) && metadata == 15 && random.nextInt(6) == 0) {
            world.func_147468_f(x, y, z);
            return;
        }
        boolean humid = world.func_72958_C(x, y, z);
        int humdity = 0;
        int burnChance = 50;
        int burnChanceSide = burnChance + 50;
        this.tryCatchFire(world, x + 1, y, z, burnChanceSide + humdity, random, metadata, ForgeDirection.WEST);
        this.tryCatchFire(world, x - 1, y, z, burnChanceSide + humdity, random, metadata, ForgeDirection.EAST);
        this.tryCatchFire(world, x, y - 1, z, burnChance + humdity, random, metadata, ForgeDirection.UP);
        this.tryCatchFire(world, x, y + 1, z, burnChance + humdity, random, metadata, ForgeDirection.DOWN);
        this.tryCatchFire(world, x, y, z - 1, burnChanceSide + humdity, random, metadata, ForgeDirection.SOUTH);
        this.tryCatchFire(world, x, y, z + 1, burnChanceSide + humdity, random, metadata, ForgeDirection.NORTH);
        for (int targetX = x - 1; targetX <= x + 1; ++targetX) {
            for (int targetZ = z - 1; targetZ <= z + 1; ++targetZ) {
                for (int targetY = y - 1; targetY <= y + 4; ++targetY) {
                    int fireSpread;
                    if (targetX == x && targetY == y && targetZ == z) continue;
                    int fireResistance = 100;
                    if (targetY > y + 1) {
                        fireResistance += (targetY - (y + 1)) * 100;
                    }
                    if ((fireSpread = this.getChanceOfNeighborsEncouragingFire(world, targetX, targetY, targetZ)) <= 0) continue;
                    int fireChance = (fireSpread + 10 + world.field_73013_u.func_151525_a() * 7) / (metadata + 30);
                    if (humid) {
                        fireChance /= 2;
                    }
                    if (fireChance <= 0 || random.nextInt(fireResistance) > fireChance || world.func_72896_J() && world.func_72951_B(targetX, targetY, targetZ) || world.func_72951_B(targetX - 1, targetY, z) || world.func_72951_B(targetX + 1, targetY, targetZ) || world.func_72951_B(targetX, targetY, targetZ - 1) || world.func_72951_B(targetX, targetY, targetZ + 1)) continue;
                    int k2 = metadata + random.nextInt(5) / 4;
                    if (k2 > 15) {
                        k2 = 15;
                    }
                    world.func_147465_d(targetX, targetY, targetZ, (Block)this, k2, 3);
                }
            }
        }
    }

    @Override
    public boolean func_149698_L() {
        return false;
    }

    public boolean canBlockBurn(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return world.func_147439_a(x, y, z).isFlammable(world, x, y, z, face);
    }

    public boolean canNeighborBurn(World world, int x, int y, int z) {
        return this.canBlockBurn((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST) || this.canBlockBurn((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST) || this.canBlockBurn((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP) || this.canBlockBurn((IBlockAccess)world, x, y + 1, z, ForgeDirection.DOWN) || this.canBlockBurn((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH) || this.canBlockBurn((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH);
    }

    private void tryCatchFire(World world, int x, int y, int z, int chance, Random random, int metadata, ForgeDirection face) {
        int flammability = 0;
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            flammability = block.getFlammability((IBlockAccess)world, x, y, z, face);
        }
        if (random.nextInt(chance) < flammability / 8) {
            boolean flag;
            boolean bl = flag = world.func_147439_a(x, y, z) == Blocks.field_150335_W;
            if (random.nextInt(metadata + 10) < 5 && !world.func_72951_B(x, y, z)) {
                int k1 = metadata + random.nextInt(5) / 4;
                if (k1 > 15) {
                    k1 = 15;
                }
                world.func_147465_d(x, y, z, (Block)this, k1, 3);
            } else {
                world.func_147468_f(x, y, z);
            }
            if (flag) {
                Blocks.field_150335_W.func_149664_b(world, x, y, z, 1);
            }
        }
    }

    public int getChanceOfNeighborsEncouragingFire(World world, int x, int y, int z) {
        int initialChance = 0;
        if (!world.func_147437_c(x, y, z)) {
            return 0;
        }
        int fireChance = initialChance;
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x + 1, y, z, fireChance, ForgeDirection.WEST);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x - 1, y, z, fireChance, ForgeDirection.EAST);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x, y - 1, z, fireChance, ForgeDirection.UP);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x, y + 1, z, fireChance, ForgeDirection.DOWN);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x, y, z - 1, fireChance, ForgeDirection.SOUTH);
        fireChance = this.getChanceToEncourageFire((IBlockAccess)world, x, y, z + 1, fireChance, ForgeDirection.NORTH);
        return fireChance;
    }

    public int getChanceToEncourageFire(IBlockAccess world, int x, int y, int z, int oldChance, ForgeDirection face) {
        int newChance = world.func_147439_a(x, y, z).getFireSpreadSpeed(world, x, y, z, face);
        return newChance > oldChance ? newChance : oldChance;
    }

    @Override
    public Item func_149650_a(int metadata, Random random, int fortune) {
        return ObjectManager.getItem("HellfireCharge");
    }

    @Override
    public int func_149692_a(int metadata) {
        return 0;
    }

    @Override
    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        super.func_149670_a(world, x, y, z, entity);
        if (entity instanceof EntityItem && ((EntityItem)entity).func_92059_d() != null && ((EntityItem)entity).func_92059_d().func_77973_b() == ObjectManager.getItem("hellfirecharge")) {
            return;
        }
        if (entity.func_70045_F()) {
            return;
        }
        entity.func_70097_a(DamageSource.field_76371_c, 2.0f);
        entity.func_70015_d(5);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(24) == 0) {
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), AssetManager.getSound("hellfire"), 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int l = 0; l < 12; ++l) {
            float f = (float)x + random.nextFloat();
            float f1 = (float)y + random.nextFloat() * 0.5f;
            float f2 = (float)z + random.nextFloat();
            world.func_72869_a("reddust", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        AssetManager.addIconGroup(this.blockName, this.group, new String[]{"hellfire_layer_0", "hellfire_layer_1"}, iconRegister);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return AssetManager.getIconGroup(this.blockName)[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return ClientProxy.RENDER_ID;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }
}

