/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.spawning;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBase;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeBlockBreak;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeDeath;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeSleep;
import lycanite.lycanitesmobs.api.spawning.SpawnTypeStorm;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;

public class CustomSpawner {
    public static CustomSpawner instance;
    public List<SpawnTypeBase> updateSpawnTypes = new ArrayList<SpawnTypeBase>();
    public Map<EntityPlayer, Long> entityUpdateTicks = new HashMap<EntityPlayer, Long>();
    public List<SpawnTypeDeath> deathSpawnTypes = new ArrayList<SpawnTypeDeath>();
    public List<SpawnTypeBlockBreak> blockSpawnTypes = new ArrayList<SpawnTypeBlockBreak>();
    public List<SpawnTypeSleep> sleepSpawnTypes = new ArrayList<SpawnTypeSleep>();
    public List<SpawnTypeStorm> lightningStrikeTypes = new ArrayList<SpawnTypeStorm>();

    public CustomSpawner() {
        instance = this;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity == null || !(entity instanceof EntityPlayer) || entity.field_70170_p == null || entity.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        World world = player.field_70170_p;
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        if (!this.entityUpdateTicks.containsKey(player)) {
            this.entityUpdateTicks.put(player, 0L);
        }
        long entityUpdateTick = this.entityUpdateTicks.get(player);
        int tickOffset = 0;
        for (SpawnTypeBase spawnType : this.updateSpawnTypes) {
            spawnType.spawnMobs(entityUpdateTick - (long)tickOffset, world, x, y, z, player);
            tickOffset += 105;
        }
        this.entityUpdateTicks.put(player, entityUpdateTick + 1L);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity == null || entity.field_70170_p == null || entity.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        Entity killerEntity = event.source.func_76364_f();
        if (!(killerEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase killer = (EntityLivingBase)killerEntity;
        if (!(killer instanceof EntityPlayer) && !(entity instanceof EntityPlayer)) {
            return;
        }
        World world = entity.field_70170_p;
        int x = (int)entity.field_70165_t;
        int y = (int)entity.field_70163_u;
        int z = (int)entity.field_70161_v;
        for (SpawnTypeDeath spawnType : this.deathSpawnTypes) {
            if (!spawnType.isValidKill(entity, killer)) continue;
            spawnType.spawnMobs(0L, world, x, y, z, null);
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.harvester;
        if (event.block == null || event.world == null || event.world.field_72995_K || event.isCanceled()) {
            return;
        }
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z + 1;
        for (SpawnTypeBlockBreak spawnType : this.blockSpawnTypes) {
            if (!spawnType.validBlockHarvest(event.block, world, x, y, z, (Entity)player)) continue;
            spawnType.spawnMobs(0L, world, x, y, z, player, event.block);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (event.block == null || event.world == null || event.world.field_72995_K || event.isCanceled()) {
            return;
        }
        if (player == null || player != null && player.field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z + 1;
        for (SpawnTypeBlockBreak spawnType : this.blockSpawnTypes) {
            if (!spawnType.validBlockBreak(event.block, world, x, y, z, (Entity)player)) continue;
            spawnType.spawnMobs(0L, world, x, y, z, player);
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.entityPlayer;
        if (player == null || event.isCanceled()) {
            return;
        }
        World world = player.field_70170_p;
        int x = event.x;
        int y = event.y;
        int z = event.z + 1;
        if (world == null || world.field_72995_K || world.field_73011_w.isDaytime()) {
            return;
        }
        boolean interrupted = false;
        for (SpawnTypeBase spawnTypeBase : this.sleepSpawnTypes) {
            if (!spawnTypeBase.spawnMobs(0L, world, x, y, z, player)) continue;
            interrupted = true;
        }
        if (interrupted) {
            event.result = EntityPlayer.EnumStatus.NOT_SAFE;
        }
    }

    public void onLightningStrike() {
    }
}

