/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lycanite.lycanitesmobs.api.entity.EntityParticle;
import lycanite.lycanitesmobs.api.entity.EntityProjectileBase;
import lycanite.lycanitesmobs.api.entity.EntityProjectileLaser;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderProjectile
extends Render {
    private IIcon icon;
    private float scale;
    private int renderTime = 0;
    protected ModelBase laserModel = new ModelBase(){};
    private ModelRenderer laserBox;

    public void func_76986_a(Entity entity, double par2, double par4, double par6, float par8, float par9) {
        if (this.renderTime++ > 0x7FFFFFFE) {
            this.renderTime = 0;
        }
        this.renderProjectile(entity, par2, par4, par6, par8, par9);
        if (entity instanceof EntityProjectileLaser) {
            this.renderLaser((EntityProjectileLaser)entity, par2, par4, par6, par8, par9);
        }
    }

    public void renderProjectile(Entity entity, double x, double y, double z, float par8, float par9) {
        float scale = 1.0f;
        if (entity instanceof EntityProjectileBase) {
            EntityProjectileBase entityProjectileBase = (EntityProjectileBase)entity;
            scale = entityProjectileBase.getProjectileScale();
            y += (double)entityProjectileBase.getTextureOffsetY();
        }
        this.func_110777_b(entity);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glEnable((int)32826);
        GL11.glScalef((float)(0.5f * scale), (float)(0.5f * scale), (float)(0.5f * scale));
        Tessellator tessellator = Tessellator.field_78398_a;
        this.renderTexture(tessellator, entity);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void renderLaser(EntityProjectileLaser entity, double par2, double par4, double par6, float par8, float par9) {
        float scale = entity.getLaserWidth();
        if (this.laserBox == null) {
            this.laserBox = new ModelRenderer(this.laserModel, 0, 0);
            this.laserBox.func_78789_a(-(scale / 2.0f), -(scale / 2.0f), 0.0f, (int)scale, (int)scale, 16);
            this.laserBox.field_78800_c = 0.0f;
            this.laserBox.field_78797_d = 0.0f;
            this.laserBox.field_78798_e = 0.0f;
        }
        float factor = 0.0625f;
        float lasti = 0.0f;
        float laserSize = entity.getLength();
        if (laserSize <= 0.0f) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        this.func_110776_a(this.getLaserTexture(entity));
        float[] angles = entity.getBeamAngles();
        GL11.glRotatef((float)angles[1], (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)angles[3], (float)1.0f, (float)0.0f, (float)0.0f);
        for (float i = 0.0f; i <= laserSize - 1.0f; i += 1.0f) {
            this.laserBox.func_78785_a(factor);
            GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
            lasti = i;
        }
        GL11.glScalef((float)(laserSize - (lasti += 1.0f)), (float)1.0f, (float)1.0f);
        this.laserBox.func_78785_a(factor);
        GL11.glPopMatrix();
    }

    private double func_110828_a(double par1, double par3, double par5) {
        return par1 + (par3 - par1) * par5;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        if (entity instanceof EntityProjectileBase) {
            return ((EntityProjectileBase)entity).getTexture();
        }
        if (entity instanceof EntityParticle) {
            return ((EntityParticle)entity).getTexture();
        }
        return null;
    }

    protected ResourceLocation getLaserTexture(EntityProjectileLaser entity) {
        return entity.getBeamTexture();
    }

    private void renderTexture(Tessellator tessellator, Entity entity) {
        float uMin = 0.0f;
        float uMax = 1.0f;
        float vMin = 0.0f;
        float vMax = 1.0f;
        if (entity instanceof EntityProjectileBase) {
            EntityProjectileBase entityProjectile = (EntityProjectileBase)entity;
            if (entityProjectile.animationFrameMax > 0) {
                vMin = (float)entityProjectile.animationFrame / (float)entityProjectile.animationFrameMax;
                vMax = vMin + 1.0f / (float)entityProjectile.animationFrameMax;
            }
        }
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.5f;
        GL11.glRotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)(-this.scale / 2.0f), (double)(-this.scale / 2.0f), (double)(-this.scale / 2.0f));
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78374_a((double)(0.0f - f7), (double)(0.0f - f8), 0.0, (double)uMin, (double)vMax);
        tessellator.func_78374_a((double)(f6 - f7), (double)(0.0f - f8), 0.0, (double)uMax, (double)vMax);
        tessellator.func_78374_a((double)(f6 - f7), (double)(1.0f - f8), 0.0, (double)uMax, (double)vMin);
        tessellator.func_78374_a((double)(0.0f - f7), (double)(1.0f - f8), 0.0, (double)uMin, (double)vMin);
        tessellator.func_78381_a();
    }

    private void renderIcon(Tessellator par1Tessellator, IIcon par2Icon) {
        float f = par2Icon.func_94209_e();
        float f1 = par2Icon.func_94212_f();
        float f2 = par2Icon.func_94206_g();
        float f3 = par2Icon.func_94210_h();
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        GL11.glRotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        par1Tessellator.func_78374_a((double)(0.0f - f5), (double)(0.0f - f6), 0.0, (double)f, (double)f3);
        par1Tessellator.func_78374_a((double)(f4 - f5), (double)(0.0f - f6), 0.0, (double)f1, (double)f3);
        par1Tessellator.func_78374_a((double)(f4 - f5), (double)(f4 - f6), 0.0, (double)f1, (double)f2);
        par1Tessellator.func_78374_a((double)(0.0f - f5), (double)(f4 - f6), 0.0, (double)f, (double)f2);
        par1Tessellator.func_78381_a();
    }
}

