/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.pets.SummonSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class MessageSummonSet
implements IMessage,
IMessageHandler<MessageSummonSet, IMessage> {
    public byte summonSetID;
    public String summonType;
    public byte behaviour;

    public MessageSummonSet() {
    }

    public MessageSummonSet(ExtendedPlayer playerExt, byte summonSetID) {
        this.summonSetID = summonSetID;
        this.summonType = playerExt.getSummonSet((int)summonSetID).summonType;
        this.behaviour = playerExt.getSummonSet(summonSetID).getBehaviourByte();
    }

    public IMessage onMessage(MessageSummonSet message, MessageContext ctx) {
        EntityPlayer player = null;
        if (ctx.side == Side.CLIENT) {
            player = LycanitesMobs.proxy.getClientPlayer();
        } else if (ctx.side == Side.SERVER) {
            player = ctx.getServerHandler().field_147369_b;
        }
        if (player == null) {
            return null;
        }
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return null;
        }
        SummonSet summonSet = playerExt.getSummonSet(message.summonSetID);
        summonSet.readFromPacket(message.summonType, message.behaviour);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        try {
            this.summonSetID = packet.readByte();
            this.summonType = packet.func_150789_c(256);
            this.behaviour = packet.readByte();
        }
        catch (IOException e) {
            LycanitesMobs.printWarning("", "There was a problem decoding the packet: " + packet + ".");
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        try {
            packet.writeByte((int)this.summonSetID);
            packet.func_150785_a(this.summonType);
            packet.writeByte((int)this.behaviour);
        }
        catch (IOException e) {
            LycanitesMobs.printWarning("", "There was a problem encoding the packet: " + packet + ".");
            e.printStackTrace();
        }
    }
}

