/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.mods;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.info.MobInfo;

public class DLDungeons {
    public static void init() {
        if (!Loader.isModLoaded((String)"DLDungeonsJBG")) {
            return;
        }
        LycanitesMobs.printInfo("", "Doomlike Dungeons Mod Detected...");
        Class<?> dlDungeonsAPI = null;
        Method isLoaded = null;
        try {
            dlDungeonsAPI = Class.forName("jaredbgreat.dldungeons.api.DLDungeonsAPI");
            isLoaded = dlDungeonsAPI.getMethod("isLoaded", new Class[0]);
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "Unable to find DLDungeons API Class/Method via reflection:");
            e.printStackTrace();
        }
        if (dlDungeonsAPI == null || isLoaded == null) {
            return;
        }
        try {
            if (((Boolean)isLoaded.invoke(null, new Object[0])).booleanValue()) {
                MobInfo.dlDungeonsLoaded = true;
            }
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "Unable to invoke DLDungeons API method isLoaded():");
            e.printStackTrace();
        }
    }

    public static void addMob(MobInfo mobInfo) {
        String mobName = mobInfo.getRegistryName();
        String themes = mobInfo.dungeonThemes.replace("GROUP", mobInfo.group.dungeonThemes).replace(" ", "");
        if (!"".equalsIgnoreCase(themes) && mobInfo.dungeonLevel > 0) {
            try {
                Class<?> dlDungeonsAPI = Class.forName("jaredbgreat.dldungeons.api.DLDungeonsAPI");
                Method addMob = dlDungeonsAPI.getMethod("addMob", String.class, Integer.TYPE, String[].class);
                addMob.invoke(null, mobName, mobInfo.dungeonLevel, themes.split(","));
                LycanitesMobs.printDebug("MobSetup", "[DLDungeons] Added " + mobName + " with the level: " + mobInfo.dungeonLevel + " and themes: " + themes);
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "Unable to add " + mobName + " to DLDungeons API:");
            }
        }
    }
}

