/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.api.item.ItemBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemScepter
extends ItemBase {
    private float damageScale = 1.0f;
    private int weaponFlash = 0;

    public ItemScepter() {
        this.func_77625_d(1);
        this.func_77656_e(this.getDurability());
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        return itemStack;
    }

    @Override
    public void onUsingTick(ItemStack itemStack, EntityPlayer player, int useRemaining) {
        int rapidRemainder;
        if (itemStack == null || player == null || player.field_70170_p == null) {
            return;
        }
        int useTime = this.func_77626_a(itemStack) - useRemaining;
        if (useTime > this.getRapidTime(itemStack) && (rapidRemainder = useTime % this.getRapidTime(itemStack)) == 0 && player.field_70170_p != null && this.rapidAttack(itemStack, player.field_70170_p, player)) {
            this.damageItemRapid(itemStack, player);
            this.weaponFlash = Math.max(20, this.getRapidTime(itemStack));
        }
        if (useTime >= this.getChargeTime(itemStack)) {
            this.weaponFlash = Math.max(20, this.getChargeTime(itemStack));
        }
        super.onUsingTick(itemStack, player, useRemaining);
    }

    @Override
    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer player, int useRemaining) {
        int useTime = this.func_77626_a(itemStack) - useRemaining;
        float power = (float)useTime / (float)this.getChargeTime(itemStack);
        this.weaponFlash = 0;
        if ((double)power < 0.1) {
            return;
        }
        if (power > 1.0f) {
            power = 1.0f;
        }
        if (this.chargedAttack(itemStack, world, player, power)) {
            this.damageItemCharged(itemStack, player, power);
            this.weaponFlash = Math.min(20, this.getChargeTime(itemStack));
        }
    }

    @Override
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public void damageItemRapid(ItemStack itemStack, EntityPlayer player) {
        itemStack.func_77972_a(1, (EntityLivingBase)player);
    }

    public void damageItemCharged(ItemStack itemStack, EntityPlayer player, float power) {
        itemStack.func_77972_a((int)(10.0f * power), (EntityLivingBase)player);
    }

    public int getDurability() {
        return 250;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    public int getChargeTime(ItemStack itemStack) {
        return this.func_77626_a(itemStack);
    }

    public int getRapidTime(ItemStack itemStack) {
        return this.func_77626_a(itemStack);
    }

    public boolean rapidAttack(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            // empty if block
        }
        return false;
    }

    public boolean chargedAttack(ItemStack itemStack, World world, EntityPlayer player, float power) {
        if (!world.field_72995_K) {
            // empty if block
        }
        return false;
    }

    @Override
    public int func_77619_b() {
        return 18;
    }

    @Override
    public boolean func_82789_a(ItemStack itemStack, ItemStack repairStack) {
        return super.func_82789_a(itemStack, repairStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (this.weaponFlash-- > 0) {
            return AssetManager.getIconGroup(this.itemName)[1];
        }
        return AssetManager.getIconGroup(this.itemName)[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        AssetManager.addIconGroup(this.itemName, this.group, new String[]{this.textureName, this.textureName + "_fire"}, iconRegister);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

