/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.info.ItemInfo;
import lycanite.lycanitesmobs.api.item.ItemBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCustomFood
extends ItemFood {
    public String itemName = "customfood";
    public GroupInfo group = LycanitesMobs.group;
    public String texturePath = "customfood";
    public FOOD_CLASS foodClass = FOOD_CLASS.NONE;
    protected int effectID;
    protected int effectAmplifier;
    protected float effectChance;

    public ItemCustomFood(String setItemName, GroupInfo group, String setTexturePath, int feed, float saturation, FOOD_CLASS foodClass) {
        super(feed, saturation, false);
        this.itemName = setItemName;
        this.group = group;
        this.texturePath = setTexturePath;
        this.foodClass = foodClass;
        this.func_77625_d(64);
        this.func_77637_a(LycanitesMobs.itemsTab);
        this.func_77655_b(this.itemName);
    }

    public ItemCustomFood(String setItemName, GroupInfo group, int feed, float saturation, FOOD_CLASS foodClass) {
        this(setItemName, group, setItemName.toLowerCase(), feed, saturation, foodClass);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List textList, boolean par4) {
        String description = this.getDescription(itemStack, entityPlayer, textList, par4);
        if (!"".equalsIgnoreCase(description) && !("item." + this.itemName + ".description").equals(description)) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List formattedDescriptionList = fontRenderer.func_78271_c(description, ItemBase.descriptionWidth);
            for (Object formattedDescription : formattedDescriptionList) {
                if (!(formattedDescription instanceof String)) continue;
                textList.add("\u00a7a" + (String)formattedDescription);
            }
        }
        super.func_77624_a(itemStack, entityPlayer, textList, par4);
    }

    public String getDescription(ItemStack itemStack, EntityPlayer entityPlayer, List textList, boolean par4) {
        return StatCollector.func_74838_a((String)("item." + this.itemName + ".description"));
    }

    public int getEffectDuration() {
        if (this.foodClass == FOOD_CLASS.RAW) {
            return ItemInfo.durationRaw * 20;
        }
        if (this.foodClass == FOOD_CLASS.COOKED) {
            return ItemInfo.durationCooked * 20;
        }
        if (this.foodClass == FOOD_CLASS.MEAL) {
            return ItemInfo.durationMeal * 20;
        }
        if (this.foodClass == FOOD_CLASS.FEAST) {
            return ItemInfo.durationFeast * 20;
        }
        return 1;
    }

    public ItemCustomFood setPotionEffect(int id, int amplifier, float chance) {
        this.effectID = id;
        this.effectAmplifier = amplifier;
        this.effectChance = chance;
        return this;
    }

    public ItemFood func_77844_a(int id, int duration, int amplifier, float chance) {
        return this.setPotionEffect(id, amplifier, chance);
    }

    protected void func_77849_c(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K || this.effectID <= 0) {
            return;
        }
        if (player.func_70681_au().nextFloat() >= this.effectChance) {
            return;
        }
        player.func_70690_d(new PotionEffect(this.effectID, this.getEffectDuration(), this.effectAmplifier));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return AssetManager.getIcon(this.itemName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        AssetManager.addIcon(this.itemName, this.group, this.texturePath, iconRegister);
    }

    public static enum FOOD_CLASS {
        NONE(0),
        RAW(1),
        COOKED(2),
        MEAL(3),
        FEAST(4);

        public final int id;

        private FOOD_CLASS(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

