/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.info;

import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lycanite.lycanitesmobs.LycanitesMobs;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityListCustom {
    public Map stringToClassMapping = new HashMap();
    public Map classToStringMapping = new HashMap();
    public Map IDtoClassMapping = new HashMap();
    private Map classToIDMapping = new HashMap();
    private Map stringToIDMapping = new HashMap();
    public HashMap entityEggs = new LinkedHashMap();

    public void addMapping(Class par0Class, String par1Str, int par2) {
        this.stringToClassMapping.put(par1Str, par0Class);
        this.classToStringMapping.put(par0Class, par1Str);
        this.IDtoClassMapping.put(par2, par0Class);
        this.classToIDMapping.put(par0Class, par2);
        this.stringToIDMapping.put(par1Str, par2);
    }

    public void addMapping(Class par0Class, String par1Str, int par2, int par3, int par4) {
        this.addMapping(par0Class, par1Str, par2);
        this.entityEggs.put(par2, new EntityEggInfo(par2, par3, par4));
    }

    public Entity createEntityByName(String par0Str, World par1World) {
        Entity entity = null;
        try {
            Class oclass = (Class)this.stringToClassMapping.get(par0Str);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(par1World);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public Entity createEntityFromNBT(NBTTagCompound par0NBTTagCompound, World par1World) {
        Entity entity = null;
        if ("Minecart".equals(par0NBTTagCompound.func_74779_i("id"))) {
            switch (par0NBTTagCompound.func_74762_e("Type")) {
                case 0: {
                    par0NBTTagCompound.func_74778_a("id", "MinecartRideable");
                    break;
                }
                case 1: {
                    par0NBTTagCompound.func_74778_a("id", "MinecartChest");
                    break;
                }
                case 2: {
                    par0NBTTagCompound.func_74778_a("id", "MinecartFurnace");
                }
            }
            par0NBTTagCompound.func_82580_o("Type");
        }
        Class oclass = null;
        try {
            oclass = (Class)this.stringToClassMapping.get(par0NBTTagCompound.func_74779_i("id"));
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(par1World);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            try {
                entity.func_70020_e(par0NBTTagCompound);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An Entity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{par0NBTTagCompound.func_74779_i("id"), oclass.getName()});
                entity = null;
            }
        } else {
            LycanitesMobs.printWarning("", "Unable to spawn entity with the id " + par0NBTTagCompound.func_74779_i("id"));
        }
        return entity;
    }

    public Entity createEntityByID(int par0, World par1World) {
        Entity entity = null;
        try {
            Class oclass = this.getClassFromID(par0);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(par1World);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            LycanitesMobs.printWarning("", "Unable to spawn entity with the id " + par0);
        }
        return entity;
    }

    public int getEntityID(Entity par0Entity) {
        Class<?> oclass = par0Entity.getClass();
        return this.classToIDMapping.containsKey(oclass) ? (Integer)this.classToIDMapping.get(oclass) : 0;
    }

    public Class getClassFromID(int par0) {
        return (Class)this.IDtoClassMapping.get(par0);
    }

    public String getEntityString(Entity par0Entity) {
        return (String)this.classToStringMapping.get(par0Entity.getClass());
    }

    public String getStringFromID(int par0) {
        Class oclass = this.getClassFromID(par0);
        return oclass != null ? (String)this.classToStringMapping.get(oclass) : null;
    }

    public static class EntityEggInfo {
        public final int spawnedID;
        public final int primaryColor;
        public final int secondaryColor;
        private static final String __OBFID = "CL_00001539";

        public EntityEggInfo(int par1, int par2, int par3) {
            this.spawnedID = par1;
            this.primaryColor = par2;
            this.secondaryColor = par3;
        }
    }
}

