/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.gui;

import cpw.mods.fml.client.GuiScrollingList;
import java.net.URI;
import java.net.URISyntaxException;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.GuiHandler;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.gui.GUIFamiliarList;
import lycanite.lycanitesmobs.api.gui.GUITabMain;
import lycanite.lycanitesmobs.api.network.MessageGUIRequest;
import lycanite.lycanitesmobs.api.pets.PetEntry;
import lycanite.lycanitesmobs.api.pets.SummonSet;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GUIFamiliar
extends GuiScreen {
    public EntityPlayer player;
    public ExtendedPlayer playerExt;
    public PetEntry petEntry;
    public SummonSet summonSet;
    public int familiarListSize = 0;
    public GuiScrollingList list;
    public int centerX;
    public int centerY;
    public int windowWidth;
    public int windowHeight;
    public int halfX;
    public int halfY;
    public int windowX;
    public int windowY;

    public static void openToPlayer(EntityPlayer player) {
        if (player != null && player.field_70170_p != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.PLAYER.id, player.field_70170_p, (int)GuiHandler.PlayerGuiType.FAMILIAR_MANAGER.id, 0, 0);
            MessageGUIRequest message = new MessageGUIRequest(GuiHandler.PlayerGuiType.FAMILIAR_MANAGER.id);
            LycanitesMobs.packetHandler.sendToServer(message);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public boolean func_73868_f() {
        return false;
    }

    public GUIFamiliar(EntityPlayer player) {
        this.player = player;
        this.playerExt = ExtendedPlayer.getForPlayer(player);
        this.familiarListSize = this.playerExt.petManager.familiars.size();
        if (this.hasFamiliars()) {
            this.petEntry = this.playerExt.petManager.getEntry("familiar", 0);
            this.summonSet = this.petEntry.summonSet;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.centerX = this.field_146294_l / 2;
        this.centerY = this.field_146295_m / 2;
        this.windowWidth = 176;
        this.windowHeight = 166;
        this.halfX = this.windowWidth / 2;
        this.halfY = this.windowHeight / 2;
        this.windowX = this.centerX - this.windowWidth / 2;
        this.windowY = this.centerY - this.windowHeight / 2;
        this.drawControls();
        if (this.hasFamiliars()) {
            int buttonSpacing = 2;
            this.list = new GUIFamiliarList(this, this.playerExt, this.windowWidth / 2 - buttonSpacing * 2, this.windowHeight - 16 - buttonSpacing * 2, this.windowY + 16, this.windowY + this.windowHeight - 28 - buttonSpacing * 2, this.windowX + buttonSpacing * 2);
            this.list.registerScrollButtons(this.field_146292_n, 51, 52);
        }
    }

    public void func_73863_a(int x, int y, float f) {
        this.drawGuiContainerBackgroundLayer();
        this.updateControls();
        this.drawGuiContainerForegroundLayer();
        if (this.list != null) {
            this.list.drawScreen(x, y, f);
        }
        super.func_73863_a(x, y, f);
    }

    protected void drawGuiContainerForegroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hasFamiliars()) {
            this.getFontRenderer().func_78276_b(StatCollector.func_74838_a((String)"gui.familiarmanager.name"), this.windowX + 52, this.windowY + 6, 0xFFFFFF);
            return;
        }
        this.getFontRenderer().func_78276_b(StatCollector.func_74838_a((String)"gui.familiarmanager.empty"), this.windowX + 18, this.windowY + 6, 0xFFFFFF);
        this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)"gui.familiarmanager.info"), this.windowX + 16, this.windowY + 24, this.windowWidth - 32, 0xFFFFFF);
    }

    protected void drawGuiContainerBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIFamiliar"));
        this.func_73729_b(this.windowX, this.windowY, 0, 0, this.windowWidth, this.windowHeight);
        if (this.petEntry == null) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
        int barWidth = 80;
        int barHeight = 11;
        int barX = this.centerX + 2;
        int barY = this.windowY + 16;
        int barU = 144;
        int barV = 256 - barHeight * 2;
        this.func_73729_b(barX, barY, barU, barV, barWidth, barHeight);
        if (!this.petEntry.isRespawning) {
            barWidth = Math.round((float)barWidth * (this.petEntry.getHealth() / this.petEntry.getMaxHealth()));
            barV += barHeight;
        } else {
            barWidth -= Math.round((float)barWidth * ((float)this.petEntry.respawnTime / (float)this.petEntry.respawnTimeMax));
            barV -= barHeight;
        }
        this.func_73729_b(barX, barY, barU, barV, barWidth, barHeight);
    }

    protected void drawControls() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 1;
        int buttonWidth = this.windowWidth / 2 - buttonSpacing * 4;
        int buttonHeight = 20;
        int buttonY = this.windowY + 5;
        int buttonX = this.windowX + buttonSpacing * 2;
        this.field_146292_n.add(new GUITabMain(55555, buttonX, this.windowY - 27));
        if (!this.hasFamiliars()) {
            this.field_146292_n.add(new GuiButton(100, this.windowX + this.windowWidth / 2 - buttonWidth / 2, this.windowY + this.windowHeight - buttonHeight - 16, buttonWidth, buttonHeight, "Patreon"));
            return;
        }
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.SPAWNING.id, buttonX, this.windowY + this.windowHeight - buttonHeight - 9, buttonWidth, buttonHeight, "..."));
        buttonX = this.centerX + buttonSpacing;
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.TELEPORT.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.SITTING.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.STANCE.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.PVP.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
    }

    public void updateControls() {
        if (!this.hasFamiliars()) {
            return;
        }
        for (Object buttonObj : this.field_146292_n) {
            if (!(buttonObj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)buttonObj;
            if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SPAWNING.id) {
                button.field_146126_j = StatCollector.func_74838_a((String)"gui.pet.active") + ": " + (this.petEntry.spawningActive ? StatCollector.func_74838_a((String)"common.yes") : StatCollector.func_74838_a((String)"common.no"));
            }
            if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.TELEPORT.id) {
                button.field_146126_j = StatCollector.func_74838_a((String)"gui.pet.teleport");
            }
            if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SITTING.id) {
                button.field_146126_j = StatCollector.func_74838_a((String)"gui.pet.sitting") + ": " + (this.summonSet.getSitting() ? StatCollector.func_74838_a((String)"common.yes") : StatCollector.func_74838_a((String)"common.no"));
            }
            if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id) {
                String string = button.field_146126_j = this.summonSet.getFollowing() ? StatCollector.func_74838_a((String)"gui.pet.follow") : StatCollector.func_74838_a((String)"gui.pet.wander");
            }
            if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id) {
                button.field_146126_j = StatCollector.func_74838_a((String)"gui.pet.passive") + ": " + (this.summonSet.getPassive() ? StatCollector.func_74838_a((String)"common.yes") : StatCollector.func_74838_a((String)"common.no"));
            }
            if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.STANCE.id) {
                String string = button.field_146126_j = this.summonSet.getAggressive() ? StatCollector.func_74838_a((String)"gui.pet.aggressive") : StatCollector.func_74838_a((String)"gui.pet.defensive");
            }
            if (button.field_146127_k != EntityCreatureBase.GUI_COMMAND_ID.PVP.id) continue;
            button.field_146126_j = StatCollector.func_74838_a((String)"gui.pet.pvp") + ": " + (this.summonSet.getPVP() ? StatCollector.func_74838_a((String)"common.yes") : StatCollector.func_74838_a((String)"common.no"));
        }
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton != null) {
            if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SITTING.id) {
                boolean bl = this.summonSet.sitting = !this.summonSet.sitting;
            }
            if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id) {
                boolean bl = this.summonSet.following = !this.summonSet.following;
            }
            if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id) {
                boolean bl = this.summonSet.passive = !this.summonSet.passive;
            }
            if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.STANCE.id) {
                boolean bl = this.summonSet.aggressive = !this.summonSet.aggressive;
            }
            if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
                boolean bl = this.summonSet.pvp = !this.summonSet.pvp;
            }
            if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.TELEPORT.id) {
                this.petEntry.teleportEntity = true;
            }
            if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SPAWNING.id) {
                boolean bl = this.petEntry.spawningActive = !this.petEntry.spawningActive;
            }
            if (guiButton.field_146127_k == 100) {
                try {
                    this.openURI(new URI("https://www.patreon.com/lycanite"));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (guiButton.field_146127_k < 100) {
                this.playerExt.sendPetEntryToServer(this.petEntry);
            }
        }
        super.func_146284_a(guiButton);
    }

    public void selectPetEntry(PetEntry petEntry) {
        this.petEntry = this.playerExt.petManager.getEntry(petEntry.petEntryID);
        this.summonSet = this.petEntry.summonSet;
    }

    public PetEntry getSelectedPetEntry() {
        return this.petEntry;
    }

    public boolean hasFamiliars() {
        return this.familiarListSize > 0;
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1 || par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(par1, par2);
    }

    public void drawImage(int x, int y, int u, int v, int w, int h, float s, float t) {
        float z = this.field_73735_i;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + h), (double)z, (double)((float)(u + 0) * s), (double)((float)(v + h) * t));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)z, (double)((float)(u + w) * s), (double)((float)(v + h) * t));
        tessellator.func_78374_a((double)(x + w), (double)(y + 0), (double)z, (double)((float)(u + w) * s), (double)((float)(v + 0) * t));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)z, (double)((float)(u + 0) * s), (double)((float)(v + 0) * t));
        tessellator.func_78381_a();
    }

    private void openURI(URI uri) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, uri);
        }
        catch (Throwable throwable) {
            LycanitesMobs.printWarning("", "Unable to open link: " + uri.toString());
        }
    }
}

