/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.gui;

import java.net.URI;
import java.net.URISyntaxException;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.GuiHandler;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.gui.GUIBeastiaryCreatureList;
import lycanite.lycanitesmobs.api.gui.GUIBeastiaryGroupList;
import lycanite.lycanitesmobs.api.gui.GUITabMain;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GUIBeastiary
extends GuiScreen {
    public EntityPlayer player;
    public ExtendedPlayer playerExt;
    public int centerX;
    public int centerY;
    public int windowWidth;
    public int windowHeight;
    public int halfX;
    public int halfY;
    public int windowX;
    public int windowY;
    public GUIBeastiaryGroupList groupList;
    public GUIBeastiaryCreatureList creatureList;
    public EntityLivingBase creaturePreviewEntity;

    public static void openToPlayer(EntityPlayer player) {
        if (player != null && player.field_70170_p != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.PLAYER.id, player.field_70170_p, (int)GuiHandler.PlayerGuiType.BEASTIARY.id, 0, 0);
        }
    }

    public GUIBeastiary(EntityPlayer player) {
        this.player = player;
        this.playerExt = ExtendedPlayer.getForPlayer(player);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateSelectedCreature();
        this.field_146292_n.clear();
        this.windowWidth = 256;
        this.windowHeight = 172;
        this.halfX = this.windowWidth / 2;
        this.halfY = this.windowHeight / 2;
        this.windowX = this.field_146294_l / 2 - this.windowWidth / 2;
        this.windowY = this.field_146295_m / 2 - this.windowHeight / 2;
        this.centerX = this.windowX + this.windowWidth / 2;
        this.centerY = this.windowY + this.windowHeight / 2;
        this.drawControls();
        int buttonSpacing = 2;
        int listWidth = this.windowWidth / 2 - buttonSpacing * 4;
        int listHeight = this.windowHeight / 2 - 6 - buttonSpacing * 3;
        int listTop = this.windowY - buttonSpacing * 2 + 24;
        int listBottom = listTop + listHeight;
        int listX = this.windowX + buttonSpacing * 2;
        this.groupList = new GUIBeastiaryGroupList(this, listWidth, listHeight, listTop, listBottom, listX);
        this.groupList.registerScrollButtons(this.field_146292_n, 51, 52);
        this.creatureList = new GUIBeastiaryCreatureList(this, listWidth, listHeight, listTop += listHeight + buttonSpacing, listBottom += listHeight + buttonSpacing, listX);
        this.creatureList.registerScrollButtons(this.field_146292_n, 53, 54);
    }

    public void func_73863_a(int x, int y, float f) {
        this.drawGuiContainerBackgroundLayer(x, y, f);
        this.updateControls();
        this.drawGuiContainerForegroundLayer(x, y, f);
        this.groupList.drawScreen(x, y, f);
        this.creatureList.drawScreen(x, y, f);
        super.func_73863_a(x, y, f);
    }

    protected void drawGuiContainerForegroundLayer(int x, int y, float f) {
        boolean hasSomeKnowledge = this.playerExt.beastiary.creatureKnowledgeList.size() > 0;
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.beastiary.name"), this.windowX + 24, this.windowY + 8, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getSelectedCreature() != null && this.creaturePreviewEntity != null && hasSomeKnowledge) {
            int creatureSize = 17;
            int creatureScale = Math.round(1.8f / this.creaturePreviewEntity.field_70131_O * (float)creatureSize);
            int creatureX = this.centerX + this.halfX / 2;
            int creatureY = this.windowY + 32 + creatureSize;
            GuiInventory.func_147046_a((int)creatureX, (int)creatureY, (int)creatureScale, (float)((float)creatureX - (float)x), (float)((float)creatureY - (float)y), (EntityLivingBase)this.creaturePreviewEntity);
            this.field_146289_q.func_78276_b(this.getSelectedCreature().getTitle(), this.centerX + 8, this.windowY + 8, 0xFFFFFF);
            this.field_146289_q.func_78279_b(this.getSelectedCreature().getDescription(), this.centerX + 8, creatureY + creatureSize + 2, this.halfX - 16, 0xFFFFFF);
        } else if (this.getSelectedGroup() != null && hasSomeKnowledge) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)(this.getSelectedGroup().filename + ".name")), this.centerX + 8, this.windowY + 8, 0xFFFFFF);
            this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)(this.getSelectedGroup().filename + ".description")), this.centerX + 8, this.windowY + 24, this.halfX - 16, 0xFFFFFF);
        } else if (hasSomeKnowledge) {
            this.field_146289_q.func_78276_b("", this.centerX + 8, this.windowY + 8, 0xFFFFFF);
            this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)"gui.beastiary.selectacreature"), this.centerX + 8, this.windowY + 24, this.halfX - 16, 0xFFFFFF);
        } else {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.beastiary.empty"), this.centerX + 8, this.windowY + 8, 0xFFFFFF);
            this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)"gui.beastiary.soulgazerinfo"), this.centerX + 8, this.windowY + 24, this.halfX - 16, 0xFFFFFF);
            int recipeWidth = 108;
            int recipeHeight = 54;
            this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIBeastiary"));
            this.func_73729_b(this.centerX + this.halfX / 2 - recipeWidth / 2, this.windowY + this.windowHeight - recipeHeight - 4, 0, 256 - recipeHeight, recipeWidth, recipeHeight);
        }
    }

    protected void drawGuiContainerBackgroundLayer(int x, int y, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIBeastiary"));
        this.func_73729_b(this.windowX, this.windowY, 0, 0, this.windowWidth, this.windowHeight);
        if (this.getSelectedCreature() != null) {
            int levelBarWidth = 9;
            int levelBarHeight = 9;
            int levelBarX = this.centerX + 8;
            int levelBarY = this.windowY + 64 - levelBarHeight;
            int levelBarU = 256 - levelBarWidth * 2;
            int levelBarV = 256 - levelBarHeight;
            int level = this.getSelectedCreature().summonCost;
            for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
                this.func_73729_b(levelBarX + levelBarWidth * currentLevel, levelBarY, levelBarU, levelBarV, levelBarWidth, levelBarHeight);
            }
        }
    }

    protected void drawControls() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 2;
        int buttonWidth = 128;
        int buttonHeight = 20;
        int buttonX = this.windowX + 6;
        int buttonY = this.windowY;
        this.field_146292_n.add(new GUITabMain(55555, buttonX, buttonY - 24));
        this.field_146292_n.add(new GuiButton(100, this.centerX - buttonWidth / 2, this.windowY + this.windowHeight + 4, buttonWidth, buttonHeight, StatCollector.func_74838_a((String)"gui.beastiary.website")));
    }

    public void updateControls() {
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146127_k == 100) {
            try {
                String url = "http://lycanitesmobs.com/creature";
                if (this.getSelectedCreature() != null) {
                    url = url + "/" + this.getSelectedCreature().name;
                }
                this.openURI(new URI(url));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        super.func_146284_a(guiButton);
    }

    public void selectCategory(String category) {
        this.playerExt.beastiaryCategory = category;
    }

    public void selectGroup(GroupInfo group) {
        this.playerExt.beastiaryGroup = group;
        this.playerExt.beastiaryCategory = "group";
        if (this.creatureList != null) {
            this.creatureList.updateList();
            this.selectCreature(null);
        }
        this.updateSelectedCreature();
    }

    public GroupInfo getSelectedGroup() {
        return this.playerExt.beastiaryGroup;
    }

    public void selectCreature(MobInfo mobInfo) {
        this.playerExt.beastiaryCreature = mobInfo;
        this.updateSelectedCreature();
    }

    public MobInfo getSelectedCreature() {
        return this.playerExt.beastiaryCreature;
    }

    public void updateSelectedCreature() {
        if (this.getSelectedCreature() == null) {
            this.creaturePreviewEntity = null;
        } else {
            try {
                this.creaturePreviewEntity = (EntityLivingBase)this.getSelectedCreature().entityClass.getConstructor(World.class).newInstance(this.player.field_70170_p);
                this.creaturePreviewEntity.field_70122_E = true;
                if (this.creaturePreviewEntity instanceof EntityCreatureAgeable) {
                    ((EntityCreatureAgeable)this.creaturePreviewEntity).setGrowingAge(0);
                }
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "Tried to preview an invalid creature in the Beastiary.");
                e.printStackTrace();
            }
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1 || par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(par1, par2);
    }

    public void drawImage(int x, int y, int u, int v, int w, int h, float s, float t) {
        float z = this.field_73735_i;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + h), (double)z, (double)((float)(u + 0) * s), (double)((float)(v + h) * t));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)z, (double)((float)(u + w) * s), (double)((float)(v + h) * t));
        tessellator.func_78374_a((double)(x + w), (double)(y + 0), (double)z, (double)((float)(u + w) * s), (double)((float)(v + 0) * t));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)z, (double)((float)(u + 0) * s), (double)((float)(v + 0) * t));
        tessellator.func_78381_a();
    }

    private void openURI(URI uri) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, uri);
        }
        catch (Throwable throwable) {
            LycanitesMobs.printWarning("", "Unable to open link: " + uri.toString());
        }
    }
}

