/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BlockBase
extends Block {
    public GroupInfo group;
    public String blockName = "BlockBase";
    public int tickRate = 0;
    public boolean removeOnTick = false;
    public boolean loopTicks = true;
    public boolean canBeCrushed = false;
    public boolean noEntityCollision = false;
    public boolean noBreakCollision = false;
    public boolean isOpaque = true;

    public BlockBase(Material material, GroupInfo group, String name) {
        super(material);
        this.group = group;
        this.blockName = name;
        this.setup();
    }

    public BlockBase(Material material) {
        super(material);
    }

    public void setup() {
        this.func_149663_c(this.blockName);
        this.func_149658_d(this.blockName.toLowerCase());
    }

    public String getDescription(ItemStack itemStack, EntityPlayer entityPlayer, List textList, boolean par4) {
        return StatCollector.func_74838_a((String)("tile." + this.blockName + ".description"));
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (this.tickRate > 0) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public Item func_149650_a(int breakID, Random random, int zero) {
        return super.func_149650_a(breakID, random, zero);
    }

    public int func_149692_a(int breakMetadata) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockID) {
        Block block = world.func_147439_a(x, y, z);
        if (this.canBeCrushed && (block == Blocks.field_150354_m || block == Blocks.field_150351_n)) {
            world.func_147468_f(x, y, z);
        }
    }

    public int func_149738_a(World world) {
        return this.tickRate;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (this.removeOnTick) {
            world.func_147468_f(x, y, z);
        } else if (this.tickRate > 0 && this.loopTicks) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public boolean func_149698_L() {
        return super.func_149698_L();
    }

    public boolean func_149653_t() {
        return this.tickRate > 0;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        if (this.noEntityCollision) {
            return null;
        }
        return super.func_149668_a(par1World, par2, par3, par4);
    }

    public boolean func_149703_v() {
        return !this.noBreakCollision;
    }

    public boolean func_149662_c() {
        return this.isOpaque;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        super.func_149670_a(world, x, y, z, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        AssetManager.addIcon(this.blockName, this.group, this.func_149641_N(), iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return AssetManager.getIcon(this.blockName);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getSubIcon(int subID) {
        return AssetManager.getIconGroup(this.blockName)[subID];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return super.func_149645_b();
    }

    public boolean func_149686_d() {
        return true;
    }

    public static enum RENDER_TYPE {
        NONE(-1),
        NORMAL(0),
        CROSS(1),
        TORCH(2),
        FIRE(3),
        FLUID(4);

        public final int id;

        private RENDER_TYPE(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

