/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class Utilities {
    public static void addDungeonLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        config.setCategoryComment("Dungeon Loot Enabled", "Here you can enable/disable dungeon loot for various types of dungeons.");
        if (config.getBool("Dungeon Loot Enabled", "Dungeons", true, "These are most dungeons from underground mob spawner dungeons to pyramids, mineshafts and jungle temples.")) {
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(itemStack, minAmount, maxAmount, weight));
            ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(itemStack, minAmount, maxAmount, weight));
            ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(itemStack, minAmount, maxAmount, weight));
            ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(itemStack, minAmount, maxAmount, weight));
        }
    }

    public static void addStrongholdLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        if (config.getBool("Dungeon Loot Enabled", "Strongholds", true, "Stronghold dungeons including corridors, libraries and other parts.")) {
            ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(itemStack, minAmount, maxAmount, weight));
            ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(itemStack, minAmount, maxAmount, weight));
            ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)new WeightedRandomChestContent(itemStack, minAmount, maxAmount, weight));
        }
    }

    public static void addVillageLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        if (config.getBool("Dungeon Loot Enabled", "Blacksmiths", true, "These are the chests found in village blacksmiths homes.")) {
            ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(itemStack, minAmount, maxAmount, weight));
        }
    }

    public static MovingObjectPosition raytrace(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, HashSet<Entity> excluded) {
        Vec3 startVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        Vec3 lookVec = Vec3.func_72443_a((double)(tx - x), (double)(ty - y), (double)(tz - z));
        Vec3 endVec = Vec3.func_72443_a((double)tx, (double)ty, (double)tz);
        float minX = (float)(x < tx ? x : tx);
        float minY = (float)(y < ty ? y : ty);
        float minZ = (float)(z < tz ? z : tz);
        float maxX = (float)(x > tx ? x : tx);
        float maxY = (float)(y > ty ? y : ty);
        float maxZ = (float)(z > tz ? z : tz);
        MovingObjectPosition collision = world.func_72901_a(startVec, endVec, false);
        startVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        endVec = Vec3.func_72443_a((double)tx, (double)ty, (double)tz);
        float maxDistance = (float)endVec.func_72438_d(startVec);
        if (collision != null) {
            maxDistance = (float)collision.field_72307_f.func_72438_d(startVec);
        }
        if (excluded != null) {
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            List allEntities = world.func_72839_b(null, bb);
            Entity closestHitEntity = null;
            float closestHit = Float.POSITIVE_INFINITY;
            float currentHit = 0.0f;
            for (Entity ent : allEntities) {
                MovingObjectPosition intercept;
                if (!ent.func_70067_L() || excluded.contains(ent)) continue;
                float entBorder = ent.func_70111_Y();
                AxisAlignedBB entityBb = ent.field_70121_D;
                if (entityBb == null || (intercept = (entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
                closestHit = currentHit;
                closestHitEntity = ent;
            }
            if (closestHitEntity != null) {
                collision = new MovingObjectPosition(closestHitEntity);
            }
        }
        return collision;
    }

    public static MovingObjectPosition raytraceEntities(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, HashSet<Entity> excluded) {
        Vec3 startVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        Vec3 lookVec = Vec3.func_72443_a((double)(tx - x), (double)(ty - y), (double)(tz - z));
        Vec3 endVec = Vec3.func_72443_a((double)tx, (double)ty, (double)tz);
        float minX = (float)(x < tx ? x : tx);
        float minY = (float)(y < ty ? y : ty);
        float minZ = (float)(z < tz ? z : tz);
        float maxX = (float)(x > tx ? x : tx);
        float maxY = (float)(y > ty ? y : ty);
        float maxZ = (float)(z > tz ? z : tz);
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        MovingObjectPosition collision = world.func_72901_a(startVec, endVec, false);
        Entity closestHitEntity = null;
        float closestHit = Float.POSITIVE_INFINITY;
        float currentHit = 0.0f;
        for (Entity ent : allEntities) {
            MovingObjectPosition intercept;
            if (!ent.func_70067_L() || excluded.contains(ent)) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.field_70121_D;
            if (entityBb == null || (intercept = (entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            collision = new MovingObjectPosition(closestHitEntity);
        }
        return collision;
    }

    public static boolean isHalloween() {
        block4: {
            block3: {
                Calendar calendar;
                block2: {
                    calendar = Calendar.getInstance();
                    if (calendar.get(5) != 31) break block2;
                    if (calendar.get(2) == 9) break block3;
                }
                if (calendar.get(5) != 1) break block4;
                if (calendar.get(2) != 10) break block4;
            }
            return true;
        }
        return false;
    }

    public static boolean isYuletide() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) > 9 && calendar.get(5) < 26;
    }

    public static boolean isYuletideDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) == 25;
    }

    public static boolean isNewYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 0 && calendar.get(5) == 1;
    }
}

