/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.GuiHandler;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.info.Beastiary;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.item.ItemStaffSummoning;
import lycanite.lycanitesmobs.api.network.MessagePetEntry;
import lycanite.lycanitesmobs.api.network.MessagePetEntryRemove;
import lycanite.lycanitesmobs.api.network.MessagePlayerStats;
import lycanite.lycanitesmobs.api.network.MessageSummonSet;
import lycanite.lycanitesmobs.api.network.MessageSummonSetSelection;
import lycanite.lycanitesmobs.api.pets.DonationFamiliars;
import lycanite.lycanitesmobs.api.pets.PetEntry;
import lycanite.lycanitesmobs.api.pets.PetManager;
import lycanite.lycanitesmobs.api.pets.SummonSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPlayer
implements IExtendedEntityProperties {
    public static String EXT_PROP_NAME = "LycanitesMobsPlayer";
    public static Map<String, NBTTagCompound> backupNBTTags = new HashMap<String, NBTTagCompound>();
    public EntityPlayer player;
    public Beastiary beastiary;
    public GroupInfo beastiaryGroup;
    public MobInfo beastiaryCreature;
    public String beastiaryCategory;
    public PetManager petManager;
    public long currentTick = 0L;
    public boolean needsFirstSync = true;
    public byte controlStates = 0;
    public int spiritCharge = 100;
    public int spiritMax;
    public int spirit = this.spiritMax = this.spiritCharge * 10;
    public int spiritReserved = 0;
    public int summonFocusCharge = 600;
    public int summonFocusMax;
    public int summonFocus = this.summonFocusMax = this.summonFocusCharge * 10;
    public Map<Integer, SummonSet> summonSets = new HashMap<Integer, SummonSet>();
    public int selectedSummonSet = 1;
    public int summonSetMax = 5;
    private boolean setupPetManager = false;

    public static ExtendedPlayer getForPlayer(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        IExtendedEntityProperties playerIExt = player.getExtendedProperties(EXT_PROP_NAME);
        ExtendedPlayer playerExt = playerIExt != null ? (ExtendedPlayer)playerIExt : new ExtendedPlayer(player);
        return playerExt;
    }

    public ExtendedPlayer(EntityPlayer player) {
        this.player = player;
        this.beastiary = new Beastiary(player);
        this.petManager = new PetManager((EntityLivingBase)player);
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)this);
    }

    public void onJoinWorld() {
        this.needsFirstSync = true;
        this.setupPetManager = false;
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        if (backupNBTTags.containsKey(this.player.func_70005_c_())) {
            this.loadNBTData(backupNBTTags.get(this.player.func_70005_c_()));
            backupNBTTags.remove(this.player.func_70005_c_());
        }
    }

    public void init(Entity entity, World world) {
    }

    public void onUpdate() {
        Object message;
        boolean creative = this.player.field_71075_bZ.field_75098_d;
        boolean sync = false;
        this.spirit = Math.min(Math.max(this.spirit, 0), this.spiritMax - this.spiritReserved);
        if (this.spirit < this.spiritMax - this.spiritReserved) {
            ++this.spirit;
            if (!this.player.field_70170_p.field_72995_K && this.currentTick % 20L == 0L || this.spirit == this.spiritMax - this.spiritReserved) {
                sync = true;
            }
        }
        this.summonFocus = Math.min(Math.max(this.summonFocus, 0), this.summonFocusMax);
        if (this.summonFocus < this.summonFocusMax) {
            ++this.summonFocus;
            if (!this.player.field_70170_p.field_72995_K && !creative && this.currentTick % 20L == 0L || this.summonFocus == this.summonFocusMax || this.player.func_70694_bm() != null && this.player.func_70694_bm().func_77973_b() instanceof ItemStaffSummoning) {
                sync = true;
            }
        }
        if (!this.player.field_70170_p.field_72995_K && sync) {
            message = new MessagePlayerStats(this);
            LycanitesMobs.packetHandler.sendToPlayer((IMessage)message, (EntityPlayerMP)this.player);
        }
        if (!this.player.field_70170_p.field_72995_K && !this.setupPetManager) {
            Map<String, PetEntry> playerFamiliars = DonationFamiliars.instance.getFamiliarsForPlayer(this.player);
            if (playerFamiliars != null) {
                this.petManager.clearEntries("familiar");
                for (PetEntry petEntry : playerFamiliars.values()) {
                    if (this.petManager.hasEntry(petEntry)) continue;
                    this.petManager.addEntry(petEntry);
                }
                this.sendPetEntriesToPlayer("familiar");
            }
            this.setupPetManager = true;
        }
        if (!this.player.field_70170_p.field_72995_K && this.needsFirstSync) {
            this.beastiary.sendAllToClient();
            this.sendAllSummonSetsToPlayer();
            message = new MessageSummonSetSelection(this);
            LycanitesMobs.packetHandler.sendToPlayer((IMessage)message, (EntityPlayerMP)this.player);
        }
        if (this.petManager.host != this.player) {
            this.petManager.host = this.player;
        }
        this.petManager.onUpdate(this.player.field_70170_p);
        ++this.currentTick;
        this.needsFirstSync = false;
    }

    public SummonSet getSummonSet(int setID) {
        if (setID <= 0) {
            LycanitesMobs.printWarning("", "Attempted to access set " + setID + " but the minimum ID is 1. Player: " + this.player);
            return null;
        }
        if (setID > this.summonSetMax) {
            LycanitesMobs.printWarning("", "Attempted to access set " + setID + " but the maximum set ID is " + this.summonSetMax + ". Player: " + this.player);
            return null;
        }
        if (!this.summonSets.containsKey(setID)) {
            this.summonSets.put(setID, new SummonSet(this));
        }
        return this.summonSets.get(setID);
    }

    public SummonSet getSelectedSummonSet() {
        if (this.selectedSummonSet != this.validateSummonSetID(this.selectedSummonSet)) {
            this.setSelectedSummonSet(this.selectedSummonSet);
        }
        return this.getSummonSet(this.selectedSummonSet);
    }

    public void setSelectedSummonSet(int targetSetID) {
        this.selectedSummonSet = targetSetID = this.validateSummonSetID(targetSetID);
    }

    public int validateSummonSetID(int targetSetID) {
        for (targetSetID = Math.max(Math.min(targetSetID, this.summonSetMax), 1); !this.getSummonSet(targetSetID).isUseable() && targetSetID > 1; --targetSetID) {
        }
        return targetSetID;
    }

    public Beastiary getBeastiary() {
        return this.beastiary;
    }

    public void onDeath() {
        if (backupNBTTags.containsKey(this.player.func_70005_c_())) {
            return;
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.saveNBTData(nbtTagCompound);
        backupNBTTags.put(this.player.func_70005_c_(), nbtTagCompound);
    }

    public void sendPetEntriesToPlayer(String entryType) {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        for (PetEntry petEntry : this.petManager.allEntries.values()) {
            if (!entryType.equals(petEntry.getType()) && !"".equals(entryType)) continue;
            MessagePetEntry message = new MessagePetEntry(this, petEntry);
            LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
        }
    }

    public void sendPetEntryToPlayer(PetEntry petEntry) {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        MessagePetEntry message = new MessagePetEntry(this, petEntry);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
    }

    public void sendPetEntryToServer(PetEntry petEntry) {
        if (!this.player.field_70170_p.field_72995_K) {
            return;
        }
        MessagePetEntry message = new MessagePetEntry(this, petEntry);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void sendPetEntryRemoveRequest(PetEntry petEntry) {
        if (!this.player.field_70170_p.field_72995_K) {
            return;
        }
        petEntry.remove();
        MessagePetEntryRemove message = new MessagePetEntryRemove(this, petEntry);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void sendAllSummonSetsToPlayer() {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        for (byte setID = 1; setID <= this.summonSetMax; setID = (byte)(setID + 1)) {
            MessageSummonSet message = new MessageSummonSet(this, setID);
            LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
        }
    }

    public void sendSummonSetToServer(byte setID) {
        if (!this.player.field_70170_p.field_72995_K) {
            return;
        }
        MessageSummonSet message = new MessageSummonSet(this, setID);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void updateControlStates(byte controlStates) {
        this.controlStates = controlStates;
    }

    public boolean isControlActive(CONTROL_ID controlID) {
        return (this.controlStates & controlID.id) > 0;
    }

    public void requestGUI(byte guiID) {
        if (guiID == GuiHandler.PlayerGuiType.PET_MANAGER.id) {
            this.sendPetEntriesToPlayer("pet");
        }
        if (guiID == GuiHandler.PlayerGuiType.MOUNT_MANAGER.id) {
            this.sendPetEntriesToPlayer("mount");
        }
        if (guiID == GuiHandler.PlayerGuiType.FAMILIAR_MANAGER.id) {
            this.sendPetEntriesToPlayer("familiar");
        }
    }

    public void loadNBTData(NBTTagCompound nbtTagCompound) {
        NBTTagCompound extTagCompound = nbtTagCompound.func_74775_l(EXT_PROP_NAME);
        this.beastiary.readFromNBT(extTagCompound);
        this.petManager.readFromNBT(extTagCompound);
        if (extTagCompound.func_74764_b("SummonFocus")) {
            this.summonFocus = extTagCompound.func_74762_e("SummonFocus");
        }
        if (extTagCompound.func_74764_b("Spirit")) {
            this.spirit = extTagCompound.func_74762_e("Spirit");
        }
        if (extTagCompound.func_74764_b("SelectedSummonSet")) {
            this.selectedSummonSet = extTagCompound.func_74762_e("SelectedSummonSet");
        }
        if (extTagCompound.func_74764_b("SummonSets")) {
            NBTTagList nbtSummonSets = extTagCompound.func_150295_c("SummonSets", 10);
            for (int setID = 0; setID < this.summonSetMax; ++setID) {
                NBTTagCompound nbtSummonSet = nbtSummonSets.func_150305_b(setID);
                SummonSet summonSet = new SummonSet(this);
                summonSet.readFromNBT(nbtSummonSet);
                this.summonSets.put(setID + 1, summonSet);
            }
        }
    }

    public void saveNBTData(NBTTagCompound nbtTagCompound) {
        NBTTagCompound extTagCompound = new NBTTagCompound();
        this.beastiary.writeToNBT(extTagCompound);
        this.petManager.writeToNBT(extTagCompound);
        extTagCompound.func_74768_a("SummonFocus", this.summonFocus);
        extTagCompound.func_74768_a("Spirit", this.spirit);
        extTagCompound.func_74768_a("SelectedSummonSet", this.selectedSummonSet);
        NBTTagList nbtSummonSets = new NBTTagList();
        for (int setID = 0; setID < this.summonSetMax; ++setID) {
            NBTTagCompound nbtSummonSet = new NBTTagCompound();
            SummonSet summonSet = this.getSummonSet(setID + 1);
            summonSet.writeToNBT(nbtSummonSet);
            nbtSummonSets.func_74742_a((NBTBase)nbtSummonSet);
        }
        extTagCompound.func_74782_a("SummonSets", (NBTBase)nbtSummonSets);
        nbtTagCompound.func_74782_a(EXT_PROP_NAME, (NBTBase)extTagCompound);
    }

    public static enum CONTROL_ID {
        JUMP(1),
        MOUNT_ABILITY(2),
        MOUNT_INVENTORY(4);

        public byte id;

        private CONTROL_ID(byte i) {
            this.id = i;
        }
    }
}

