/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import lycanite.lycanitesmobs.ExtendedEntity;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.ExtendedWorld;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.Utilities;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureRideable;
import lycanite.lycanitesmobs.api.entity.EntityItemCustom;
import lycanite.lycanitesmobs.api.info.ItemInfo;
import lycanite.lycanitesmobs.api.item.ItemBase;
import lycanite.lycanitesmobs.api.item.ItemSwordBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventListener {
    @SubscribeEvent
    public void onWorldLoading(WorldEvent.Load event) {
        if (event.world == null) {
            return;
        }
        ExtendedWorld.getForWorld(event.world);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity == null) {
            return;
        }
        if (event.entity.field_70170_p == null || event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.entity instanceof EntityLivingBase) && ExtendedEntity.FORCE_REMOVE_ENTITY_IDS != null && ExtendedEntity.FORCE_REMOVE_ENTITY_IDS.length > 0) {
            LycanitesMobs.printDebug("ForceRemoveEntity", "Forced entity removal, checking: " + event.entity.func_70005_c_());
            for (String forceRemoveID : ExtendedEntity.FORCE_REMOVE_ENTITY_IDS) {
                if (!forceRemoveID.equalsIgnoreCase(event.entity.func_70005_c_())) continue;
                event.entity.func_70106_y();
                break;
            }
        }
        if (event.entity instanceof EntityLivingBase) {
            ExtendedEntity.getForEntity(event.entity);
        }
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ExtendedPlayer.getForPlayer(player);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ExtendedPlayer playerExtended = ExtendedPlayer.getForPlayer(player);
            playerExtended.onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity == null) {
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity((Entity)entity);
        if (extendedEntity != null) {
            extendedEntity.onDeath();
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ExtendedPlayer.getForPlayer(player).onDeath();
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack equippedItemStack;
        EntityPlayer entityPlayer;
        EntityPlayer player;
        ExtendedPlayer playerExt;
        EntityLivingBase entity = event.entityLiving;
        if (entity == null) {
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity((Entity)entity);
        if (extendedEntity != null) {
            extendedEntity.onUpdate();
        }
        if (entity instanceof EntityPlayer && (playerExt = ExtendedPlayer.getForPlayer(player = (EntityPlayer)entity)) != null) {
            playerExt.onUpdate();
        }
        if (event.entityLiving instanceof EntityPlayer && (entityPlayer = (EntityPlayer)event.entityLiving).func_71045_bC() != null && (equippedItemStack = entityPlayer.func_71045_bC()).func_77973_b() instanceof ItemSwordBase) {
            ((ItemSwordBase)equippedItemStack.func_77973_b()).onEarlyUpdate(equippedItemStack, event.entityLiving);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Entity entity = event.target;
        if (player == null || entity == null) {
            return;
        }
        if (player.func_70694_bm() != null) {
            ItemStack itemStack = player.func_70694_bm();
            Item item = itemStack.func_77973_b();
            if (item instanceof ItemBase && ((ItemBase)item).onItemRightClickOnEntity(player, entity, itemStack) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (item instanceof ItemSwordBase && ((ItemSwordBase)item).onItemRightClickOnEntity(player, entity, itemStack) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.entityLiving != null && !event.entityLiving.func_70644_a(Potion.field_76439_r) && event.target != null && event.target.func_82150_aj()) {
            event.entityLiving.func_70604_c(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.source == null || event.entityLiving == null) {
            return;
        }
        EntityLivingBase damagedEntity = event.entityLiving;
        EntityDamageSource entityDamageSource = null;
        if (event.source instanceof EntityDamageSource) {
            entityDamageSource = (EntityDamageSource)event.source;
        }
        if (damagedEntity.field_70154_o != null && damagedEntity.field_70154_o instanceof EntityCreatureRideable) {
            if ("inWall".equals(event.source.field_76373_n)) {
                event.ammount = 0.0f;
                event.setCanceled(true);
                return;
            }
            EntityCreatureRideable creatureRideable = (EntityCreatureRideable)event.entityLiving.field_70154_o;
            if (!creatureRideable.isDamageTypeApplicable(event.source.field_76373_n)) {
                event.ammount = 0.0f;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        World world = event.entityLiving.field_70170_p;
        if (ItemInfo.seasonalItemDropChance > 0.0 && (Utilities.isHalloween() || Utilities.isYuletide() || Utilities.isNewYear())) {
            boolean noSeaonalDrop = false;
            boolean alwaysDrop = false;
            if (event.entityLiving instanceof EntityCreatureBase) {
                if (((EntityCreatureBase)event.entityLiving).isMinion()) {
                    noSeaonalDrop = true;
                }
                if (((EntityCreatureBase)event.entityLiving).getSubspecies() != null) {
                    alwaysDrop = true;
                }
            }
            Item seasonalItem = null;
            if (Utilities.isHalloween()) {
                seasonalItem = ObjectManager.getItem("halloweentreat");
            }
            if (Utilities.isYuletide()) {
                seasonalItem = ObjectManager.getItem("wintergift");
                if (Utilities.isYuletideDay() && world.field_73012_v.nextBoolean()) {
                    seasonalItem = ObjectManager.getItem("wintergiftlarge");
                }
            }
            if (seasonalItem != null && !noSeaonalDrop && (alwaysDrop || (double)event.entityLiving.func_70681_au().nextFloat() < ItemInfo.seasonalItemDropChance)) {
                ItemStack dropStack = new ItemStack(seasonalItem, 1);
                EntityItemCustom entityItem = new EntityItemCustom(world, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
                entityItem.field_145804_b = 10;
                world.func_72838_d((Entity)entityItem);
            }
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        World world = event.world;
        MovingObjectPosition pos = event.target;
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        Item bucket = ObjectManager.buckets.get(block);
        ItemStack result = null;
        if (bucket != null && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0) {
            world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            result = new ItemStack(bucket);
        }
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }
}

