/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;

public class AssetManager {
    public static Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    public static Map<String, IIcon> icons = new HashMap<String, IIcon>();
    public static Map<String, IIcon[]> iconGroups = new HashMap<String, IIcon[]>();
    public static Map<String, String> sounds = new HashMap<String, String>();
    public static Map<String, ModelBase> models = new HashMap<String, ModelBase>();
    public static Map<String, IModelCustom> objModels = new HashMap<String, IModelCustom>();

    public static void addTexture(String name, GroupInfo group, String path) {
        name = name.toLowerCase();
        textures.put(name, new ResourceLocation(group.filename, path));
    }

    public static void addIcon(String name, IIcon icon) {
        name = name.toLowerCase();
        icons.put(name, icon);
    }

    public static void addIcon(String name, GroupInfo group, String path, IIconRegister iconRegister) {
        name = name.toLowerCase();
        icons.put(name, iconRegister.func_94245_a(group.filename + ":" + path));
    }

    public static void addIconGroup(String name, GroupInfo group, String[] paths, IIconRegister iconRegister) {
        name = name.toLowerCase();
        IIcon[] iconGroup = new IIcon[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            iconGroup[i] = iconRegister.func_94245_a(group.filename + ":" + paths[i]);
        }
        iconGroups.put(name, iconGroup);
    }

    public static void addSound(String name, GroupInfo group, String path) {
        name = name.toLowerCase();
        sounds.put(name, group.filename + ":" + path);
    }

    public static void addModel(String name, ModelBase model) {
        name = name.toLowerCase();
        models.put(name, model);
    }

    public static void addObjModel(String name, GroupInfo group, String path) {
        name = name.toLowerCase();
        objModels.put(name, AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(group.filename, "models/" + path + ".obj")));
    }

    public static ResourceLocation getTexture(String name) {
        if (!textures.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textures.get(name);
    }

    public static IIcon getIcon(String name) {
        if (!icons.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return icons.get(name);
    }

    public static IIcon[] getIconGroup(String name) {
        if (!iconGroups.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return iconGroups.get(name);
    }

    public static String getSound(String name) {
        if (!sounds.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return sounds.get(name);
    }

    public static ModelBase getModel(String name) {
        if (!models.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return models.get(name);
    }

    public static IModelCustom getObjModel(String name) {
        if (!objModels.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return objModels.get(name);
    }

    public static IModelCustom getObjModel(String name, GroupInfo group, String path) {
        if (!objModels.containsKey(name = name.toLowerCase())) {
            AssetManager.addObjModel(name, group, path);
        }
        return objModels.get(name);
    }
}

