/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.shaded.ninja.leaping.configurate.loader;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.loader.CommentHandler;

public enum CommentHandlers implements CommentHandler
{
    HASH("#"),
    DOUBLE_SLASH("//"),
    SLASH_BLOCK{

        @Override
        public Optional<String> extractHeader(BufferedReader reader) throws IOException {
            StringBuilder build = new StringBuilder();
            String line = reader.readLine();
            if (line == null) {
                return Optional.absent();
            }
            if (!line.trim().startsWith("/*")) {
                return Optional.absent();
            }
            if (this.handleSingleLine(build, line = line.substring(line.indexOf("/*") + 2))) {
                line = reader.readLine();
                while (line != null && this.handleSingleLine(build, line)) {
                    line = reader.readLine();
                }
            }
            if ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
                return Optional.absent();
            }
            if (build.length() > 0) {
                return Optional.of(build.toString());
            }
            return Optional.absent();
        }

        private boolean handleSingleLine(StringBuilder builder, String line) {
            boolean moreLines = true;
            if (line.trim().endsWith("*/")) {
                if ((line = line.substring(0, line.lastIndexOf("*/"))).endsWith(" ")) {
                    line = line.substring(0, line.length() - 1);
                }
                moreLines = false;
                if (line.isEmpty()) {
                    return false;
                }
            }
            if (line.trim().startsWith("*")) {
                line = line.substring(line.indexOf("*") + 1);
            }
            if (line.startsWith(" ")) {
                line = line.substring(1);
            }
            if (builder.length() > 0) {
                builder.append(AbstractConfigurationLoader.LINE_SEPARATOR);
            }
            builder.append(line.replace("\r", "").replace("\n", "").replace("\r\n", ""));
            return moreLines;
        }

        @Override
        public Collection<String> toComment(Collection<String> lines) {
            if (lines.size() == 1) {
                return Collections2.transform(lines, new Function<String, String>(){

                    @Override
                    public String apply(String input) {
                        return "/* " + input + " */";
                    }
                });
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("/*");
            ret.addAll(Collections2.transform(lines, new Function<String, String>(){

                @Override
                public String apply(String input) {
                    return " * " + input;
                }
            }));
            ret.add(" */");
            return ret;
        }
    };

    private static final int READAHEAD_LEN = 4096;
    private final String commentPrefix;

    private CommentHandlers() {
        this.commentPrefix = null;
    }

    private CommentHandlers(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    @Override
    public Optional<String> extractHeader(BufferedReader reader) throws IOException {
        StringBuilder build = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            if (line.trim().startsWith(this.commentPrefix)) {
                if ((line = line.substring(line.indexOf(this.commentPrefix) + 1)).startsWith(" ")) {
                    line = line.substring(1);
                }
                if (build.length() > 0) {
                    build.append(AbstractConfigurationLoader.LINE_SEPARATOR);
                }
            } else {
                if (line.trim().isEmpty()) break;
                return Optional.absent();
            }
            build.append(line);
            line = reader.readLine();
        }
        return build.length() > 0 ? Optional.fromNullable(build.toString()) : Optional.absent();
    }

    @Override
    public Collection<String> toComment(Collection<String> lines) {
        return Collections2.transform(lines, new Function<String, String>(){

            @Override
            public String apply(String s) {
                if (s.startsWith(" ")) {
                    return CommentHandlers.this.commentPrefix + s;
                }
                return CommentHandlers.this.commentPrefix + " " + s;
            }
        });
    }

    public static String extractComment(BufferedReader reader, CommentHandler ... allowedHeaderTypes) throws IOException {
        reader.mark(4096);
        for (CommentHandler handler : allowedHeaderTypes) {
            Optional<String> comment = handler.extractHeader(reader);
            if (comment.isPresent()) {
                return comment.get();
            }
            reader.reset();
        }
        return null;
    }
}

