/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.shaded.ninja.leaping.configurate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.ConfigurationNode;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.SimpleConfigurationNode;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.objectmapping.DefaultObjectMapperFactory;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.objectmapping.serialize.TypeSerializerCollection;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.util.MapFactories;

public class ConfigurationOptions {
    private final Supplier<ConcurrentMap<Object, SimpleConfigurationNode>> mapSupplier;
    private final String header;
    private final TypeSerializerCollection serializers;
    private final ImmutableSet<Class<?>> acceptedTypes;
    private final ObjectMapperFactory objectMapperFactory;
    private final boolean shouldCopyDefaults;

    private ConfigurationOptions(Supplier<ConcurrentMap<Object, SimpleConfigurationNode>> mapSupplier, String header, TypeSerializerCollection serializers, Set<Class<?>> acceptedTypes, ObjectMapperFactory objectMapperFactory, boolean shouldCopyDefaults) {
        this.mapSupplier = mapSupplier;
        this.header = header;
        this.serializers = serializers;
        this.acceptedTypes = acceptedTypes == null ? null : ImmutableSet.copyOf(acceptedTypes);
        this.objectMapperFactory = objectMapperFactory;
        this.shouldCopyDefaults = shouldCopyDefaults;
    }

    public static ConfigurationOptions defaults() {
        return new ConfigurationOptions(MapFactories.<SimpleConfigurationNode>insertionOrdered(), null, TypeSerializers.getDefaultSerializers(), null, DefaultObjectMapperFactory.getInstance(), false);
    }

    public Supplier<ConcurrentMap<Object, ? extends ConfigurationNode>> getMapFactory() {
        return this.mapSupplier;
    }

    public ConfigurationOptions setMapFactory(Supplier<ConcurrentMap<Object, ConfigurationNode>> factory) {
        Preconditions.checkNotNull(factory, "factory");
        return new ConfigurationOptions(factory, this.header, this.serializers, this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public String getHeader() {
        return this.header;
    }

    public ConfigurationOptions setHeader(String header) {
        return new ConfigurationOptions(this.mapSupplier, header, this.serializers, this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public TypeSerializerCollection getSerializers() {
        return this.serializers;
    }

    public ConfigurationOptions setSerializers(TypeSerializerCollection serializers) {
        return new ConfigurationOptions(this.mapSupplier, this.header, serializers, this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    public ConfigurationOptions setObjectMapperFactory(ObjectMapperFactory factory) {
        Preconditions.checkNotNull(factory, "factory");
        return new ConfigurationOptions(this.mapSupplier, this.header, this.serializers, this.acceptedTypes, factory, this.shouldCopyDefaults);
    }

    public boolean acceptsType(Class<?> type) {
        if (this.acceptedTypes == null) {
            return true;
        }
        if (this.acceptedTypes.contains(type)) {
            return true;
        }
        for (Class clazz : this.acceptedTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public ConfigurationOptions setAcceptedTypes(Set<Class<?>> acceptedTypes) {
        return new ConfigurationOptions(this.mapSupplier, this.header, this.serializers, acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public boolean shouldCopyDefaults() {
        return this.shouldCopyDefaults;
    }

    public ConfigurationOptions setShouldCopyDefaults(boolean shouldCopyDefaults) {
        return new ConfigurationOptions(this.mapSupplier, this.header, this.serializers, this.acceptedTypes, this.objectMapperFactory, shouldCopyDefaults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationOptions)) {
            return false;
        }
        ConfigurationOptions that = (ConfigurationOptions)o;
        return Objects.equal(this.shouldCopyDefaults, that.shouldCopyDefaults) && Objects.equal(this.mapSupplier, that.mapSupplier) && Objects.equal(this.header, that.header) && Objects.equal(this.serializers, that.serializers) && Objects.equal(this.acceptedTypes, that.acceptedTypes) && Objects.equal(this.objectMapperFactory, that.objectMapperFactory);
    }

    public int hashCode() {
        return Objects.hashCode(this.mapSupplier, this.header, this.serializers, this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }
}

