/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.haxylib.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;

public class WorldHelper {
    public static boolean isHellWorld(World world) {
        return world.field_73011_w instanceof WorldProviderHell;
    }

    public static boolean isBlockAtPositionLiquid(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d();
    }

    public static boolean isNormalCubesAround(World world, BlockPos pos) {
        for (int x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
            for (int z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                if (WorldHelper.isNormalBlockAtPos(world, pos.func_177982_a(x, 0, z))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isNormalBlockAtPos(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_149721_r();
    }

    public static BlockPos getFirstSolidWithAirAbove(World world, BlockPos pos) {
        for (int y = pos.func_177956_o(); y < world.func_72800_K(); ++y) {
            if (!world.func_180495_p(pos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p())).func_177230_c().func_149721_r() || !world.func_175623_d(pos.func_177984_a())) continue;
            return pos;
        }
        return null;
    }

    public static List<IBlockState> getBlockstatesInRangeOfEntity(Block blockType, Entity entity, int rangeXZ, int rangeY) {
        ArrayList<IBlockState> blockStates = new ArrayList<IBlockState>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)entity.func_180425_c().func_177982_a(-rangeXZ, -rangeY, -rangeXZ), (BlockPos)entity.func_180425_c().func_177982_a(rangeXZ, rangeY, rangeXZ))) {
            IBlockState blockState = entity.field_70170_p.func_180495_p(pos);
            if (blockState.func_177230_c() != blockType) continue;
            blockStates.add(blockState);
        }
        return blockStates;
    }

    public static List<BlockPos> getBlockPositionsInRangeOfEntity(Block blockType, Entity entity, int rangeXZ, int rangeY) {
        ArrayList<BlockPos> blockPoses = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)entity.func_180425_c().func_177982_a(-rangeXZ, -rangeY, -rangeXZ), (BlockPos)entity.func_180425_c().func_177982_a(rangeXZ, rangeY, rangeXZ))) {
            IBlockState blockState = entity.field_70170_p.func_180495_p(pos);
            if (blockState.func_177230_c() != blockType) continue;
            blockPoses.add(pos);
        }
        return blockPoses;
    }
}

