/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.chococraft2.network.side.server;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import uk.co.haxyshideout.chococraft2.client.gui.ChocopediaGui;
import uk.co.haxyshideout.chococraft2.entities.EntityChocobo;

public class ChocopediaEditPacket
implements IMessage {
    UUID entityID;
    String chocoboName;
    EntityChocobo.MovementType movementType;
    String ownerName;

    public ChocopediaEditPacket() {
    }

    public ChocopediaEditPacket(ChocopediaGui chocopediaGui) {
        this.entityID = chocopediaGui.chocobo.func_110124_au();
        this.chocoboName = chocopediaGui.name;
        this.movementType = chocopediaGui.movementType;
        this.ownerName = chocopediaGui.owner;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.chocoboName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.movementType = EntityChocobo.MovementType.values()[buf.readByte()];
        this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityID.toString());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.chocoboName);
        buf.writeByte(this.movementType.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ownerName);
    }

    public static class Handler
    implements IMessageHandler<ChocopediaEditPacket, IMessage> {
        public IMessage onMessage(ChocopediaEditPacket message, MessageContext ctx) {
            EntityChocobo chocobo;
            EntityPlayerMP player;
            Entity entity = MinecraftServer.func_71276_C().func_175576_a(message.entityID);
            if (entity != null && entity instanceof EntityChocobo && (player = ctx.getServerHandler().field_147369_b) == (chocobo = (EntityChocobo)entity).func_70902_q()) {
                chocobo.func_96094_a(message.chocoboName);
                chocobo.setMovementType(message.movementType);
                GameProfile ownerProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(message.ownerName);
                if (ownerProfile != null) {
                    chocobo.func_152115_b(ownerProfile.getId().toString());
                } else {
                    ctx.getServerHandler().field_147369_b.func_146105_b((IChatComponent)new ChatComponentText("Unable to find owner by that name, not applying new owner!"));
                }
            }
            return null;
        }
    }
}

