/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.chococraft2.config;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.io.FileUtils;
import uk.co.haxyshideout.chococraft2.entities.ChocoboAbilityInfo;
import uk.co.haxyshideout.chococraft2.entities.EntityChocobo;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.ConfigurationOptions;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.hocon.HoconConfigurationLoader;

public class ChococraftConfig {
    private int ticksToAdult;
    private int changeForFeather;
    private int ticksUntilNextFeather;
    List<String> normalSpawnBiomeNames;
    private int overworldMinGroup;
    private int overworldMaxGroup;
    private int overworldWeight;
    private int netherMinGroup;
    private int netherMaxGroup;
    private int netherWeight;
    private int gysahlWorldGenWeight;
    private HashMap<String, HashMap<String, List<HashMap<String, String>>>> breedingInfoHashmap;
    CommentedConfigurationNode mainNode;

    public ChococraftConfig() {
        this.loadConfigFile();
        this.loadBreedingConfigFile();
    }

    private void loadBreedingConfigFile() {
        try {
            File breedingConfigFile = new File("./config/", "chococraft2breeding.hocon");
            if (!breedingConfigFile.exists()) {
                FileUtils.writeLines((File)breedingConfigFile, Resources.readLines(new URL("https://raw.githubusercontent.com/clienthax/chococraft2/master/src/main/resources/assets/chococraft2/cfg/breeding.hocon"), Charset.defaultCharset()));
            }
            HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(breedingConfigFile)).build();
            CommentedConfigurationNode mainNode = (CommentedConfigurationNode)configurationLoader.load();
            CommentedConfigurationNode breedingConfigNode = mainNode.getNode("BreedingConfig");
            this.breedingInfoHashmap = breedingConfigNode.getValue(new TypeToken<HashMap<String, HashMap<String, List<HashMap<String, String>>>>>(){});
        }
        catch (Exception e) {
            System.out.println("Error loading the chococraft 2 breeding config");
            e.printStackTrace();
        }
    }

    private void loadConfigFile() {
        try {
            File configFile = new File("./config/", "chococraft2.hocon");
            HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(configFile)).build();
            this.mainNode = (CommentedConfigurationNode)configurationLoader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
            CommentedConfigurationNode babyNode = this.mainNode.getNode("babys");
            this.ticksToAdult = babyNode.getNode("ticksToAdult").setComment("How many ticks it will take for the baby Chocobo to grow into the adult stage (Default 27000)").getInt(27000);
            CommentedConfigurationNode adultNode = this.mainNode.getNode("adults");
            CommentedConfigurationNode adultDropsNode = adultNode.getNode("drops");
            this.changeForFeather = adultDropsNode.getNode("changeForFeather").setComment("The change out of 100, for a feather to drop from a chocobo (Default 10)").getInt(10);
            this.ticksUntilNextFeather = adultDropsNode.getNode("ticksUntilNextFeather").setComment("How many ticks between a change for a feather to drop (Default 5000)").getInt(5000);
            CommentedConfigurationNode adultSpawnNode = adultNode.getNode("spawns");
            ArrayList<String> defaultSpawnBiomes = Lists.newArrayList("TaigaHills", "Jungle", "JungleHills", "Plains", "Taiga", "Forest", "ForestHills", "Swampland", "River", "Beach", "Desert", "Extreme Hills", "Extreme Hills Edge", "DesertHills", "FrozenRiver", "Ice Plains", "Cold Beach", "Cold Taiga", "Mega Taiga", "Cold Taiga Hills", "Stone Beach", "Extreme Hills+", "Birch Forest", "Savanna", "Mesa", "Roofed Forest", "MushroomIsland", "MushroomIslandShore", "Mesa Plateau");
            this.normalSpawnBiomeNames = adultSpawnNode.getNode("SpawnBiomeNames").setComment("List of all biomes in the overworld that normal Chocobos should spawn in").getList(new TypeToken<String>(){}, defaultSpawnBiomes);
            CommentedConfigurationNode overworldNode = adultSpawnNode.getNode("overworldSpawn");
            this.overworldMinGroup = overworldNode.getNode("overworldMinGroup").setComment("Minimum amount to spawn in group (Default 0)").getInt(0);
            this.overworldMaxGroup = overworldNode.getNode("overworldMaxGroup").setComment("Maximum amount to spawn in group (Default 4)").getInt(4);
            this.overworldWeight = overworldNode.getNode("overworldWeight").setComment("Spawn weight (Default 50)").getInt(50);
            CommentedConfigurationNode netherNode = adultSpawnNode.getNode("netherSpawn");
            this.netherMinGroup = netherNode.getNode("overworldMinGroup").setComment("Minimum amount to spawn in group (Default 1)").getInt(1);
            this.netherMaxGroup = netherNode.getNode("overworldMaxGroup").setComment("Maximum amount to spawn in group (Default 3)").getInt(3);
            this.netherWeight = netherNode.getNode("overworldWeight").setComment("Spawn weight (Default 2)").getInt(2);
            CommentedConfigurationNode worldGen = this.mainNode.getNode("worldGen");
            this.gysahlWorldGenWeight = worldGen.getNode("gysahlWorldGenWeight").setComment("Weight of the gysahl generator, lower = more, higher = less (Defaut 7)").getInt(7);
            this.loadAbilityInfo();
            configurationLoader.save(this.mainNode);
        }
        catch (Exception e) {
            System.out.println("Error loading Chococraft 2 config");
            e.printStackTrace();
        }
    }

    public List<BiomeGenBase> getSpawnBiomes() {
        ArrayList<BiomeGenBase> spawnBiomes = Lists.newArrayListWithCapacity(this.normalSpawnBiomeNames.size());
        for (BiomeGenBase biomeGenBase : BiomeGenBase.func_150565_n()) {
            if (biomeGenBase == null || !this.normalSpawnBiomeNames.contains(biomeGenBase.field_76791_y)) continue;
            spawnBiomes.add(biomeGenBase);
        }
        return spawnBiomes;
    }

    private void loadAbilityInfo() {
        CommentedConfigurationNode abilityNode = this.mainNode.getNode("abilitys");
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.YELLOW).setSpeeds(20.0f, 10.0f, 0.0f).setMaxHP(30).setStepHeight(1.0f, 0.5f), abilityNode.getNode("YELLOW"));
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.GREEN).setSpeeds(27.0f, 10.0f, 0.0f).setMaxHP(30).setStepHeight(2.0f, 0.5f), abilityNode.getNode("GREEN"));
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.BLUE).setSpeeds(27.0f, 55.0f, 0.0f).setMaxHP(30).setStepHeight(1.0f, 0.5f).setCanWalkOnWater(true), abilityNode.getNode("BLUE"));
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.WHITE).setSpeeds(35.0f, 45.0f, 0.0f).setMaxHP(40).setStepHeight(2.0f, 0.5f).setCanClimb(true).setCanWalkOnWater(true), abilityNode.getNode("WHITE"));
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.BLACK).setSpeeds(40.0f, 20.0f, 0.0f).setMaxHP(40).setStepHeight(2.0f, 0.5f).setCanWalkOnWater(true).setCanClimb(true), abilityNode.getNode("BLACK"));
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.GOLD).setSpeeds(50.0f, 20.0f, 55.0f).setMaxHP(50).setStepHeight(2.0f, 0.5f).setCanWalkOnWater(true).setCanClimb(true).setCanFly(true).setImmuneToFire(true), abilityNode.getNode("GOLD"));
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.PINK).setSpeeds(55.0f, 25.0f, 60.0f).setMaxHP(50).setStepHeight(2.0f, 0.5f).setCanClimb(true).setCanWalkOnWater(true).setCanFly(true), abilityNode.getNode("PINK"));
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.RED).setSpeeds(55.0f, 25.0f, 60.0f).setMaxHP(50).setStepHeight(2.0f, 0.5f).setCanClimb(true).setCanWalkOnWater(true).setCanFly(true), abilityNode.getNode("RED"));
        this.loadAbilityForColout(new ChocoboAbilityInfo(EntityChocobo.ChocoboColor.PURPLE).setSpeeds(40.0f, 10.0f, 55.0f).setMaxHP(50).setStepHeight(1.0f, 0.5f).setCanClimb(true).setCanFly(true).setImmuneToFire(true).addRiderAbility(new PotionEffect(12, 100, -1, true, false)), abilityNode.getNode("PURPLE"));
    }

    private void loadAbilityForColout(ChocoboAbilityInfo abilityInfo, CommentedConfigurationNode node) {
        float landSpeed = node.getNode("landSpeed").getFloat(abilityInfo.getLandSpeed());
        float waterSpeed = node.getNode("waterSpeed").getFloat(abilityInfo.getWaterSpeed());
        float airSpeed = node.getNode("airSpeed").getFloat(abilityInfo.getAirbornSpeed());
        int maxHP = node.getNode("maxHP").getInt(abilityInfo.getMaxHP());
        float mountedStepHeight = node.getNode("mountedStepHeight").getFloat(abilityInfo.getStepHeight(true));
        float normalStepHeight = node.getNode("normalStepHeight").getFloat(abilityInfo.getStepHeight(false));
        boolean canWalkOnWater = node.getNode("canWalkOnWater").getBoolean(abilityInfo.canWalkOnWater());
        boolean canClimb = node.getNode("canClimb").getBoolean(abilityInfo.canClimb());
        boolean canFly = node.getNode("canFly").getBoolean(abilityInfo.canFly());
        boolean immuneToFire = node.getNode("immuneToFire").getBoolean(abilityInfo.isImmuneToFire());
        abilityInfo.setSpeeds(landSpeed, waterSpeed, airSpeed).setMaxHP(maxHP).setStepHeight(mountedStepHeight, normalStepHeight).setCanWalkOnWater(canWalkOnWater).setCanClimb(canClimb).setCanFly(canFly).setImmuneToFire(immuneToFire).save();
    }

    public int getTicksToAdult() {
        return this.ticksToAdult;
    }

    public int getChangeForFeather() {
        return this.changeForFeather;
    }

    public int getTicksUntilNextFeather() {
        return this.ticksUntilNextFeather;
    }

    public int getOverworldMinGroup() {
        return this.overworldMinGroup;
    }

    public int getOverworldMaxGroup() {
        return this.overworldMaxGroup;
    }

    public int getOverworldWeight() {
        return this.overworldWeight;
    }

    public int getNetherMinGroup() {
        return this.netherMinGroup;
    }

    public int getNetherMaxGroup() {
        return this.netherMaxGroup;
    }

    public int getNetherWeight() {
        return this.netherWeight;
    }

    public int getGysahlWorldGenWeight() {
        return this.gysahlWorldGenWeight;
    }

    public HashMap<String, HashMap<String, List<HashMap<String, String>>>> getBreedingInfoHashmap() {
        return this.breedingInfoHashmap;
    }
}

