/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.util;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.base.GenericBlockRenderer;
import pcl.lc.module.core.fluid.ItemSpecialBucket;
import pcl.lc.module.decor.block.BlockLanteaDecorStair;

public class RegistrationHelper {
    private static boolean isLateRegistrationZone = false;
    private static Map<Integer, BlockItemMapping> registeredBlocks = new HashMap<Integer, BlockItemMapping>();
    private static Map<Integer, Class<? extends Item>> registeredItems = new HashMap<Integer, Class<? extends Item>>();
    private static Map<Integer, Class<? extends Container>> registeredContainers = new HashMap<Integer, Class<? extends Container>>();
    private static Map<Integer, Class<? extends GuiScreen>> registeredGUIs = new HashMap<Integer, Class<? extends GuiScreen>>();
    private static Map<String, VillagerMapping> registeredVillagers = new HashMap<String, VillagerMapping>();

    public static Map<Integer, BlockItemMapping> getBlockMappings() {
        if (!isLateRegistrationZone) {
            return null;
        }
        return registeredBlocks;
    }

    public static Map<Integer, Class<? extends Item>> getItemMappings() {
        if (!isLateRegistrationZone) {
            return null;
        }
        return registeredItems;
    }

    public static void flagLateRegistrationZone() {
        isLateRegistrationZone = true;
    }

    public static <T extends Block> T registerBlock(Class<? extends T> classOf, String unlocalizedName) {
        return RegistrationHelper.registerBlock(classOf, ItemBlock.class, unlocalizedName);
    }

    public static <T extends Block> T registerBlock(Class<? extends T> classOf, Class<? extends ItemBlock> itemClassOf, String unlocalizedName) {
        return RegistrationHelper.registerBlock(classOf, itemClassOf, unlocalizedName, true);
    }

    public static <T extends Block> T registerBlock(Class<? extends T> classOf, Class<? extends ItemBlock> itemClassOf, String unlocalizedName, boolean inCreativeTabs) {
        LanteaCraft.getLogger().log(Level.DEBUG, String.format("Attempting to register block %s", unlocalizedName));
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this block is later than was expected!");
        }
        try {
            Constructor<T> ctor = classOf.getConstructor(new Class[0]);
            Block theMysteryBlock = (Block)ctor.newInstance(new Object[0]);
            theMysteryBlock.func_149663_c(unlocalizedName);
            if (inCreativeTabs) {
                theMysteryBlock.func_149647_a(LanteaCraft.getCreativeTab());
            }
            GameRegistry.registerBlock((Block)theMysteryBlock, itemClassOf, (String)unlocalizedName);
            registeredBlocks.put(registeredBlocks.size(), new BlockItemMapping(classOf, itemClassOf));
            return (T)theMysteryBlock;
        }
        catch (Throwable e) {
            LanteaCraft.getLogger().log(Level.FATAL, "Failed to register block, an exception occured.", e);
            throw new RuntimeException(e);
        }
    }

    public static <T extends Item> T registerItem(Class<? extends T> classOf, String unlocalizedName) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Attempting to register item " + unlocalizedName);
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this item is later than was expected!");
        }
        try {
            Constructor<T> ctor = classOf.getConstructor(new Class[0]);
            Item theMysteryItem = (Item)ctor.newInstance(new Object[0]);
            theMysteryItem.func_77655_b(unlocalizedName).func_77637_a(LanteaCraft.getCreativeTab());
            GameRegistry.registerItem((Item)theMysteryItem, (String)unlocalizedName);
            registeredItems.put(registeredItems.size(), classOf);
            return (T)theMysteryItem;
        }
        catch (Exception e) {
            LanteaCraft.getLogger().log(Level.FATAL, "Failed to register item, an exception occured.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static ItemSpecialBucket registerSpecialBucket(Block hostOf, String unlocalizedName, String bucketTextureName) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Attempting to register SpecialBucket " + unlocalizedName);
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this SpecialBucket is later than was expected!");
        }
        ItemSpecialBucket bucket = new ItemSpecialBucket(hostOf);
        bucket.func_77655_b(unlocalizedName).func_77637_a(LanteaCraft.getCreativeTab());
        bucket.setTargetTexture(bucketTextureName);
        GameRegistry.registerItem((Item)bucket, (String)unlocalizedName);
        return bucket;
    }

    public static void addTradeHandler(int villagerID, VillagerRegistry.IVillageTradeHandler handler) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Registering trade handler for villager ID " + villagerID);
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this trade handler is later than was expected!");
        }
        VillagerRegistry.instance().registerVillageTradeHandler(villagerID, handler);
    }

    public static void registerOre(String name, ItemStack item) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Registering ore with name " + name);
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this ore is later than was expected!");
        }
        OreDictionary.registerOre((String)String.format("%s:%s", "LanteaCraft", name), (ItemStack)item);
    }

    public static void newRecipe(ItemStack product, Object ... params) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Registering new generic recipe");
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this recipe is later than was expected!");
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(product, params));
    }

    public static void newShapelessRecipe(ItemStack product, Object ... params) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Registering new generic shapeless recipe");
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this shapeless recipe is later than was expected!");
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(product, params));
    }

    public static void newSmeltingRecipe(ItemStack in, ItemStack out, float xp) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Registering new smelting recipe");
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this smelting is later than was expected!");
        }
        FurnaceRecipes.func_77602_a().func_151394_a(in, out, xp);
    }

    public static void addRandomChestItem(ItemStack stack, int minQty, int maxQty, int weight, String ... category) {
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this random chest behaviour is later than was expected!");
        }
        WeightedRandomChestContent item = new WeightedRandomChestContent(stack, minQty, maxQty, weight);
        for (String element : category) {
            LanteaCraft.getLogger().log(Level.DEBUG, "Adding new WeightedRandomChestContent for element " + element);
            ChestGenHooks.addItem((String)element, (WeightedRandomChestContent)item);
        }
    }

    public static void registerRenderer(GenericBlockRenderer renderer) {
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this block renderer is later than was expected!");
        }
        renderer.renderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderer);
    }

    public static void addTileEntityRenderer(Class<? extends TileEntity> teClass, TileEntitySpecialRenderer renderer) {
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this tile-entity renderer is later than was expected!");
        }
        ClientRegistry.bindTileEntitySpecialRenderer(teClass, (TileEntitySpecialRenderer)renderer);
    }

    @Deprecated
    public static BlockLanteaDecorStair registerStairDecal(String unlocalizedName, int targetMetadata) {
        LanteaCraft.getLogger().log(Level.DEBUG, String.format("Attempting to register stair decal %s", unlocalizedName));
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARN, "Warning, registration of this stair decal is later than was expected!");
        }
        try {
            BlockLanteaDecorStair stair = new BlockLanteaDecorStair(targetMetadata);
            stair.func_149663_c(unlocalizedName).func_149647_a(LanteaCraft.getCreativeTab());
            GameRegistry.registerBlock((Block)stair, (String)unlocalizedName);
            return stair;
        }
        catch (Exception e) {
            LanteaCraft.getLogger().log(Level.FATAL, "Failed to register stair decal, an exception occured.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static int registerVillager(int id, String name, ResourceLocation skin) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Adding villager ID " + id + " with name " + name);
        registeredVillagers.put(name, new VillagerMapping(id, skin));
        return id;
    }

    public static void registerContainer(int id, Class<? extends Container> cls) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Registering container with ID " + id + ", class " + cls.getCanonicalName());
        registeredContainers.put(id, cls);
    }

    public static void registerGui(int id, Class<? extends GuiScreen> cls) {
        LanteaCraft.getLogger().log(Level.DEBUG, "Registering GUI with ID " + id + ", class " + cls.getCanonicalName());
        registeredGUIs.put(id, cls);
    }

    public static Class<? extends Container> getRegisteredContainer(int id) {
        return registeredContainers.get(id);
    }

    public static Class<? extends GuiScreen> getRegisteredGui(int id) {
        return registeredGUIs.get(id);
    }

    public static int getRegisteredVillager(String name) {
        VillagerMapping villager = registeredVillagers.get(name);
        if (villager != null) {
            return villager.villagerID;
        }
        return 0;
    }

    public static class BlockItemMapping {
        public final Class<? extends Block> blockClass;
        public final Class<? extends ItemBlock> itemClass;

        public BlockItemMapping(Class<? extends Block> block, Class<? extends ItemBlock> item) {
            this.blockClass = block;
            this.itemClass = item;
        }
    }

    public static class VillagerMapping {
        public final int villagerID;
        public final ResourceLocation villagerSkin;

        public VillagerMapping(int id, ResourceLocation skin) {
            this.villagerID = id;
            this.villagerSkin = skin;
        }
    }
}

