/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.util;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;

public class CloakHandler {
    private static final Graphics RENDER_BUFFER = new BufferedImage(128, 128, 1).getGraphics();
    private final String cloakServer;
    private HashMap<String, String> playerCloaks = new HashMap();
    private ArrayList<AbstractClientPlayer> cloakedPlayers = new ArrayList();

    public CloakHandler(String cloakServer) {
        this.cloakServer = cloakServer;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPreRenderSpecials(RenderPlayerEvent.Specials.Pre event) {
        AbstractClientPlayer abstractClientPlayer;
        if (Loader.isModLoaded((String)"shadersmod")) {
            return;
        }
        if (event.entityPlayer instanceof AbstractClientPlayer && !this.cloakedPlayers.contains(abstractClientPlayer = (AbstractClientPlayer)event.entityPlayer)) {
            String cloakURL = this.playerCloaks.get(event.entityPlayer.getDisplayName().toLowerCase());
            if (cloakURL == null) {
                return;
            }
            this.cloakedPlayers.add(abstractClientPlayer);
            ReflectionHelper.setPrivateValue(ThreadDownloadImageData.class, (Object)abstractClientPlayer.func_110310_o(), (Object)false, (String[])new String[]{"textureUploaded", "field_110559_g"});
            new Thread(new CloakBindTask(abstractClientPlayer, cloakURL)).start();
            event.renderCape = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDatabase() {
        URLConnection con = null;
        BufferedReader br = null;
        try {
            con = new URL(this.cloakServer).openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String str = null;
            while ((str = br.readLine()) != null) {
                if (str.startsWith("--") || str.isEmpty() || !str.contains(":")) continue;
                String nick = str.substring(0, str.indexOf(":"));
                String link = str.substring(str.indexOf(":") + 1);
                new Thread(new CloakPreloadTask(link)).start();
                this.playerCloaks.put(nick.toLowerCase(), link);
            }
            br.close();
        }
        catch (MalformedURLException e) {
            LanteaCraft.getLogger().log(Level.WARN, "Failed to open cloaks server.", (Throwable)e);
        }
        catch (IOException e) {
            LanteaCraft.getLogger().log(Level.WARN, "Failed to read cloaks server.", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    private class CloakBindTask
    implements Runnable {
        private final AbstractClientPlayer abstractClientPlayer;
        private final String cloakURL;

        public CloakBindTask(AbstractClientPlayer player, String cloak) {
            this.abstractClientPlayer = player;
            this.cloakURL = cloak;
        }

        @Override
        public void run() {
            try {
                Image cape = new ImageIcon(new URL(this.cloakURL)).getImage();
                BufferedImage bo = new BufferedImage(cape.getWidth(null), cape.getHeight(null), 2);
                bo.getGraphics().drawImage(cape, 0, 0, null);
                ReflectionHelper.setPrivateValue(ThreadDownloadImageData.class, (Object)this.abstractClientPlayer.func_110310_o(), (Object)bo, (String[])new String[]{"bufferedImage", "field_110560_d"});
            }
            catch (MalformedURLException e) {
                LanteaCraft.getLogger().log(Level.WARN, "Failed to load cape.", (Throwable)e);
            }
        }
    }

    private class CloakPreloadTask
    implements Runnable {
        private final String cloakURL;

        public CloakPreloadTask(String link) {
            this.cloakURL = link;
        }

        @Override
        public void run() {
            try {
                RENDER_BUFFER.drawImage(new ImageIcon(new URL(this.cloakURL)).getImage(), 0, 0, null);
            }
            catch (MalformedURLException e) {
                LanteaCraft.getLogger().log(Level.WARN, "Failed to preload cape.", (Throwable)e);
            }
        }
    }
}

