/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.stargate.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumUnits;
import pcl.lc.base.PoweredTileEntity;
import pcl.lc.base.energy.IEnergyStore;
import pcl.lc.base.energy.IItemEnergyStore;
import pcl.lc.base.inventory.FilterRule;
import pcl.lc.base.inventory.FilteredInventory;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.base.network.packet.StandardModPacket;
import pcl.lc.cfg.ConfigHelper;
import pcl.lc.cfg.ModuleConfig;
import pcl.lc.module.ModulePower;
import pcl.lc.module.stargate.block.BlockStargateDHD;
import pcl.lc.module.stargate.tile.TileStargateBase;
import pcl.lc.util.Trans3;
import pcl.lc.util.Vector3;
import pcl.lc.util.WorldLocation;

public class TileStargateDHD
extends PoweredTileEntity
implements IEnergyStore {
    public static int linkRangeX = 10;
    public static int linkRangeY = 10;
    public static int linkRangeZ = 10;
    public boolean isLinkedToStargate;
    public int linkedX;
    public int linkedY;
    public int linkedZ;
    private double energy = 0.0;
    private FilteredInventory inventory = new FilteredInventory(1){

        public String func_145825_b() {
            return "stargate_energy";
        }

        public int[] func_94128_d(int var1) {
            return new int[]{0};
        }

        public boolean func_102007_a(int i, ItemStack itemstack, int j) {
            if (0 > i || i > this.items.length) {
                return false;
            }
            return this.items[i] == null || ItemStack.func_77989_b((ItemStack)this.items[i], (ItemStack)itemstack);
        }

        public boolean func_102008_b(int i, ItemStack itemstack, int j) {
            return 0 <= i && i <= this.items.length;
        }

        public boolean func_145818_k_() {
            return false;
        }

        @Override
        public void func_70296_d() {
        }

        @Override
        public void func_70295_k_() {
        }

        @Override
        public void func_70305_f() {
        }
    };

    public static void configure(ModuleConfig cfg) {
        linkRangeX = Integer.parseInt(ConfigHelper.getOrSetParam(cfg, "Option", "dhdLinkRange", "x", "Maximum range of DHD to Stargate link", linkRangeX).toString());
        linkRangeY = Integer.parseInt(ConfigHelper.getOrSetParam(cfg, "Option", "dhdLinkRange", "y", "Maximum range of DHD to Stargate link", linkRangeY).toString());
        linkRangeZ = Integer.parseInt(ConfigHelper.getOrSetParam(cfg, "Option", "dhdLinkRange", "z", "Maximum range of DHD to Stargate link", linkRangeZ).toString());
    }

    public TileStargateDHD() {
        this.inventory.setFilterRule(0, new FilterRule(new ItemStack[]{new ItemStack((Item)ModulePower.Items.energyCrystal, 1), new ItemStack((Item)ModulePower.Items.zpm, 1)}, null, true, false));
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public BlockStargateDHD getBlock() {
        return (BlockStargateDHD)this.func_145838_q();
    }

    public Trans3 localToGlobalTransformation() {
        return this.getBlock().localToGlobalTransformation(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p(), this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isLinkedToStargate = nbt.func_74767_n("isLinkedToStargate");
        this.linkedX = nbt.func_74762_e("linkedX");
        this.linkedY = nbt.func_74762_e("linkedY");
        this.linkedZ = nbt.func_74762_e("linkedZ");
        if (nbt.func_74764_b("energyStore")) {
            this.loadEnergyStore(nbt.func_74775_l("energyStore"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isLinkedToStargate", this.isLinkedToStargate);
        nbt.func_74768_a("linkedX", this.linkedX);
        nbt.func_74768_a("linkedY", this.linkedY);
        nbt.func_74768_a("linkedZ", this.linkedZ);
        NBTTagCompound energyCompound = new NBTTagCompound();
        this.saveEnergyStore(energyCompound);
        nbt.func_74782_a("energyStore", (NBTBase)energyCompound);
    }

    public TileStargateBase getLinkedStargateTE() {
        TileEntity gte;
        if (this.isLinkedToStargate && (gte = this.field_145850_b.func_147438_o(this.linkedX, this.linkedY, this.linkedZ)) instanceof TileStargateBase) {
            return (TileStargateBase)gte;
        }
        return null;
    }

    public void checkForLink() {
        if (!this.isLinkedToStargate) {
            Trans3 t = this.localToGlobalTransformation();
            for (int i = -linkRangeX; i <= linkRangeX; ++i) {
                for (int j = -linkRangeY; j <= linkRangeY; ++j) {
                    for (int k = 1; k <= linkRangeZ; ++k) {
                        Vector3 p = t.p(i, j, -k);
                        TileEntity te = this.field_145850_b.func_147438_o(p.floorX(), p.floorY(), p.floorZ());
                        if (!(te instanceof TileStargateBase) || !this.linkToStargate((TileStargateBase)te)) continue;
                        return;
                    }
                }
            }
        }
    }

    boolean linkToStargate(TileStargateBase gte) {
        if (!this.isLinkedToStargate && gte.getAsStructure().isValid()) {
            this.linkedX = gte.field_145851_c;
            this.linkedY = gte.field_145848_d;
            this.linkedZ = gte.field_145849_e;
            this.isLinkedToStargate = true;
            this.markBlockForUpdate();
            gte.markBlockForUpdate();
            return true;
        }
        return false;
    }

    public void clearLinkToStargate() {
        this.isLinkedToStargate = false;
        this.markBlockForUpdate();
    }

    @Override
    public void think() {
        ItemStack stackOf;
        if (!this.field_145850_b.field_72995_K && this.getEnergyStored() < this.getMaxEnergyStored() && (stackOf = this.inventory.func_70301_a(0)) != null && stackOf.func_77973_b() instanceof IItemEnergyStore) {
            IItemEnergyStore store = (IItemEnergyStore)stackOf.func_77973_b();
            double receive = store.extractEnergy(stackOf, Math.min(store.getMaximumIOPayload(), this.getMaxEnergyStored() - this.getEnergyStored()), false);
            this.energy += receive;
        }
    }

    public void getStateFromPacket(ModPacket packet) {
        StandardModPacket packetOf = (StandardModPacket)packet;
        this.energy = (Double)packetOf.getValue("energy");
        this.isLinkedToStargate = (Boolean)packetOf.getValue("isLinkedToStargate");
        this.linkedX = (Integer)packetOf.getValue("linkedX");
        this.linkedY = (Integer)packetOf.getValue("linkedY");
        this.linkedZ = (Integer)packetOf.getValue("linkedZ");
    }

    public ModPacket getPacketFromState() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.TileUpdate");
        packet.setValue("energy", this.energy);
        packet.setValue("isLinkedToStargate", this.isLinkedToStargate);
        packet.setValue("linkedX", this.linkedX);
        packet.setValue("linkedY", this.linkedY);
        packet.setValue("linkedZ", this.linkedZ);
        return packet;
    }

    public Packet func_145844_m() {
        LanteaCraft.getNetPipeline().sendToAllAround(this.getPacketFromState(), new WorldLocation(this), 128.0);
        return null;
    }

    @Override
    public double receiveEnergy(double quantity, boolean isSimulated) {
        double actualPayload = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), quantity);
        if (!isSimulated) {
            this.energy += actualPayload;
            this.func_70296_d();
            this.func_145844_m();
        }
        return actualPayload;
    }

    @Override
    public double extractEnergy(double quantity, boolean isSimulated) {
        double actualPayload = Math.min(this.getEnergyStored(), quantity);
        if (!isSimulated) {
            this.energy -= actualPayload;
            this.func_70296_d();
            this.func_145844_m();
        }
        return actualPayload;
    }

    @Override
    public double getEnergyStored() {
        return this.energy;
    }

    @Override
    public double getMaxEnergyStored() {
        return 50.0;
    }

    @Override
    public void saveEnergyStore(NBTTagCompound compound) {
        compound.func_74780_a("energy", this.energy);
    }

    @Override
    public void loadEnergyStore(NBTTagCompound compound) {
        if (compound.func_74764_b("energy")) {
            this.energy = compound.func_74769_h("energy");
        }
    }

    @Override
    public void thinkPacket(ModPacket packetOf, EntityPlayer player) {
        this.getStateFromPacket(packetOf);
        this.markBlockForUpdate();
    }

    @Override
    public boolean canReceiveEnergy() {
        return false;
    }

    @Override
    public boolean canExportEnergy() {
        return false;
    }

    @Override
    public double getMaximumReceiveEnergy() {
        return 0.0;
    }

    @Override
    public double getMaximumExportEnergy() {
        return 0.0;
    }

    @Override
    public double getAvailableExportEnergy() {
        return 0.0;
    }

    @Override
    public void receiveEnergy(double units) {
    }

    @Override
    public double exportEnergy(double units) {
        return 0.0;
    }

    @Override
    public boolean canEnergyFormatConnectToSide(EnumUnits typeof, ForgeDirection direction) {
        return false;
    }

    @Override
    public void detectAndSendChanges() {
    }
}

