/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.stargate.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pcl.lc.base.GenericContainerBlock;
import pcl.lc.base.multiblock.EnumOrientations;
import pcl.lc.core.ResourceAccess;
import pcl.lc.module.ModuleStargates;
import pcl.lc.module.stargate.StargateMultiblock;
import pcl.lc.module.stargate.block.BlockStargateBase;
import pcl.lc.module.stargate.tile.TileStargateBase;
import pcl.lc.module.stargate.tile.TileStargateRing;
import pcl.lc.util.Vector3;

public class BlockStargateRing
extends GenericContainerBlock {
    static final int numSubBlocks = 2;
    public static final int subBlockMask = 1;
    IIcon topAndBottomTexture;
    IIcon[] sideTextures = new IIcon[2];

    public BlockStargateRing() {
        super(Material.field_151578_c);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_149641_N() {
        return ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", this.func_149739_a());
    }

    public int func_149645_b() {
        if (ModuleStargates.Render.blockStargateRingRenderer != null) {
            return ModuleStargates.Render.blockStargateRingRenderer.renderID;
        }
        return -9001;
    }

    @Override
    public void func_149651_a(IIconRegister register) {
        this.topAndBottomTexture = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "stargate_block"));
        this.sideTextures[0] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "stargate_ring"));
        this.sideTextures[1] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "stargate_chevron"));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public int func_149692_a(int data) {
        return data;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileStargateRing te = (TileStargateRing)world.func_147438_o(x, y, z);
        if (te.getAsPart().isMerged()) {
            Vector3 base = te.getAsPart().findHostMultiblock(false).getLocation();
            Block block = world.func_147439_a(base.floorX(), base.floorY(), base.floorZ());
            if (block instanceof BlockStargateBase) {
                block.func_149727_a(world, base.floorX(), base.floorY(), base.floorZ(), player, side, cx, cy, cz);
            }
            return true;
        }
        return false;
    }

    public IIcon func_149691_a(int side, int data) {
        if (side <= 1) {
            return this.topAndBottomTexture;
        }
        return this.sideTextures[data & 1];
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileStargateRing te = (TileStargateRing)this.getTileEntity((IBlockAccess)world, x, y, z);
        te.hostBlockPlaced();
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        TileStargateRing te = (TileStargateRing)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            TileEntity host;
            te.flagDirty();
            if (te.getAsPart().findHostMultiblock(false) != null && (host = te.getAsPart().findHostMultiblock(false).getTileEntity()) instanceof TileStargateBase) {
                ((TileStargateBase)host).hostBlockDestroyed();
            }
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileStargateRing();
    }

    public void func_149719_a(IBlockAccess block, int x, int y, int z) {
        TileEntity tileof = block.func_147438_o(x, y, z);
        if (tileof instanceof TileStargateRing) {
            TileStargateRing ring = (TileStargateRing)tileof;
            if (ring.getAsPart() != null && ring.getAsPart().isMerged()) {
                StargateMultiblock master = (StargateMultiblock)ring.getAsPart().findHostMultiblock(false);
                EnumOrientations orientation = master.getOrientation();
                if (orientation != null) {
                    switch (orientation) {
                        case NORTH: 
                        case SOUTH: 
                        case NORTH_SOUTH: {
                            this.func_149676_a(0.35f, 0.0f, 0.0f, 0.65f, 1.0f, 1.0f);
                            break;
                        }
                        case EAST: 
                        case WEST: 
                        case EAST_WEST: {
                            this.func_149676_a(0.0f, 0.0f, 0.35f, 1.0f, 1.0f, 0.65f);
                            break;
                        }
                        default: {
                            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                            break;
                        }
                    }
                } else {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

