/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.stargate.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pcl.lc.LanteaCraft;
import pcl.lc.base.RotationOrientedBlock;
import pcl.lc.base.multiblock.EnumOrientations;
import pcl.lc.core.ResourceAccess;
import pcl.lc.module.ModuleStargates;
import pcl.lc.module.stargate.tile.TileStargateBase;

public class BlockStargateBase
extends RotationOrientedBlock {
    protected IIcon topAndBottomTexture;
    protected IIcon frontTexture;
    protected IIcon sideTexture;

    public BlockStargateBase() {
        super(Material.field_151576_e);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149675_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_149641_N() {
        return ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", this.func_149739_a());
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int blockID) {
        TileEntity host = world.func_147438_o(x, y, z);
        if (host instanceof TileStargateBase) {
            TileStargateBase base = (TileStargateBase)host;
            return base.isConnected() ? 15 : 0;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int blockID) {
        TileEntity host = world.func_147438_o(x, y, z);
        if (host instanceof TileStargateBase) {
            TileStargateBase base = (TileStargateBase)host;
            return base.isConnected() ? 15 : 0;
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public int func_149645_b() {
        if (ModuleStargates.Render.blockStargateBaseRenderer != null) {
            return ModuleStargates.Render.blockStargateBaseRenderer.renderID;
        }
        return -9001;
    }

    @Override
    public void func_149651_a(IIconRegister register) {
        this.topAndBottomTexture = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "stargate_block"));
        this.frontTexture = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "stargate_base_front"));
        this.sideTexture = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "stargate_ring"));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int data = Math.round((180.0f - player.field_70177_z) / 90.0f) & 3;
        world.func_72921_c(x, y, z, data, 3);
        TileStargateBase te = (TileStargateBase)this.getTileEntity((IBlockAccess)world, x, y, z);
        te.hostBlockPlaced();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileStargateBase te = (TileStargateBase)world.func_147438_o(x, y, z);
        if (te != null && te.getAsStructure().isValid()) {
            player.openGui((Object)LanteaCraft.getInstance(), LanteaCraft.EnumGUIs.StargateBase.ordinal(), world, x, y, z);
            return true;
        }
        return false;
    }

    public IIcon func_149691_a(int side, int data) {
        if (side <= 1) {
            return this.topAndBottomTexture;
        }
        if (side == 3) {
            return this.frontTexture;
        }
        return this.sideTexture;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        TileEntity te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null && te instanceof TileStargateBase) {
            ((TileStargateBase)te).hostBlockDestroyed();
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    public void explode(World world, double x, double y, double z, double s) {
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileStargateBase();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null && te instanceof TileStargateBase) {
            ((TileStargateBase)te).getAsStructure().invalidate();
        }
    }

    public boolean isMerged(IBlockAccess world, int x, int y, int z) {
        TileEntity te = this.getTileEntity(world, x, y, z);
        if (te != null && te instanceof TileStargateBase) {
            return ((TileStargateBase)te).getAsStructure().isValid();
        }
        return false;
    }

    public void func_149719_a(IBlockAccess block, int x, int y, int z) {
        TileEntity tileof = block.func_147438_o(x, y, z);
        if (tileof instanceof TileStargateBase) {
            TileStargateBase ring = (TileStargateBase)tileof;
            if (ring.getAsStructure().getOrientation() != null) {
                EnumOrientations orientation = ring.getAsStructure().getOrientation();
                switch (orientation) {
                    case NORTH: 
                    case SOUTH: 
                    case NORTH_SOUTH: {
                        this.func_149676_a(0.35f, 0.0f, 0.0f, 0.65f, 1.0f, 1.0f);
                        break;
                    }
                    case EAST: 
                    case WEST: 
                    case EAST_WEST: {
                        this.func_149676_a(0.0f, 0.0f, 0.35f, 1.0f, 1.0f, 0.65f);
                        break;
                    }
                    default: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

