/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.stargate;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import pcl.lc.base.multiblock.GenericMultiblock;
import pcl.lc.base.multiblock.MultiblockPart;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.base.network.packet.StandardModPacket;
import pcl.lc.module.stargate.TransporterRingMultiblock;
import pcl.lc.module.stargate.tile.TileTransporterRing;
import pcl.lc.util.ScanningHelper;
import pcl.lc.util.Vector3;
import pcl.lc.util.WorldLocation;

public class TransporterRingPart
extends MultiblockPart {
    private String typeof;
    private boolean modified = false;
    private WeakReference<GenericMultiblock> currentHost;

    public TransporterRingPart(TileEntity host) {
        super(host);
    }

    @Override
    public void tick() {
        if (!this.host.func_145831_w().field_72995_K && this.modified) {
            this.modified = !this.modified;
            this.host.func_145844_m();
        }
    }

    public void setType(String typeof) {
        this.typeof = typeof;
        this.modified = true;
    }

    @Override
    public GenericMultiblock findHostMultiblock(boolean allowScanning) {
        if (this.currentHost != null && this.currentHost.get() != null) {
            return (GenericMultiblock)this.currentHost.get();
        }
        if (!allowScanning) {
            return null;
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)-5.0, (double)0.0, (double)-5.0, (double)5.0, (double)1.0, (double)5.0);
        ArrayList<Vector3> entities = ScanningHelper.findAllTileEntitesOf(this.host.func_145831_w(), TileTransporterRing.class, this.host.field_145851_c, this.host.field_145848_d, this.host.field_145849_e, bounds);
        if (entities == null || entities.size() == 0) {
            return null;
        }
        Vector3 origin = new Vector3(this.host);
        for (int i = 0; i < entities.size(); ++i) {
            TileTransporterRing ring;
            Vector3 apath = entities.get(i).add(origin);
            TileEntity tile = this.host.func_145831_w().func_147438_o(apath.floorX(), apath.floorY(), apath.floorZ());
            if (!(tile instanceof TileTransporterRing) || !(ring = (TileTransporterRing)tile).isHost()) continue;
            return ring.getAsStructure();
        }
        return null;
    }

    @Override
    public boolean canMergeWith(GenericMultiblock structure) {
        if (this.isClient) {
            return true;
        }
        if (this.currentHost == null) {
            return true;
        }
        if (this.currentHost.get() == null) {
            return true;
        }
        return ((GenericMultiblock)this.currentHost.get()).equals(structure);
    }

    @Override
    public boolean mergeWith(GenericMultiblock structure) {
        this.currentHost = new WeakReference<GenericMultiblock>(structure);
        this.modified = true;
        return true;
    }

    @Override
    public boolean isMerged() {
        return this.currentHost != null && this.currentHost.get() != null;
    }

    @Override
    public void release() {
        this.currentHost = null;
        this.modified = true;
    }

    @Override
    public String getType() {
        return this.typeof;
    }

    @Override
    public Vector3 getVectorLoc() {
        return new Vector3(this.host);
    }

    public ModPacket pack() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this.host));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.MultiblockUpdate");
        if (this.currentHost != null && this.currentHost.get() != null) {
            packet.setValue("currentHost", ((GenericMultiblock)this.currentHost.get()).getLocation());
        }
        return packet;
    }

    public void unpack(ModPacket packetOf) {
        StandardModPacket packet = (StandardModPacket)packetOf;
        if (packet.hasFieldWithValue("currentHost")) {
            Vector3 location = (Vector3)packet.getValue("currentHost");
            TileEntity target = this.host.func_145831_w().func_147438_o(location.floorX(), location.floorY(), location.floorZ());
            if (target != null && target instanceof TileTransporterRing) {
                TileTransporterRing stargateBase = (TileTransporterRing)target;
                this.currentHost = new WeakReference<TransporterRingMultiblock>(stargateBase.getAsStructure());
            }
        } else {
            this.currentHost = null;
        }
        this.host.func_145831_w().func_147471_g(this.host.field_145851_c, this.host.field_145848_d, this.host.field_145849_e);
    }
}

