/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.stargate;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import pcl.lc.api.EnumRingPlatformState;
import pcl.lc.base.multiblock.GenericMultiblock;
import pcl.lc.base.multiblock.MultiblockPart;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.base.network.packet.StandardModPacket;
import pcl.lc.module.stargate.tile.TileTransporterRing;
import pcl.lc.util.ScanningHelper;
import pcl.lc.util.Vector3;
import pcl.lc.util.WorldLocation;

public class TransporterRingMultiblock
extends GenericMultiblock {
    private final double ringExtended = 2.5;
    private boolean modified = false;
    private EnumRingPlatformState state = EnumRingPlatformState.Idle;
    private int timeout;
    private Vector3 connectionTo;
    private ArrayList<Entity> boundingEntities;
    private double ringPosition;
    private double nextRingPosition;

    public TransporterRingMultiblock(TileEntity host) {
        super(host);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isClient && this.modified) {
            this.modified = !this.modified;
            this.host.func_145844_m();
        }
        if (this.isValid()) {
            if (this.isClient) {
                this.updateRendering();
            } else {
                this.updateState();
            }
        }
    }

    private void updateRendering() {
        if (0.0 > this.ringPosition) {
            this.ringPosition = 0.0;
        }
        this.ringPosition += this.nextRingPosition;
        if (this.ringPosition > 2.5) {
            this.ringPosition = 2.5;
        }
        if (this.timeout > 0) {
            this.nextRingPosition = this.state == EnumRingPlatformState.Connecting ? 0.125 : (this.state == EnumRingPlatformState.Disconnecting ? -0.125 : 0.0);
        }
    }

    private void updateState() {
        if (this.state != EnumRingPlatformState.Idle || this.timeout != 0) {
            if (this.timeout > 0) {
                --this.timeout;
            } else if (this.state == EnumRingPlatformState.Connecting) {
                this.updateState(EnumRingPlatformState.Transmitting, 2);
                this.buildTeleportingEntityList();
            } else if (this.state == EnumRingPlatformState.Transmitting) {
                this.updateState(EnumRingPlatformState.Connected, 8);
                this.teleportEntitiesInList();
            } else if (this.state == EnumRingPlatformState.Connected) {
                this.updateState(EnumRingPlatformState.Disconnecting, 20);
            } else if (this.state == EnumRingPlatformState.Disconnecting) {
                this.clearConnection();
                this.updateState(EnumRingPlatformState.Idle, 0);
            }
        }
    }

    public double getRingPosition(float partialticks) {
        double next = this.ringPosition + (double)partialticks * this.nextRingPosition;
        if (next > 2.5) {
            return 2.5;
        }
        return next;
    }

    public void performConnection(Vector3 slaveObject) {
        this.connectionTo = slaveObject;
        this.updateState(EnumRingPlatformState.Connecting, 20);
    }

    public void clearConnection() {
        this.connectionTo = null;
    }

    public boolean isBusy() {
        return this.state != EnumRingPlatformState.Idle;
    }

    private void updateState(EnumRingPlatformState state, int timeout) {
        this.state = state;
        this.timeout = timeout;
        ((TileTransporterRing)this.host).markBlockForUpdate();
    }

    public void connect() {
        ArrayList<Vector3> others = ScanningHelper.findAllTileEntitesOf(this.host.func_145831_w(), TileTransporterRing.class, this.xCoord, this.yCoord, this.zCoord, AxisAlignedBB.func_72330_a((double)-10.0, (double)(-this.yCoord), (double)-10.0, (double)10.0, (double)this.host.func_145831_w().func_72800_K(), (double)10.0));
        Vector3 vectorHere = new Vector3(this.host);
        for (Vector3 other : others) {
            TileTransporterRing that;
            TileEntity at = this.host.func_145831_w().func_147438_o(this.xCoord + (int)Math.floor(other.x), this.yCoord + (int)Math.floor(other.y), this.zCoord + (int)Math.floor(other.z));
            if (!(at instanceof TileTransporterRing) || at.equals(this) || !(that = (TileTransporterRing)at).isHost() || !that.getAsStructure().isValid() || that.getAsStructure().isBusy()) continue;
            this.performConnection(other.add(vectorHere));
            that.getAsStructure().performConnection(vectorHere);
            return;
        }
    }

    private TileTransporterRing getSlave() {
        return (TileTransporterRing)this.host.func_145831_w().func_147438_o((int)Math.floor(this.connectionTo.x), (int)Math.floor(this.connectionTo.y), (int)Math.floor(this.connectionTo.z));
    }

    public void buildTeleportingEntityList() {
        this.boundingEntities.clear();
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.xCoord - 2), (double)this.yCoord, (double)(this.zCoord - 2), (double)(this.xCoord + 2), (double)(this.yCoord + 3), (double)(this.zCoord + 2));
        List ents = this.host.func_145831_w().func_72872_a(Entity.class, bounds);
        for (Entity entity : ents) {
            if (entity.field_70128_L || entity.field_70154_o != null) continue;
            this.boundingEntities.add(entity);
        }
    }

    private void teleportEntitiesInList() {
        for (Entity entity : this.boundingEntities) {
            this.entityInPortal(entity);
        }
        this.boundingEntities.clear();
    }

    private void entityInPortal(Entity entity) {
        TileTransporterRing dte = this.getSlave();
        if (dte != null) {
            while (entity.field_70154_o != null) {
                entity = entity.field_70154_o;
            }
            Vector3 hostv = new Vector3(this.host);
            Vector3 entPos = new Vector3(entity);
            Vector3 dest = new Vector3(dte);
            Vector3 output = dest.add(entPos.sub(hostv));
            this.teleportEntityAndRider(entity, output);
        }
    }

    Entity teleportEntityAndRider(Entity entity, Vector3 destination) {
        Entity rider = entity.field_70153_n;
        if (rider != null) {
            rider.func_70078_a(null);
        }
        entity = this.teleportWithinDimension(entity, destination);
        if (rider != null) {
            rider = this.teleportEntityAndRider(rider, destination);
            rider.func_70078_a(entity);
            entity.field_98038_p = false;
        }
        return entity;
    }

    Entity teleportWithinDimension(Entity entity, Vector3 destination) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).func_70634_a(destination.x, destination.y, destination.z);
        } else {
            entity.func_70107_b(destination.x, destination.y, destination.z);
        }
        System.out.println("done!");
        entity.field_70170_p.func_72866_a(entity, false);
        return entity;
    }

    @Override
    public boolean isValidStructure(World worldAccess, int baseX, int baseY, int baseZ) {
        TileEntity tile;
        int z;
        int x;
        int dx = -1;
        int dz = -1;
        block0: for (x = 0; x < 10; ++x) {
            for (z = 0; z < 10; ++z) {
                tile = worldAccess.func_147438_o(x - 4, baseY, z - 4);
                if (tile == null || !(tile instanceof TileTransporterRing)) continue;
                dx = x;
                dz = z;
                continue block0;
            }
        }
        if (dx == -1 || dz == -1) {
            return false;
        }
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                tile = worldAccess.func_147438_o(dx + x, baseY, dz + z);
                if (tile != null && tile instanceof TileTransporterRing) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean collectStructure(World worldAccess, int baseX, int baseY, int baseZ) {
        return false;
    }

    @Override
    public void freeStructure() {
    }

    @Override
    public MultiblockPart getPart(Object reference) {
        return null;
    }

    @Override
    public MultiblockPart[] getAllParts() {
        return null;
    }

    @Override
    public void validated(boolean oldState, boolean newState) {
    }

    @Override
    public void disband() {
    }

    @Override
    public ModPacket pack() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this.host));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.TileUpdate");
        packet.setValue("timeout", this.timeout);
        packet.setValue("state", (Object)this.state);
        return packet;
    }

    @Override
    public void unpack(ModPacket packet) {
        StandardModPacket thePacket = (StandardModPacket)packet;
        this.timeout = (Integer)thePacket.getValue("timeout");
        this.state = (EnumRingPlatformState)((Object)thePacket.getValue("state"));
    }

    @Override
    public ModPacket pollForUpdate() {
        return null;
    }
}

