/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.stargate;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumStargateState;
import pcl.lc.base.multiblock.EnumOrientations;
import pcl.lc.base.multiblock.GenericMultiblock;
import pcl.lc.base.multiblock.MultiblockPart;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.base.network.packet.StandardModPacket;
import pcl.lc.core.WorldLog;
import pcl.lc.module.ModuleStargates;
import pcl.lc.module.stargate.StargatePart;
import pcl.lc.module.stargate.tile.TileStargateRing;
import pcl.lc.util.ImmutablePair;
import pcl.lc.util.WorldLocation;

public class StargateMultiblock
extends GenericMultiblock {
    private int rotation;
    private int watcher = 0;
    private boolean watcherLast = false;
    private boolean modified = false;
    private int[][] stargateModel = new int[][]{{1, 2, 1, 3, 1, 2, 1}, {2, 0, 0, 0, 0, 0, 2}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {2, 0, 0, 0, 0, 0, 2}, {1, 0, 0, 0, 0, 0, 1}, {1, 2, 1, 2, 1, 2, 1}};

    public StargateMultiblock(TileEntity host) {
        super(host);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isClient && this.modified) {
            this.modified = !this.modified;
            this.host.func_145844_m();
            WorldLog log = LanteaCraft.getProxy().getWorldLog();
            log.log(Level.INFO, String.format("Stargate state changed to %s at (%s %s %s, dim: %s).", this.isValid, this.xCoord, this.yCoord, this.zCoord, this.host.func_145831_w().field_73011_w.field_76574_g));
        }
        if (!this.isClient) {
            if (0 > this.watcher) {
                this.watcher += 20;
                boolean result = this.isValidStructure(this.host.func_145831_w(), this.host.field_145851_c, this.host.field_145848_d, this.host.field_145849_e);
                if (result != this.watcherLast) {
                    this.watcherLast = result;
                    this.invalidate();
                }
            } else {
                --this.watcher;
            }
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getPartCount() {
        return this.structureParts.size();
    }

    private boolean isGateTileEntity(TileEntity entity) {
        return entity instanceof TileStargateRing;
    }

    private EnumOrientations getOrientation(World worldAccess, int baseX, int baseY, int baseZ) {
        if (this.isGateTileEntity(worldAccess.func_147438_o(baseX, baseY, baseZ + 1)) && this.isGateTileEntity(worldAccess.func_147438_o(baseX, baseY, baseZ - 1))) {
            return EnumOrientations.NORTH_SOUTH;
        }
        if (this.isGateTileEntity(worldAccess.func_147438_o(baseX + 1, baseY, baseZ)) && this.isGateTileEntity(worldAccess.func_147438_o(baseX - 1, baseY, baseZ))) {
            return EnumOrientations.EAST_WEST;
        }
        return null;
    }

    @Override
    public boolean isValidStructure(World worldAccess, int baseX, int baseY, int baseZ) {
        EnumOrientations currentOrientation = this.getOrientation(worldAccess, baseX, baseY, baseZ);
        if (currentOrientation == EnumOrientations.EAST_WEST) {
            LanteaCraft.getLogger().log(Level.DEBUG, "Testing EASTWEST");
            for (int y = 0; y < 7; ++y) {
                for (int x = 0; x < 7; ++x) {
                    Block block = worldAccess.func_147439_a(baseX + (x - 3), baseY + y, baseZ);
                    TileEntity entity = worldAccess.func_147438_o(baseX + (x - 3), baseY + y, baseZ);
                    if (this.testIsValidForExpected(worldAccess, baseX + (x - 3), baseY + y, baseZ, entity, block, this.stargateModel[y][x])) continue;
                    return false;
                }
            }
            return true;
        }
        if (currentOrientation == EnumOrientations.NORTH_SOUTH) {
            LanteaCraft.getLogger().log(Level.DEBUG, "Testing NORTHSOUTH");
            for (int y = 0; y < 7; ++y) {
                for (int z = 0; z < 7; ++z) {
                    Block block = worldAccess.func_147439_a(baseX, baseY + y, baseZ + (z - 3));
                    TileEntity entity = worldAccess.func_147438_o(baseX, baseY + y, baseZ + (z - 3));
                    if (this.testIsValidForExpected(worldAccess, baseX, baseY + y, baseZ + (z - 3), entity, block, this.stargateModel[y][z])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean testIsValidForExpected(World world, int x, int y, int z, TileEntity entity, Block block, int expectedType) {
        if (expectedType == 0) {
            if (block == null) {
                return true;
            }
            return block.isAir((IBlockAccess)world, x, y, z);
        }
        if (expectedType == 1 || expectedType == 2) {
            if (!(entity instanceof TileStargateRing)) {
                return false;
            }
            TileStargateRing entityAsRing = (TileStargateRing)entity;
            StargatePart teAsPart = null;
            teAsPart = entityAsRing.getAsPart();
            if (expectedType == 1) {
                if (teAsPart.getType() == null || !teAsPart.getType().equals("partStargateBlock")) {
                    return false;
                }
                if (!teAsPart.canMergeWith(this)) {
                    return false;
                }
            }
            if (expectedType == 2) {
                if (teAsPart.getType() == null || !teAsPart.getType().equals("partStargateChevron")) {
                    return false;
                }
                if (!teAsPart.canMergeWith(this)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean collectStructure(World worldAccess, int baseX, int baseY, int baseZ) {
        EnumOrientations currentOrientation = this.getOrientation(worldAccess, baseX, baseY, baseZ);
        if (currentOrientation == EnumOrientations.EAST_WEST) {
            LanteaCraft.getLogger().log(Level.DEBUG, "Globbing EASTWEST");
            for (int x = 0; x < 7; ++x) {
                for (int y = 0; y < 7; ++y) {
                    TileEntity entity = worldAccess.func_147438_o(baseX + (x - 3), baseY + y, baseZ);
                    if (this.stargateModel[y][x] == 0 || this.stargateModel[y][x] == 3) continue;
                    TileStargateRing entityAsRing = (TileStargateRing)entity;
                    StargatePart teAsPart = entityAsRing.getAsPart();
                    if (!teAsPart.canMergeWith(this)) {
                        return false;
                    }
                    teAsPart.mergeWith(this);
                    this.structureParts.put(new ImmutablePair<Integer, Integer>(x, y), teAsPart);
                }
            }
            LanteaCraft.getLogger().log(Level.DEBUG, "Merged in orientation EAST-WEST OK");
            this.structureOrientation = EnumOrientations.EAST_WEST;
            this.modified = true;
            return true;
        }
        if (currentOrientation == EnumOrientations.NORTH_SOUTH) {
            LanteaCraft.getLogger().log(Level.DEBUG, "Globbing NORTHSOUTH");
            for (int z = 0; z < 7; ++z) {
                for (int y = 0; y < 7; ++y) {
                    TileEntity entity = worldAccess.func_147438_o(baseX, baseY + y, baseZ + (z - 3));
                    if (this.stargateModel[y][z] == 0 || this.stargateModel[y][z] == 3) continue;
                    TileStargateRing entityAsRing = (TileStargateRing)entity;
                    StargatePart teAsPart = entityAsRing.getAsPart();
                    if (!teAsPart.canMergeWith(this)) {
                        return false;
                    }
                    teAsPart.mergeWith(this);
                    this.structureParts.put(new ImmutablePair<Integer, Integer>(z, y), teAsPart);
                }
            }
            LanteaCraft.getLogger().log(Level.DEBUG, "Merged in orientation NORTH-SOUTH OK");
            this.structureOrientation = EnumOrientations.NORTH_SOUTH;
            this.modified = true;
            return true;
        }
        LanteaCraft.getLogger().log(Level.DEBUG, "Weird orientation result!");
        return false;
    }

    @Override
    public void freeStructure() {
        LanteaCraft.getLogger().log(Level.INFO, (this.isClient ? "[client]" : "[server]") + " Releasing multiblock structure.");
        for (Map.Entry part : this.structureParts.entrySet()) {
            ((MultiblockPart)part.getValue()).release();
        }
        EnumStargateState stateOf = (EnumStargateState)((Object)this.getMetadata("state"));
        if (!(this.isClient || stateOf != EnumStargateState.Connected && stateOf != EnumStargateState.Disconnecting)) {
            LanteaCraft.getLogger().log(Level.INFO, "Creating explosion: gate destroyed while connected!");
            Block block = this.host.func_145831_w().func_147439_a(this.host.field_145851_c, this.host.field_145848_d, this.host.field_145849_e);
            if (block.equals((Object)ModuleStargates.Blocks.stargateBaseBlock)) {
                ModuleStargates.Blocks.stargateBaseBlock.explode(this.host.func_145831_w(), this.host.field_145851_c, this.host.field_145848_d, this.host.field_145849_e, 500.0);
            }
        }
        this.structureParts.clear();
        this.modified = true;
    }

    @Override
    public MultiblockPart getPart(Object reference) {
        return (MultiblockPart)this.structureParts.get(reference);
    }

    @Override
    public MultiblockPart[] getAllParts() {
        return this.structureParts.values().toArray(new MultiblockPart[0]);
    }

    @Override
    public void validated(boolean oldState, boolean newState) {
        if (!this.isClient) {
            this.host.func_145844_m();
        }
    }

    @Override
    public void disband() {
        LanteaCraft.getLogger().log(Level.DEBUG, (this.isClient ? "[client]" : "[server]") + " Disbanding structure.");
        boolean wasValid = this.isValid();
        this.freeStructure();
        this.isValid = false;
        this.validated(wasValid, this.isValid());
    }

    @Override
    public ModPacket pack() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this.host));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.MultiblockUpdate");
        packet.setValue("metadata", this.metadata);
        packet.setValue("isValid", this.isValid());
        packet.setValue("orientation", (Object)this.getOrientation());
        HashMap gparts = new HashMap();
        for (Map.Entry part : this.structureParts.entrySet()) {
            gparts.put(part.getKey(), ((MultiblockPart)part.getValue()).getVectorLoc());
        }
        packet.setValue("parts", gparts);
        return packet;
    }

    @Override
    public void unpack(ModPacket packet) {
        StandardModPacket packetStandard = (StandardModPacket)packet;
        this.metadata = (HashMap)packetStandard.getValue("metadata");
        this.isValid = (Boolean)packetStandard.getValue("isValid");
        this.setOrientation((EnumOrientations)((Object)packetStandard.getValue("orientation")));
    }

    @Override
    public ModPacket pollForUpdate() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this.host));
        packet.setIsForServer(true);
        packet.setType("LanteaPacket.UpdateRequest");
        return packet;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StargateMultiblock)) {
            return false;
        }
        StargateMultiblock that = (StargateMultiblock)o;
        if (that.host == null || this.host == null) {
            return false;
        }
        return that.host.field_145851_c == this.host.field_145851_c && that.host.field_145848_d == this.host.field_145848_d && that.host.field_145849_e == this.host.field_145849_e;
    }
}

