/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.stargate;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumStargateState;
import pcl.lc.api.internal.ITickAgent;
import pcl.lc.base.data.WatchedValue;
import pcl.lc.core.RemoteChunkLoading;
import pcl.lc.module.stargate.GateAddressHelper;
import pcl.lc.module.stargate.tile.TileStargateBase;
import pcl.lc.util.Vector3;
import pcl.lc.util.WorldLocation;

public class StargateConnectionManager
implements ITickAgent {
    public static final int diallingTime = 40;
    public static final int interDiallingTime = 10;
    public static final int transientDuration = 20;
    public static final int disconnectTime = 30;
    private ArrayList<ConnectionRequest> requests = new ArrayList();
    private ArrayList<ConnectionRequest> expiredRequests = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionRequest create(String hostAddress, String clientAddress, WorldLocation hostLocation, WorldLocation clientLocation, TileStargateBase hostTile, String name) {
        ConnectionRequest request = new ConnectionRequest(hostAddress, clientAddress, hostLocation, clientLocation, name);
        request.setup(hostTile);
        ArrayList<ConnectionRequest> arrayList = this.requests;
        synchronized (arrayList) {
            this.requests.add(request);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advance() {
        ArrayList<ConnectionRequest> arrayList = this.requests;
        synchronized (arrayList) {
            for (ConnectionRequest request : this.requests) {
                request.advance();
                if (request.running.get().booleanValue()) continue;
                this.expiredRequests.add(request);
            }
        }
        if (this.expiredRequests.size() > 0) {
            for (ConnectionRequest expired : this.expiredRequests) {
                this.remove(expired);
            }
            this.expiredRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ConnectionRequest request) {
        if (BuildInfo.CHUNK_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("ConnectionRequest remove request: %s", request.name));
        }
        request.shutdown();
        ArrayList<ConnectionRequest> arrayList = this.requests;
        synchronized (arrayList) {
            this.requests.remove(request);
        }
    }

    public static class ConnectionRequest {
        public String hostAddress;
        public String clientAddress;
        public WorldLocation hostLocation;
        public WorldLocation clientLocation;
        public RemoteChunkLoading.ChunkLoadRequest hostChunkLoader;
        public RemoteChunkLoading.ChunkLoadRequest clientChunkLoader;
        public WeakReference<TileStargateBase> hostTile;
        public WeakReference<TileStargateBase> clientTile;
        public Vector3 hostTilePos;
        public Vector3 clientTilePos;
        public World hostWorld;
        public World clientWorld;
        public String name;
        public String hostName;
        public String clientName;
        public WatchedValue<Boolean> running = new WatchedValue<Boolean>(true);
        public int ticks = 0;
        public WatchedValue<EnumStargateState> state = new WatchedValue<EnumStargateState>(EnumStargateState.Idle);
        public WatchedValue<Character> symbol = new WatchedValue<Character>(Character.valueOf(' '));
        public WatchedValue<Integer> chevrons = new WatchedValue<Integer>(0);
        public int ticksRemaining = 0;

        private ConnectionRequest(String hostAddress, String clientAddress, WorldLocation hostLocation, WorldLocation clientLocation, String name) {
            this.hostAddress = hostAddress;
            this.hostLocation = hostLocation;
            this.clientAddress = clientAddress;
            this.clientLocation = clientLocation;
            this.name = name;
            this.hostName = String.format("%s-Host-%s", name, hostLocation.toString());
            this.clientName = String.format("%s-Client-%s", name, clientLocation.toString());
        }

        public void setup(TileStargateBase host) {
            RemoteChunkLoading loader = LanteaCraft.getProxy().getRemoteChunkManager();
            this.hostTile = new WeakReference<TileStargateBase>(host);
            this.hostTilePos = new Vector3(host);
            host.setConnection(this);
            this.hostWorld = GateAddressHelper.getWorld(this.hostLocation.dimension);
            if (this.hostWorld != null) {
                this.hostChunkLoader = loader.create(this.hostName, this.hostWorld, TileStargateBase.ticksToStayOpen, this.createRadiusOf(this.hostLocation, 1));
            }
            this.clientWorld = GateAddressHelper.getWorld(this.clientLocation.dimension);
            if (this.clientWorld != null) {
                this.clientChunkLoader = loader.create(this.clientName, this.clientWorld, TileStargateBase.ticksToStayOpen, this.createRadiusOf(this.clientLocation, 1));
            }
            this.runState(EnumStargateState.Dialling, 40);
        }

        public void advance() {
            Chunk chunk;
            if (!this.running.get().booleanValue()) {
                return;
            }
            ++this.ticks;
            if ((this.clientTile == null || this.clientTile.get() == null) && this.clientWorld != null && (chunk = this.clientWorld.func_72938_d(this.clientLocation.x, this.clientLocation.z)) != null) {
                if (this.clientTilePos == null) {
                    for (Object o : chunk.field_150816_i.values()) {
                        if (!(o instanceof TileStargateBase)) continue;
                        TileStargateBase tile = (TileStargateBase)o;
                        this.clientTile = new WeakReference<TileStargateBase>(tile);
                        this.clientTilePos = new Vector3(tile);
                        tile.setConnection(this);
                    }
                } else {
                    TileEntity o = chunk.field_76637_e.func_147438_o(this.clientTilePos.floorX(), this.clientTilePos.floorY(), this.clientTilePos.floorZ());
                    if (o != null && o instanceof TileStargateBase) {
                        TileStargateBase tile = (TileStargateBase)o;
                        this.clientTile = new WeakReference<TileStargateBase>(tile);
                        this.clientTilePos = new Vector3(tile);
                        tile.setConnection(this);
                    }
                }
            }
            if (this.ticksRemaining > 0) {
                if (this.state.get() == EnumStargateState.Transient) {
                    ((TileStargateBase)this.hostTile.get()).performTransientDamage();
                    ((TileStargateBase)this.clientTile.get()).performTransientDamage();
                }
                --this.ticksRemaining;
            } else {
                switch (this.state.get()) {
                    case InterDialling: {
                        this.symbol.set(Character.valueOf(this.nextChevron()));
                        this.runState(EnumStargateState.Dialling, 40);
                        break;
                    }
                    case Dialling: {
                        this.chevrons.set(this.chevrons.get() + 1);
                        if (this.clientAddress.length() > this.chevrons.get()) {
                            this.runState(EnumStargateState.InterDialling, 10);
                            break;
                        }
                        if (this.clientTile != null) {
                            this.runState(EnumStargateState.Transient, 20);
                            break;
                        }
                        if (BuildInfo.DEBUG) {
                            LanteaCraft.getLogger().log(Level.WARN, "Cannot find host tile, aborting!");
                        }
                        this.requestDisconnect();
                        break;
                    }
                    case Transient: {
                        this.runState(EnumStargateState.Connected, TileStargateBase.ticksToStayOpen);
                        break;
                    }
                    case Connected: {
                        this.requestDisconnect();
                        break;
                    }
                    case Disconnecting: {
                        this.state.set(EnumStargateState.Idle);
                        this.shutdown();
                    }
                }
            }
            if (this.state.get() == EnumStargateState.Connected && !((TileStargateBase)this.hostTile.get()).useEnergy(1)) {
                ((TileStargateBase)this.hostTile.get()).disconnect();
            }
        }

        public char nextChevron() {
            return this.clientAddress.charAt(this.chevrons.get());
        }

        public void runState(EnumStargateState state, int timeout) {
            if (BuildInfo.DEBUG) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Stargate transitioning to state %s for %s ticks.", new Object[]{state, timeout}));
            }
            this.state.set(state);
            this.ticksRemaining = timeout;
        }

        public void requestDisconnect() {
            this.runState(EnumStargateState.Disconnecting, 30);
        }

        public void shutdown() {
            this.running.set(false);
            this.state.set(EnumStargateState.Idle);
            this.clientTile = null;
            this.hostTile = null;
            this.clientWorld = null;
            this.hostWorld = null;
            if (this.clientChunkLoader != null) {
                this.clientChunkLoader.expireNow();
            }
            if (this.hostChunkLoader != null) {
                this.hostChunkLoader.expireNow();
            }
        }

        private NBTTagCompound createRadiusOf(WorldLocation location, int radius) {
            NBTTagCompound result = new NBTTagCompound();
            result.func_74768_a("minX", location.x - radius);
            result.func_74768_a("minZ", location.z - radius);
            result.func_74768_a("maxX", location.x + radius);
            result.func_74768_a("maxZ", location.z + radius);
            return result;
        }

        public boolean isHost(TileStargateBase that) {
            if (this.hostTile == null || this.hostTile.get() == null) {
                return false;
            }
            return ((TileStargateBase)this.hostTile.get()).equals(that);
        }
    }
}

