/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.power.tile;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import pcl.lc.api.EnumUnits;
import pcl.lc.api.INaquadahGeneratorAccess;
import pcl.lc.base.PoweredTileEntity;
import pcl.lc.base.SpecialFluidTank;
import pcl.lc.base.inventory.FilterRule;
import pcl.lc.base.inventory.FilteredInventory;
import pcl.lc.base.network.IPacketHandler;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.module.ModuleCore;
import pcl.lc.module.ModulePower;
import pcl.lc.module.power.item.ItemEnergyCrystal;
import pcl.lc.util.ReflectionHelper;

public class TileNaquadahGenerator
extends PoweredTileEntity
implements IPacketHandler,
IFluidHandler,
INaquadahGeneratorAccess {
    public final double maxEnergy = 10.0;
    public double displayEnergy = 0.0;
    public double displayTankVolume = 0.0;
    public SpecialFluidTank tank = new SpecialFluidTank(ModuleCore.Fluids.fluidLiquidNaquadah, 8000, 0, true, true);
    private FilteredInventory inventory = new FilteredInventory(5){

        public String func_145825_b() {
            return "naquadah_generator";
        }

        public int[] func_94128_d(int var1) {
            return new int[]{0, 1, 2, 3};
        }

        public boolean func_102007_a(int i, ItemStack itemstack, int j) {
            if (0 > i || i > this.items.length) {
                return false;
            }
            return this.items[i] == null || ItemStack.func_77989_b((ItemStack)this.items[i], (ItemStack)itemstack);
        }

        public boolean func_102008_b(int i, ItemStack itemstack, int j) {
            return 0 <= i && i <= this.items.length;
        }

        public boolean func_145818_k_() {
            return false;
        }
    };

    public TileNaquadahGenerator() {
        this.metadata.set("energy", 0.0);
        this.metadata.set("simulating", false);
        FilterRule naquadah = new FilterRule(new ItemStack[]{new ItemStack((Item)ModuleCore.Items.lanteaOreItem, 1)}, null, true, true);
        FilterRule energyCrystal = new FilterRule(new ItemStack[]{new ItemStack((Item)ModulePower.Items.energyCrystal, 1)}, null, true, false);
        for (int i = 0; i < 4; ++i) {
            this.inventory.setFilterRule(i, naquadah);
        }
        this.inventory.setFilterRule(4, energyCrystal);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound tankCompound = nbt.func_74775_l("tank");
        if (tankCompound != null) {
            this.tank.readFromNBT(tankCompound);
        }
        if (nbt.func_74764_b("energy")) {
            this.metadata.set("energy", nbt.func_74769_h("energy"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound tankCompound = new NBTTagCompound();
        this.tank.writeToNBT(tankCompound);
        nbt.func_74782_a("tank", (NBTBase)tankCompound);
        nbt.func_74780_a("energy", ((Double)this.metadata.get("energy")).doubleValue());
    }

    @Override
    public void think() {
        if (!this.field_145850_b.field_72995_K) {
            List<String> ifaces = ReflectionHelper.getInterfacesOf(this.getClass(), true);
            if (!this.addedToEnergyNet && (ifaces.contains("ic2.api.energy.tile.IEnergyEmitter") || ifaces.contains("ic2.api.energy.tile.IEnergyAcceptor"))) {
                this.postIC2Update(true);
                this.stateChanged();
            }
            if (this.tank.hasChanged()) {
                this.stateChanged();
            }
            this.refuel();
        }
    }

    public void stateChanged() {
        this.func_70296_d();
    }

    public void refuel() {
        ItemStack stack;
        ItemEnergyCrystal crystal;
        if (this.isEnabled() && 10.0 > (Double)this.metadata.get("energy") + 1.0) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stackOf = this.inventory.func_70301_a(i);
                if (stackOf == null || stackOf.field_77994_a <= 0) continue;
                ItemStack newStack = stackOf.func_77946_l();
                --newStack.field_77994_a;
                if (newStack.field_77994_a > 0) {
                    this.inventory.func_70299_a(i, newStack);
                } else {
                    this.inventory.func_70299_a(i, null);
                }
                this.metadata.set("energy", (Double)this.metadata.get("energy") + 1.0);
                this.stateChanged();
                break;
            }
        }
        if (this.isEnabled() && 10.0 > (Double)this.metadata.get("energy") + 0.1 && this.tank.getFluidAmount() > 100 && this.tank.drain((int)100, (boolean)false).amount == 100) {
            this.tank.drain(100, true);
            this.metadata.set("energy", (Double)this.metadata.get("energy") + 0.1);
            this.stateChanged();
        }
        if (this.isEnabled() && this.inventory.func_70301_a(4) != null && (crystal = (ItemEnergyCrystal)(stack = this.inventory.func_70301_a(4)).func_77973_b()).getMaximumEnergy() > crystal.getEnergyStored(stack) && (Double)this.metadata.get("energy") > 0.01) {
            double used = crystal.receiveEnergy(stack, 0.01, false);
            this.metadata.set("energy", (Double)this.metadata.get("energy") - used);
        }
    }

    public void func_145843_s() {
        List<String> ifaces = ReflectionHelper.getInterfacesOf(this.getClass(), true);
        if (this.addedToEnergyNet && (ifaces.contains("ic2.api.energy.tile.IEnergyEmitter") || ifaces.contains("ic2.api.energy.tile.IEnergyAcceptor"))) {
            this.postIC2Update(false);
            this.func_70296_d();
        }
        super.func_145843_s();
    }

    @Override
    public boolean canReceiveEnergy() {
        return false;
    }

    @Override
    public boolean canExportEnergy() {
        return true;
    }

    @Override
    public double getMaximumReceiveEnergy() {
        return 0.0;
    }

    @Override
    public double getMaximumExportEnergy() {
        return 0.1;
    }

    @Override
    public double getAvailableExportEnergy() {
        if (!this.isActive() || !this.isEnabled()) {
            return 0.0;
        }
        return Math.min((Double)this.metadata.get("energy"), this.getMaximumExportEnergy());
    }

    @Override
    public void receiveEnergy(double units) {
    }

    @Override
    public double exportEnergy(double units) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        double reallyExportedUnits = Math.min(units, (Double)this.metadata.get("energy"));
        this.metadata.set("energy", (Double)this.metadata.get("energy") - reallyExportedUnits);
        return reallyExportedUnits;
    }

    public boolean isActive() {
        return this.isEnabled() && (Double)this.metadata.get("energy") > 0.0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.getID() == this.tank.getFluid().fluidID && this.tank.canFill();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid.getID() == this.tank.getFluid().fluidID && this.tank.canDrain();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public boolean canEnergyFormatConnectToSide(EnumUnits typeof, ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean isEnabled() {
        if (!this.metadata.containsKey("simulating")) {
            return false;
        }
        return (Boolean)this.metadata.get("simulating");
    }

    @Override
    public boolean setEnabled(boolean enable) {
        this.metadata.set("simulating", enable);
        return true;
    }

    @Override
    public double getStoredEnergy() {
        if (!this.isEnabled() || !this.metadata.containsKey("energy")) {
            return 0.0;
        }
        return (Double)this.metadata.get("energy");
    }

    @Override
    public double getStoredEnergy(EnumUnits unitsOf) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        return EnumUnits.convertFromNaquadahUnit(unitsOf, (Double)this.metadata.get("energy"));
    }

    @Override
    public double getMaximumStoredEnergy() {
        return 10.0;
    }

    public void onHostBlockBreak() {
    }

    public void setRedstoneInputSignal(int sig) {
        this.metadata.set("simulating", sig > 0);
    }

    @Override
    public void thinkPacket(ModPacket packet, EntityPlayer player) {
    }

    @Override
    public void detectAndSendChanges() {
    }
}

