/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.power.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import pcl.lc.base.energy.IItemEnergyStore;
import pcl.lc.core.ResourceAccess;

public class ItemEnergyCrystal
extends Item
implements IItemEnergyStore {
    public ItemEnergyCrystal() {
        this.func_77627_a(false);
        this.func_77625_d(1);
        this.func_77656_e(21);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111208_A() {
        return ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "energy_crystal");
    }

    @Override
    public double getMaximumEnergy() {
        return 128.0;
    }

    @Override
    public double getMaximumIOPayload() {
        return 1.0;
    }

    @Override
    public double receiveEnergy(ItemStack itemStack, double quantity, boolean isSimulated) {
        if (quantity > this.getMaximumIOPayload()) {
            quantity = this.getMaximumIOPayload();
        }
        double actualPayload = Math.min(this.getMaximumEnergy() - this.getEnergyStored(itemStack), quantity);
        if (!isSimulated) {
            this.setEnergyStored(itemStack, this.getEnergyStored(itemStack) + actualPayload);
        }
        this.updateDisplay(itemStack);
        return actualPayload;
    }

    @Override
    public double extractEnergy(ItemStack itemStack, double quantity, boolean isSimulated) {
        if (quantity > this.getMaximumIOPayload()) {
            quantity = this.getMaximumIOPayload();
        }
        double actualPayload = Math.min(this.getEnergyStored(itemStack), quantity);
        if (!isSimulated) {
            this.setEnergyStored(itemStack, this.getEnergyStored(itemStack) - actualPayload);
        }
        this.updateDisplay(itemStack);
        return actualPayload;
    }

    @Override
    public double getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_74764_b("stored-energy")) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("stored-energy");
    }

    @Override
    public void setEnergyStored(ItemStack itemStack, double value) {
        this.updateDisplay(itemStack);
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74780_a("stored-energy", value);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        double energy = 100.0 * this.getEnergyStored(par1ItemStack) / this.getMaximumEnergy();
        par3List.add(String.format("Energy: %.2f%%", energy));
    }

    private void updateDisplay(ItemStack stack) {
        double ratio = this.getEnergyStored(stack) / this.getMaximumEnergy();
        stack.func_77964_b(21 - (int)Math.floor(20.0 * ratio));
    }
}

