/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.power.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pcl.lc.LanteaCraft;
import pcl.lc.base.RotationOrientedBlock;
import pcl.lc.core.ResourceAccess;
import pcl.lc.module.ModulePower;
import pcl.lc.module.power.tile.TileNaquadahGenerator;

public class BlockNaquadahGenerator
extends RotationOrientedBlock {
    IIcon topTexture;
    IIcon bottomTexture;
    IIcon sideTexture;

    public BlockNaquadahGenerator() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_149641_N() {
        return ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", this.func_149739_a());
    }

    @Override
    public void func_149651_a(IIconRegister register) {
        this.topTexture = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "controller_top"));
        this.bottomTexture = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "controller_bottom"));
        this.sideTexture = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", "controller_side"));
    }

    public IIcon func_149691_a(int side, int data) {
        switch (side) {
            case 0: {
                return this.bottomTexture;
            }
            case 1: {
                return this.topTexture;
            }
        }
        return this.sideTexture;
    }

    @Override
    public int func_149645_b() {
        if (ModulePower.Render.blockNaquadahGeneratorRenderer != null) {
            return ModulePower.Render.blockNaquadahGeneratorRenderer.renderID;
        }
        return 0;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        int dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, dir, 0);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        TileNaquadahGenerator cte = (TileNaquadahGenerator)this.getTileEntity((IBlockAccess)world, x, y, z);
        cte.onHostBlockBreak();
        super.func_149749_a(world, x, y, z, block, data);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileNaquadahGenerator te = (TileNaquadahGenerator)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            player.openGui((Object)LanteaCraft.getInstance(), LanteaCraft.EnumGUIs.NaquadahGenerator.ordinal(), world, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileNaquadahGenerator();
    }

    public void func_149726_b(World world, int x, int y, int z) {
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            int sig = 0;
            int a = this.isBlockProvidingPower(world, x, y + 1, z, 1);
            int b = this.isBlockProvidingPower(world, x, y - 1, z, 0);
            int c = this.isBlockProvidingPower(world, x, y, z + 1, 3);
            int d = this.isBlockProvidingPower(world, x, y, z - 1, 2);
            int e = this.isBlockProvidingPower(world, x + 1, y, z, 5);
            int f = this.isBlockProvidingPower(world, x - 1, y, z, 4);
            sig = Math.max(a, Math.max(b, Math.max(c, Math.max(d, Math.max(e, f)))));
            TileNaquadahGenerator cte = (TileNaquadahGenerator)this.getTileEntity((IBlockAccess)world, x, y, z);
            cte.setRedstoneInputSignal(sig);
        }
    }

    private int isBlockProvidingPower(World world, int x, int y, int z, int direction) {
        if (y >= 0 && y < world.func_72800_K()) {
            int redstoneWireValue = world.func_147439_a(x, y, z).equals(Blocks.field_150488_af) ? world.func_72805_g(x, y, z) : 0;
            int indirectPowerTo = world.func_72878_l(x, y, z, direction);
            int directPowerTo = world.func_72879_k(x, y, z, direction);
            return Math.max(Math.max(redstoneWireValue, indirectPowerTo), directPowerTo);
        }
        return 0;
    }
}

