/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.api.internal.IModule;
import pcl.lc.cfg.ConfigHelper;
import pcl.lc.cfg.ConfigNode;
import pcl.lc.cfg.DOMHelper;
import pcl.lc.cfg.ModuleConfig;
import pcl.lc.core.ModuleManager;
import pcl.lc.core.ResourceAccess;
import pcl.lc.module.galaxy.IDimension;
import pcl.lc.module.galaxy.MapGenFeatureStructureStart;
import pcl.lc.module.galaxy.abydos.AbydosDimension;

public class ModuleGalaxy
implements IModule {
    public static final int __TMP_ABYDOS_IDX = 5;
    public static final int __TMP_ABYDOX_BMX = 1;

    @Override
    public Set<ModuleManager.Module> getDependencies() {
        return EnumSet.of(ModuleManager.Module.CORE, ModuleManager.Module.CRITTERS, ModuleManager.Module.DECOR, ModuleManager.Module.STARGATE);
    }

    @Override
    public Set<ModuleManager.Module> getLoadDependenciesAfter() {
        return EnumSet.of(ModuleManager.Module.CORE, ModuleManager.Module.CRITTERS, ModuleManager.Module.DECOR, ModuleManager.Module.STARGATE);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ModuleConfig config = ModuleManager.getConfig(this);
        ArrayList<ConfigNode> dimensionMap = ConfigHelper.findAllConfigByClass(config, "Dimension");
        HashMap<String, DimensionConfig> dimensionConfigs = new HashMap<String, DimensionConfig>();
        for (ConfigNode node : dimensionMap) {
            DimensionConfig setup = (DimensionConfig)node;
            dimensionConfigs.put(setup.parameters().get("name").toString(), setup);
        }
        MapGenStructureIO.func_143034_b(MapGenFeatureStructureStart.class, (String)ResourceAccess.formatResourceName("${ASSET_KEY}:LanteaCraft", new Object[0]));
        for (Dimension dimension : Dimension.values()) {
            DimensionConfig dimensionSettings = (DimensionConfig)dimensionConfigs.get(dimension.name());
            if (dimensionSettings == null) {
                dimensionSettings = new DimensionConfig("Dimension", config);
                dimensionSettings.parameters().put("name", dimension.name());
                dimensionSettings.parameters().put("enabled", "true");
                config.children().add(dimensionSettings);
                dimensionSettings.modify();
            }
            if (!DOMHelper.popBoolean(dimensionSettings.parameters().get("enabled").toString(), false)) continue;
            try {
                dimensionSettings.setDimension(dimension);
                Constructor<?> dimensionCtr = dimension.registrar.getConstructor(DimensionConfig.class);
                dimension.dimensionInstance = (IDimension)dimensionCtr.newInstance(dimensionSettings);
            }
            catch (Throwable t) {
                LanteaCraft.getLogger().log(Level.WARN, "Error when setting up dimension.", t);
            }
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static class DimensionConfig
    extends ConfigNode {
        private Dimension dimension;

        public DimensionConfig(String name, ConfigNode parent) {
            super(name, parent);
        }

        public void setDimension(Dimension dimension) {
            this.dimension = dimension;
        }

        public int getProviderId() {
            if (!this.parameters().containsKey("providerId")) {
                this.parameters().put("providerId", this.dimension.defaultProviderId);
                this.modify();
            }
            return Integer.parseInt(this.parameters().get("providerId").toString());
        }

        public int getDimensionId() {
            if (!this.parameters().containsKey("dimensionId")) {
                this.parameters().put("dimensionId", this.dimension.defaultDimensionId);
                this.modify();
            }
            return Integer.parseInt(this.parameters().get("dimensionId").toString());
        }
    }

    public static enum Dimension {
        ABYDOS(AbydosDimension.class, 3, 3);

        public final Class<?> registrar;
        public final int defaultDimensionId;
        public final int defaultProviderId;
        public IDimension dimensionInstance;

        private Dimension(Class<?> clazz, int defaultDimensionIdx, int defaultProviderIdx) {
            this.registrar = clazz;
            this.defaultDimensionId = defaultDimensionIdx;
            this.defaultProviderId = defaultProviderIdx;
        }
    }
}

