/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.coremod;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import pcl.lc.coremod.LCCoreMod;

public class LCCoreTransformer
implements IClassTransformer {
    private final List<IClassTransformer> transformers;
    public static boolean ASM_SUCCESS = false;

    public LCCoreTransformer() {
        ASM_SUCCESS = true;
        String[] tnames = LCCoreMod.getTransformers();
        this.transformers = new ArrayList<IClassTransformer>(tnames.length);
        for (String transformer : tnames) {
            try {
                this.transformers.add((IClassTransformer)Class.forName(transformer).newInstance());
                LCCoreMod.getLogger().log(Level.DEBUG, "Instantiated transformer " + transformer);
            }
            catch (Throwable e) {
                LCCoreMod.getLogger().log(Level.WARN, "Could not instantiate transformer " + transformer);
                e.printStackTrace();
            }
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        for (IClassTransformer transformer : this.transformers) {
            try {
                if ((bytes = transformer.transform(name, transformedName, bytes)) != null) continue;
                LCCoreMod.getLogger().log(Level.FATAL, "Transformer " + transformer + " corrupted class " + name);
            }
            catch (Throwable e) {
                LCCoreMod.getLogger().log(Level.WARN, "Could not transform class " + name + " using " + transformer);
                e.printStackTrace();
            }
        }
        return bytes;
    }
}

