/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.coremod;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import pcl.lc.coremod.LCCoreMod;

public class ClassOptionalTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        ArrayList<String> interfaceList = new ArrayList<String>();
        for (MethodNode method : classNode.methods) {
            if (method.visibleAnnotations == null) continue;
            for (AnnotationNode a : method.visibleAnnotations) {
                if (!a.desc.equals("Lpcl/common/asm/RuntimeAnnotation$RuntimeInterface;")) continue;
                int k = a.values.indexOf("modid");
                int l = a.values.indexOf("clazz");
                String modname = (String)a.values.get(k + 1);
                String iface = (String)a.values.get(l + 1);
                if (Loader.isModLoaded((String)modname)) {
                    if (interfaceList.contains(iface)) continue;
                    LCCoreMod.getLogger().log(Level.DEBUG, String.format("Adding interface %s because mod %s is loaded.", iface, modname));
                    interfaceList.add(iface);
                    continue;
                }
                LCCoreMod.getLogger().log(Level.DEBUG, String.format("Skipping interface %s because mod %s is not loaded.", iface, modname));
            }
        }
        if (interfaceList.size() > 0) {
            LCCoreMod.getLogger().log(Level.DEBUG, String.format("Performing total %s ASM operations...", interfaceList.size()));
            for (String iface : interfaceList) {
                this.addInterface(classNode, iface);
            }
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private void addInterface(ClassNode clazz, String iface) {
        try {
            Class.forName(iface);
            iface = iface.replace(".", "/");
            if (!clazz.interfaces.contains(iface)) {
                clazz.interfaces.add(iface);
            }
        }
        catch (ClassNotFoundException notfound) {
            LCCoreMod.getLogger().log(Level.WARN, String.format("Attempted to load interface %s into class %s, but it does not exist!", iface, clazz.name));
        }
    }

    private boolean modLoaded(String name, String minVersion, String exactVersion, String maxVersion) {
        Object o2;
        Object o1;
        int k;
        Map mods = Loader.instance().getIndexedModList();
        if (!mods.keySet().contains(name)) {
            return false;
        }
        ModContainer container = (ModContainer)mods.get(name);
        if (exactVersion != null) {
            return container.getVersion().equals(exactVersion);
        }
        Object[] v0 = this.parseVersion(container.getVersion());
        Object[] v1 = null;
        Object[] v2 = null;
        if (minVersion != null) {
            v1 = this.parseVersion(minVersion);
        }
        if (maxVersion != null) {
            v2 = this.parseVersion(maxVersion);
        }
        if (v1 != null && v0.length != v1.length) {
            return false;
        }
        if (v2 != null && v0.length != v2.length) {
            return false;
        }
        if (v1 != null) {
            for (k = 0; k < v0.length; ++k) {
                if (v0[k].getClass().equals(v1[k].getClass())) continue;
                return false;
            }
        }
        if (v2 != null) {
            for (k = 0; k < v0.length; ++k) {
                if (v0[k].getClass().equals(v2[k].getClass())) continue;
                return false;
            }
        }
        if (v1 != null) {
            for (k = 0; k < v0.length; ++k) {
                o1 = v0[k];
                o2 = v1[k];
                if (o1 instanceof String || !(o1 instanceof Integer)) continue;
                if ((Integer)o2 > (Integer)o1) {
                    return false;
                }
                return false;
            }
        }
        if (v2 != null) {
            for (k = 0; k < v0.length; ++k) {
                o1 = v0[k];
                o2 = v2[k];
                if (o1 instanceof String || !(o1 instanceof Integer)) continue;
                if ((Integer)o2 < (Integer)o1) {
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private Object[] parseVersion(String version) {
        ArrayList<Object> result = new ArrayList<Object>();
        char[] data = version.trim().toCharArray();
        int c0 = this.countOf(data, '.');
        int c1 = this.countOf(data, '-');
        int c2 = 0;
        char sep = c0 > c1 ? (char)'.' : '-';
        do {
            boolean flag0;
            boolean bl = flag0 = !Character.isDigit(data[0]);
            if (flag0) {
                StringBuilder b0 = new StringBuilder();
                while (c2 < data.length && data[c2] != sep) {
                    b0.append(data[c2++]);
                }
                ++c2;
                result.add(b0.toString());
                continue;
            }
            StringBuilder b1 = new StringBuilder();
            while (c2 < data.length && data[c2] != sep) {
                b1.append(data[c2++]);
            }
            ++c2;
            result.add(Integer.parseInt(b1.toString()));
        } while (c2 < data.length);
        return result.toArray();
    }

    private int countOf(char[] d, char c) {
        int j = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i] != c) continue;
            ++j;
        }
        return j;
    }
}

