/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;

public class WorldLog {
    private final File file;
    private FileOutputStream outstream;
    private PrintStream outwrapper;

    public WorldLog(File file) {
        this.file = file;
    }

    public void open() {
        try {
            if (this.outstream != null || this.outwrapper != null) {
                throw new IOException("Can't reopen an existing WorldLog.");
            }
            this.outstream = new FileOutputStream(this.file, true);
            this.outwrapper = new PrintStream(this.outstream);
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARN, "Could not create WorldLog, an error occured.", (Throwable)ioex);
        }
    }

    public void close() {
        try {
            if (this.outwrapper != null) {
                this.outwrapper.flush();
                this.outwrapper.close();
            }
            if (this.outstream != null) {
                this.outstream.flush();
                this.outstream.close();
            }
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARN, "Could not close WorldLog, an error occured.", (Throwable)ioex);
        }
    }

    public void log(Level level, String message) {
        try {
            if (this.outwrapper == null) {
                return;
            }
            StringBuilder formatter = new StringBuilder();
            formatter.append("[").append(level).append("]");
            formatter.append(" ").append(message);
            this.outwrapper.println(formatter.toString());
        }
        catch (Throwable ioex) {
            LanteaCraft.getLogger().log(Level.WARN, "Could not write to WorldLog, an error occured.", ioex);
        }
    }
}

